# =============================
# ✅ 脚本功能：读取一个 DER 格式的私钥文件 和 一个 DER 格式的公钥文件，
#              将它们的二进制内容按指定格式打印为十六进制（每行16字节，0xXX,）
#              格式：[私钥 DER] 和 [公钥 DER] 分别打印，清晰可辨
# =============================

def print_der_hex_bytes(der_bytes, label):
    """
    按指定格式打印 DER 二进制数据：
    - 每行16个字节
    - 每个字节为 0xXX
    - 字节间用 ', ' 分隔
    - 每行最多16字节，不足也打印
    - 前面带标签，如 [私钥 DER]
    """
    print(f"[{label}]")
    hex_list = [f"0x{b:02X}" for b in der_bytes]
    for i in range(0, len(hex_list), 16):
        line = hex_list[i:i + 16]
        print(", ".join(line) + ("," if i + 16 < len(hex_list) else ""))
    print()  # 打印空行分隔

def main():
    # ===========================
    # === 请根据你的实际 DER 文件路径修改下面两个变量 ===
    # ===========================
    private_key_der_path = "C:\\Users\\17437\\Desktop\\vsCodeRsa\\RSA_private_key_to.der"  # 🔧 你的 DER 格式私钥文件路径
    public_key_der_path  = "C:\\Users\\17437\\Desktop\\vsCodeRsa\\RSA_public_key_to.der"   # 🔧 你的 DER 格式公钥文件路径

    # ===========================
    # === 1. 读取并打印 私钥 DER 文件 ===
    # ===========================
    print(f"[*] 正在读取私钥 DER 文件: {private_key_der_path}")
    try:
        with open(private_key_der_path, 'rb') as f:
            private_der_bytes = f.read()
        print("[+] ✅ 私钥 DER 文件读取成功")
        print_der_hex_bytes(private_der_bytes, label="私钥 DER")
    except Exception as e:
        print("[-] ❌ 读取或解析私钥 DER 文件失败：")
        print(f"    - 文件路径是否正确？文件是否存在？")
        print(f"    - 错误详情: {e}")
        print()

    # ===========================
    # === 2. 读取并打印 公钥 DER 文件 ===
    # ===========================
    print(f"[*] 正在读取公钥 DER 文件: {public_key_der_path}")
    try:
        with open(public_key_der_path, 'rb') as f:
            public_der_bytes = f.read()
        print("[+] ✅ 公钥 DER 文件读取成功")
        print_der_hex_bytes(public_der_bytes, label="公钥 DER")
    except Exception as e:
        print("[-] ❌ 读取或解析公钥 DER 文件失败：")
        print(f"    - 文件路径是否正确？文件是否存在？")
        print(f"    - 错误详情: {e}")
        print()

    print("[*] 所有操作完成。")

# =============================
# ✅ 入口
# =============================
if __name__ == "__main__":
    main()