#include <stdio.h>
#include <stdint.h>
#include <string.h>

// 输出每行16个字节的十六进制数（用0x前缀，逗号分隔）
void format_and_print_hex(const char *hex_str) {
    size_t len = strlen(hex_str);

    // 每行最多输出16个字节
    size_t bytes_per_line = 16;

    // 遍历每两个字符（一个字节），并输出
    for (size_t i = 0; i < len; i += 2) {
        // 将十六进制字符转换为整数
        unsigned int byte;
        sscanf(hex_str + i, "%2x", &byte);

        // 每16个字节输出换行并补上逗号
        if (i > 0 && (i / 2) % bytes_per_line == 0) {
            printf(",\n"); // 每16个字节换行并添加逗号
        }

        // 在第一个字节前不加逗号
        if (i > 0 && (i / 2) % bytes_per_line != 0) {
            printf(", ");  // 每个字节后面加逗号，除了第一个字节
        }

        // 打印当前字节，前缀0x
        printf("0x%02X", byte);
    }

    printf("\n");
}

int main() {
    // 示例输入：你可以根据需要更改这个值
    const char *hex_str = "3e3ca6aca92203bc310f7199e887bd4c006cacab5647e4ff6258215ba9340f22e4d421b0e534f897a9b9991021b66835568be2d8e3130dc2963f9a65a31e2bffb719a448e9f37ec0fd9924b3d4c07efd3a7796f0970f97529c63983604ce57a463ef05b9a4e9245e3011096d374f455cefa4e64eac73b6ec3232410412dda5eef4776dc56d40a6ee677c0ce312d0a947ccf23b6678bef1945dcf4b14ce603e60308af50069b04f1d87de155d8f0d5614acfcda4994a2759df2fa1eb529bccd53ba8260a6e546b641375e8762fc90978400884070aebec4343ffa45aefea58469df85b7a92b7e0a730d1649b879d394c5c1593f918440deb15b4b63140f39210515f53bd7d3b81effaddf642be30aadb57e0103d6ae3f161d2a6c64f516d749fd7cf1e33b257a921baf5e1c877766913cdd1057f582eaf65c6f8d85abd9f0780668e2696f67bae78667fca038b13cd5ee9e49a6b07343a4f27ac37b61a0ebac20a76f86b79f52ea3e233aa9c4be9b822a5fb4946ebce34a179bdae33fea883d93";  // 示例十六进制字符串（实际输入）

    // 调用函数输出格式化的十六进制
    format_and_print_hex(hex_str);

    return 0;
}
