/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file IntrCtrl_Lld_Cfg.c
 * @brief 
 * 
 */



#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
                                         INCLUDE FILES
==================================================================================================*/
#include "IntCtrl_Lld_Cfg.h"
/*==================================================================================================
*                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define PLATFORM_INTCTRL_LLD_CFG_VENDOR_ID_C                          (180)
#define PLATFORM_INTCTRL_LLD_CFG_SW_MAJOR_VERSION_C                   (2)
#define PLATFORM_INTCTRL_LLD_CFG_SW_MINOR_VERSION_C                   (3)
#define PLATFORM_INTCTRL_LLD_CFG_SW_PATCH_VERSION_C                   (0)
/*==================================================================================================
                                      FILE VERSION CHECKS
==================================================================================================*/
/* Check if current file and IntCtrl_Lld_Cfg header file are of the same vendor */
#if (PLATFORM_INTCTRL_LLD_CFG_VENDOR_ID_C != PLATFORM_INTCTRL_LLD_CFG_VENDOR_ID)
    #error "IntCtrl_Lld_Cfg.c and IntCtrl_Lld_Cfg.h have different vendor ids"
#endif

/* Check if current file and IntCtrl_Lld_Cfg header file are of the same Software version */
#if ((PLATFORM_INTCTRL_LLD_CFG_SW_MAJOR_VERSION_C != PLATFORM_INTCTRL_LLD_CFG_SW_MAJOR_VERSION) || \
     (PLATFORM_INTCTRL_LLD_CFG_SW_MINOR_VERSION_C != PLATFORM_INTCTRL_LLD_CFG_SW_MINOR_VERSION) || \
     (PLATFORM_INTCTRL_LLD_CFG_SW_PATCH_VERSION_C != PLATFORM_INTCTRL_LLD_CFG_SW_PATCH_VERSION) \
    )
    #error "Software Version Numbers of IntCtrl_Lld_Cfg.c and IntCtrl_Lld_Cfg.h are different"
#endif
/*==================================================================================================
                                       GLOBAL VARIABLES
==================================================================================================*/
#define PLATFORM_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "Platform_MemMap.h"

/* List of configurations for interrupts */
PLATFORM_CONST static const IntCtrl_Lld_IrqConfigType IrqConfig[] = {
    {   .IrqNumber    = DMA0_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = DMA1_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = DMA2_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = DMA3_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = DMA_Error_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = EFM_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = EFM_Error_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = PCU_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = EFM_Ecc_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = WDG_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = I2C0_Master_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = I2C0_Slave_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = SPI0_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = SPI1_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = SPI2_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = I2C1_Master_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = UART0_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 3,   
    },
    {   .IrqNumber    = UART1_IRQn,
        .IrqEnabled   = (boolean)STD_ON,
        .IrqPriority = 3,   
    },
    {   .IrqNumber    = UART2_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = ADC0_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = ACMP0_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = EMU_SB_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = EMU_DB_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = pTMR_Ch0_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = pTMR_Ch1_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = pTMR_Ch2_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = pTMR_Ch3_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = SCU_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = lpTMR0_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = GPIOA_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = GPIOB_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = GPIOC_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = GPIOD_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = GPIOE_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = CAN0_ORed_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = CAN0_Error_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = CAN0_Wake_Up_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = CAN0_ORed_0_15_MB_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = CAN0_ORed_16_31_MB_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = CAN0_ORed_32_47_MB_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = CAN0_ORed_48_63_MB_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = CAN1_ORed_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = CAN1_Error_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = CAN1_Wake_Up_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = CAN1_ORed_0_15_MB_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = CAN1_ORed_16_31_MB_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = CAN1_ORed_32_47_MB_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = CAN1_ORed_48_63_MB_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = eTMR0_Ch0_Ch1_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = eTMR0_Ch2_Ch3_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = eTMR0_Ch4_Ch5_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = eTMR0_Ch6_Ch7_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = eTMR0_Fault_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = eTMR0_Ovf_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = eTMR1_Ch0_Ch1_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = eTMR1_Ch2_Ch3_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = eTMR1_Ch4_Ch5_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = eTMR1_Ch6_Ch7_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = eTMR1_Fault_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = eTMR1_Ovf_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = MPWM0_Ch0_Ovf_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = MPWM0_Ch1_Ovf_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = MPWM0_Ch2_Ovf_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = MPWM0_Ch3_Ovf_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = MPWM0_Ch4_Ovf_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = MPWM0_Ch5_Ovf_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = MPWM0_Ch6_Ovf_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = MPWM0_Ch7_Ovf_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = MPWM0_Ch0_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = MPWM0_Ch1_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = MPWM0_Ch2_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = MPWM0_Ch3_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = MPWM0_Ch4_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = MPWM0_Ch5_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = MPWM0_Ch6_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = MPWM0_Ch7_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = TRNG_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
    {   .IrqNumber    = HCU_IRQn,
        .IrqEnabled   = (boolean)STD_OFF,
        .IrqPriority = 7,   
    },
};

/* Configuration structure for interrupt controller */
PLATFORM_CONST const IntCtrl_Lld_CtrlConfigType IntCtrlConfig = {
    .ConfigIrqCount = 78U,
#if (INTCTRL_LLD_ENABLE_VTOR_CONFIG == STD_ON)
    .VectorTableAddress = 536838144U,
#endif
    .IrqConfig        = IrqConfig  
};


#define PLATFORM_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "Platform_MemMap.h"

#ifdef __cplusplus
}
#endif

