/* USER CODE BEGIN Header */
/* you can remove the copyright */

/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 *
 * @file main.c
 * @brief
 *
*/

/* USER CODE END Header */
#include "Mcal.h"
/* Includes ------------------------------------------------------------------*/

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */
/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN PTD */
/* USER CODE END PTD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */
/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */
/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/
/* USER CODE BEGIN PV */
/*CRC calculation results of these 7sets of date must be provided according to AUTOSRA specification.*/
const uint8 testMessage[7][9] = {{0x00, 0x00, 0x00, 0x00},
    {0xF2, 0X01, 0X83},
    {0X0F, 0XAA, 0X00, 0X55},
    {0X00, 0XFF, 0X55, 0X11},
    {0X33, 0X22, 0X55, 0XAA, 0XBB, 0XCC, 0XDD, 0XEE, 0XFF},
    {0X92, 0X6B, 0X55},
    {0XFF, 0XFF, 0XFF, 0XFF}
};
/*Length of testMessage[0]--testMessage[6]*/
const uint8 length[7] = {4, 3, 4, 4, 9, 3, 4};
/*These are CrcResults.*/
const uint64 CrcResult[7][7] =
{
    {0x59, 0x37, 0x79, 0xB8, 0xCB, 0x8C, 0x74},/*Holds 7 results that API Crc_CalculateCRC8() calculate.*/
    {0x12, 0xC2, 0xC6, 0x77, 0x11, 0x33, 0x6C},/*Holds 7 results that API Crc_CalculateCRC8H2F() calculate.*/
    {0x84C0, 0xD374, 0x2023, 0xB8F9, 0xF53F, 0x0745, 0x1D0F},/*Holds 7 results that API Crc_CalculateCRC16() calculate.*/
    {0x0000, 0xC2E1, 0x0BE3, 0x6CCF, 0xAE98, 0xE24E, 0x9401},/*Holds 7 results that API Crc_CalculateCRC16ARC() calculate.*/
    {0x2144DF1C, 0x24AB9D77, 0xB6C9B287, 0x32A06212, 0xB0AE863D, 0x9CDEA29B, 0xFFFFFFFF},/*Holds 7 results that API Crc_CalculateCRC32() calculate.*/
    {0x6FB32240, 0x4F721A25, 0x20662DF8, 0x9BD7996E, 0xA65A343D, 0xEE688A78, 0xFFFFFFFF},/*Holds 7 results that API Crc_CalculateCRC32P4() calculate.*/
    {0xF4A586351E1B9F4B, 0x319C27668164F1C6, 0x54C5D0F7667C1575, 0xA63822BE7E0704E6, 0x701ECEB219A8E5D5, 0x5FAA96A9B59F3E4E, 0xFFFFFFFF00000000}/*Holds 7 results that API Crc_CalculateCRC64() calculate.*/
};
uint8 crc8_result;/*holds temp date*/
uint16 crc16_result;/*holds temp date*/
uint32 crc32_result;/*holds temp date*/
uint64 crc64_result;/*holds temp date*/
/* USER CODE END PV */

/* Private function declare --------------------------------------------------*/
/* USER CODE BEGIN PFDC */
void Mcal_TestCrc(void);
/* USER CODE END PFDC */
static void Board_Init(void);

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */
/* USER CODE END 0 */


/**
 * @brief  The application entry point.
 * @retval int
 */
int main(void)
{
    /* USER CODE BEGIN 1 */
    Mcu_Init(&Mcu_Config);
    Mcu_InitClock(0);
#if (MCU_NO_PLL == STD_OFF)
    while (MCU_PLL_LOCKED != Mcu_GetPllStatus())
    {
        /*Busy wait until the System Pll is locked*/
    }
    Mcu_DistributePllClock();
#endif
    /* USER CODE END 1 */ 
    Board_Init();
    /* USER CODE BEGIN 2 */
    /* USER CODE END 2 */

    /* Infinite loop */
    /* USER CODE BEGIN WHILE */
    while (1)
    {
        /* USER CODE END WHILE */
        /* USER CODE BEGIN 3 */
        Mcal_TestCrc();
    }
    /* USER CODE END 3 */
}

static void Board_Init(void)
{
}

/* USER CODE BEGIN 4 */
void Mcal_TestCrc(void)
{
    uint8 i;
    for (i = 0; i < 7; i++)
    {
        /*Call API Crc_CalculateCRC8(...),then calculate crc*/
        crc8_result = Crc_CalculateCRC8((const uint8 *)&testMessage[i], length[i], 0x00, TRUE);
        if (crc8_result != (uint8)CrcResult[0][i])
        {
            /*Compare*/
            while (1);
        }
        else {;}
    }
    for (i = 0; i < 7; i++)
    {
        /*Call API Crc_CalculateCRC8H2F(...),then calculate crc*/
        crc8_result = Crc_CalculateCRC8H2F((const uint8 *)&testMessage[i], length[i], 0x00, TRUE);
        if (crc8_result != (uint8)CrcResult[1][i])
        {
            /*Compare*/
            while (1);
        }
        else {;}
    }
    for (i = 0; i < 7; i++)
    {
        /*Call API Crc_CalculateCRC16(...),then calculate crc*/
        crc16_result = Crc_CalculateCRC16((const uint8 *)&testMessage[i], length[i], 0x00, TRUE);
        if (crc16_result != (uint16)CrcResult[2][i])
        {
            /*Compare*/
            while (1);
        }
        else {;}
    }
    for (i = 0; i < 7; i++)
    {
        /*Call API Crc_CalculateCRC16ARC(...),then calculate crc*/
        crc16_result = Crc_CalculateCRC16ARC((const uint8 *)&testMessage[i], length[i], 0x00, TRUE);
        if (crc16_result != (uint16)CrcResult[3][i])
        {
            /*Compare*/
            while (1);
        }
        else {;}
    }
    for (i = 0; i < 7; i++)
    {
        /*Call API Crc_CalculateCRC32(...),then calculate crc*/
        crc32_result = Crc_CalculateCRC32((const uint8 *)&testMessage[i], length[i], 0x00, TRUE);
        if (crc32_result != (uint32)CrcResult[4][i])
        {
            /*Compare*/
            while (1);
        }
        else {;}
    }
    for (i = 0; i < 7; i++)
    {
        /*Call API Crc_CalculateCRC32P4(...),then calculate crc*/
        crc32_result = Crc_CalculateCRC32P4((const uint8 *)&testMessage[i], length[i], 0x00, TRUE);
        if (crc32_result != (uint32)CrcResult[5][i])
        {
            /*Compare*/
            while (1);
        }
        else {;}
    }
    for (i = 0; i < 7; i++)
    {
        /*Call API Crc_CalculateCRC64(...),then calculate crc*/
        crc64_result = Crc_CalculateCRC64((const uint8 *)&testMessage[i], length[i], 0x00, TRUE);
        if (crc64_result != (uint64)CrcResult[6][i])
        {
            /*Compare*/
            while (1);
        }
        else {;}
    }
}
/* USER CODE END 4 */
