/*
* @file    SchM_Crc.h
*==================================================================================================
*   Project              : YTMicro AUTOSAR 4.4.0 MCAL
*   Platform             : ARM
*   Peripheral           : SchM_Crc
*   Dependencies         : none
*
*   Autosar Version      : V4.4.0
*   Autosar Revision     : ASR_REL_4_4_REV_0000
*   SW Version           : V2.3.0
*
*   (c) Copyright 2020-2025 Yuntu Microelectronics co.,ltd.
*   All Rights Reserved.
==================================================================================================*/

#ifndef SCHM_CRC_H
#define SCHM_CRC_H

/**
*   @file    SchM_Crc.h
*
*   @addtogroup SCHM_CRC_MODULE
*   @{
*/

#ifdef __cplusplus
extern "C" {
#endif

/* PRQA S 0777,0779 EOF */
/*==================================================================================================
                                              INCLUDE FILES
==================================================================================================*/
#include "Crc_Cfg.h"
/*==================================================================================================
                                      HEADER FILE VERSION INFORMATION
==================================================================================================*/
#define SCHM_CRC_VENDOR_ID                      (180)
#define SCHM_CRC_AR_RELEASE_MAJOR_VERSION       (4)
#define SCHM_CRC_AR_RELEASE_MINOR_VERSION       (4)
#define SCHM_CRC_AR_RELEASE_REVISION_VERSION    (0)
#define SCHM_CRC_SW_MAJOR_VERSION               (2)
#define SCHM_CRC_SW_MINOR_VERSION               (3)
#define SCHM_CRC_SW_PATCH_VERSION               (0)
/*==================================================================================================
                                            FILE VERSION CHECKS
==================================================================================================*/
/* Check if header file and CRC_CFG header file are of the same vendor */
#if (SCHM_CRC_VENDOR_ID != CRC_VENDOR_ID_CFG)
#error "SchM_Crc.h and Crc_Cfg.h have different vendor ids"
#endif

/* Check if header file and CRC_CFG header file are of the same Autosar version */
#if (( SCHM_CRC_AR_RELEASE_MAJOR_VERSION != CRC_AR_RELEASE_MAJOR_VERSION_CFG) || \
      ( SCHM_CRC_AR_RELEASE_MINOR_VERSION != CRC_AR_RELEASE_MINOR_VERSION_CFG) || \
      ( SCHM_CRC_AR_RELEASE_REVISION_VERSION != CRC_AR_RELEASE_REVISION_VERSION_CFG))
#error "AutoSar Version Numbers of SchM_Crc.h and Crc_Cfg.h are different"
#endif

/* Check if header file and CRC_CFG header file are of the same Software version */
#if (( SCHM_CRC_SW_MAJOR_VERSION != CRC_SW_MAJOR_VERSION_CFG) || \
      ( SCHM_CRC_SW_MINOR_VERSION != CRC_SW_MINOR_VERSION_CFG) || \
      ( SCHM_CRC_SW_PATCH_VERSION != CRC_SW_PATCH_VERSION_CFG))
#error "Software Version Numbers of SchM_Crc.h and Crc_Cfg.h are different"
#endif
/*==================================================================================================
                                                DEFINES AND MACROS
==================================================================================================*/

/* Number of cores id */
#ifndef NUMBER_OF_CORES
#define NUMBER_OF_CORES         (uint8)(1U)
#endif /* NUMBER_OF_CORES */

/*==================================================================================================
                                                EXTERNAL CONSTANTS
==================================================================================================*/
/*==================================================================================================
                                                ENUMS
==================================================================================================*/
/*==================================================================================================
                                                FUNCTION PROTOTYPES
==================================================================================================*/

#define RTE_START_SEC_CODE
#include "Rte_MemMap.h"

#if(STD_ON == CRC_SCHM_SUPPORT) /* CRC_SCHM_SUPPORT */

#ifdef MCAL_SCHM_LITE

RTE_FUNC extern void SchM_Enter_Crc_CRC_EXCLUSIVE_AREA(void);
RTE_FUNC extern void SchM_Exit_Crc_CRC_EXCLUSIVE_AREA(void);

#define SchM_Enter_Crc_CRC_EXCLUSIVE_AREA_00() SchM_Enter_Crc_CRC_EXCLUSIVE_AREA()
#define SchM_Exit_Crc_CRC_EXCLUSIVE_AREA_00() SchM_Exit_Crc_CRC_EXCLUSIVE_AREA()

#define SchM_Enter_Crc_CRC_EXCLUSIVE_AREA_01() SchM_Enter_Crc_CRC_EXCLUSIVE_AREA()
#define SchM_Exit_Crc_CRC_EXCLUSIVE_AREA_01() SchM_Exit_Crc_CRC_EXCLUSIVE_AREA()

#define SchM_Enter_Crc_CRC_EXCLUSIVE_AREA_02() SchM_Enter_Crc_CRC_EXCLUSIVE_AREA()
#define SchM_Exit_Crc_CRC_EXCLUSIVE_AREA_02() SchM_Exit_Crc_CRC_EXCLUSIVE_AREA()

#define SchM_Enter_Crc_CRC_EXCLUSIVE_AREA_03() SchM_Enter_Crc_CRC_EXCLUSIVE_AREA()
#define SchM_Exit_Crc_CRC_EXCLUSIVE_AREA_03() SchM_Exit_Crc_CRC_EXCLUSIVE_AREA()

#define SchM_Enter_Crc_CRC_EXCLUSIVE_AREA_04() SchM_Enter_Crc_CRC_EXCLUSIVE_AREA()
#define SchM_Exit_Crc_CRC_EXCLUSIVE_AREA_04() SchM_Exit_Crc_CRC_EXCLUSIVE_AREA()

#define SchM_Enter_Crc_CRC_EXCLUSIVE_AREA_05() SchM_Enter_Crc_CRC_EXCLUSIVE_AREA()
#define SchM_Exit_Crc_CRC_EXCLUSIVE_AREA_05() SchM_Exit_Crc_CRC_EXCLUSIVE_AREA()

#define SchM_Enter_Crc_CRC_EXCLUSIVE_AREA_06() SchM_Enter_Crc_CRC_EXCLUSIVE_AREA()
#define SchM_Exit_Crc_CRC_EXCLUSIVE_AREA_06() SchM_Exit_Crc_CRC_EXCLUSIVE_AREA()

#else

RTE_FUNC extern void SchM_Enter_Crc_CRC_EXCLUSIVE_AREA_00(void);
RTE_FUNC extern void SchM_Exit_Crc_CRC_EXCLUSIVE_AREA_00(void);

RTE_FUNC extern void SchM_Enter_Crc_CRC_EXCLUSIVE_AREA_01(void);
RTE_FUNC extern void SchM_Exit_Crc_CRC_EXCLUSIVE_AREA_01(void);

RTE_FUNC extern void SchM_Enter_Crc_CRC_EXCLUSIVE_AREA_02(void);
RTE_FUNC extern void SchM_Exit_Crc_CRC_EXCLUSIVE_AREA_02(void);

RTE_FUNC extern void SchM_Enter_Crc_CRC_EXCLUSIVE_AREA_03(void);
RTE_FUNC extern void SchM_Exit_Crc_CRC_EXCLUSIVE_AREA_03(void);

RTE_FUNC extern void SchM_Enter_Crc_CRC_EXCLUSIVE_AREA_04(void);
RTE_FUNC extern void SchM_Exit_Crc_CRC_EXCLUSIVE_AREA_04(void);

RTE_FUNC extern void SchM_Enter_Crc_CRC_EXCLUSIVE_AREA_05(void);
RTE_FUNC extern void SchM_Exit_Crc_CRC_EXCLUSIVE_AREA_05(void);

RTE_FUNC extern void SchM_Enter_Crc_CRC_EXCLUSIVE_AREA_06(void);
RTE_FUNC extern void SchM_Exit_Crc_CRC_EXCLUSIVE_AREA_06(void);

#endif /* MCAL_SCHM_LITE */

#else

#define SchM_Enter_Crc_CRC_EXCLUSIVE_AREA_00()
#define SchM_Exit_Crc_CRC_EXCLUSIVE_AREA_00()

#define SchM_Enter_Crc_CRC_EXCLUSIVE_AREA_01()
#define SchM_Exit_Crc_CRC_EXCLUSIVE_AREA_01()

#define SchM_Enter_Crc_CRC_EXCLUSIVE_AREA_02()
#define SchM_Exit_Crc_CRC_EXCLUSIVE_AREA_02()

#define SchM_Enter_Crc_CRC_EXCLUSIVE_AREA_03()
#define SchM_Exit_Crc_CRC_EXCLUSIVE_AREA_03()

#define SchM_Enter_Crc_CRC_EXCLUSIVE_AREA_04()
#define SchM_Exit_Crc_CRC_EXCLUSIVE_AREA_04()

#define SchM_Enter_Crc_CRC_EXCLUSIVE_AREA_05()
#define SchM_Exit_Crc_CRC_EXCLUSIVE_AREA_05()

#define SchM_Enter_Crc_CRC_EXCLUSIVE_AREA_06()
#define SchM_Exit_Crc_CRC_EXCLUSIVE_AREA_06()

#endif /* CRC_SCHM_SUPPORT */

#define RTE_STOP_SEC_CODE
#include "Rte_MemMap.h"

#ifdef __cplusplus
}
#endif

/** @} */

#endif /* End of file SchM_Crc.h */

