/**
* @file    CRC_Lld.h
*==================================================================================================
*   Project              : YTMicro AUTOSAR 4.4.0 MCAL
*   Platform             : ARM
*   Peripheral           : CRC_Lld
*   Dependencies         : none
*
*   Autosar Version      : V4.4.0
*   Autosar Revision     : ASR_REL_4_4_REV_0000
*   SW Version           : V2.3.0
*
*   (c) Copyright 2020-2025 Yuntu Microelectronics co.,ltd.
*   All Rights Reserved.
==================================================================================================*/

#ifndef CRC_LLD_H
#define CRC_LLD_H

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
                                              INCLUDE FILES
==================================================================================================*/
#include "Crc.h"
/*==================================================================================================
                                      HEADER FILE VERSION INFORMATION
==================================================================================================*/
#define CRC_LLD_VENDOR_ID                      (180)
#define CRC_LLD_AR_RELEASE_MAJOR_VERSION       (4)
#define CRC_LLD_AR_RELEASE_MINOR_VERSION       (4)
#define CRC_LLD_AR_RELEASE_REVISION_VERSION    (0)
#define CRC_LLD_SW_MAJOR_VERSION               (2)
#define CRC_LLD_SW_MINOR_VERSION               (3)
#define CRC_LLD_SW_PATCH_VERSION               (0)
/*==================================================================================================
                                                DEFINES AND MACROS
==================================================================================================*/

/*==================================================================================================
                                                EXTERNAL CONSTANTS
==================================================================================================*/

/*==================================================================================================
                                                ENUMS
==================================================================================================*/

/*==================================================================================================
                                                FUNCTION PROTOTYPES
==================================================================================================*/
uint32 Crc_Lld_GetCtlCmd(const Crc_ConfigType *CrcConfig, uint8 PolyModSet);
void Crc_Lld_WriteCtlCmd(uint32 CtrlCmd);
void Crc_Lld_WriteInitalValue(uint32 CrcInitialValue);
void Crc_Lld_WriteDataU32(uint32 CrcData);
void Crc_Lld_WriteDataU8(uint8 CrcData);
uint32 Crc_Lld_ReadCrcResult(void);
void Crc_Lld_Memcpy(void *DesPoint, const void *SrcPoint, uint32 Length);

#ifdef __cplusplus
}
#endif

#endif /* End of file Crc_Lld.h */


