/*
 *  Copyright 2020-2024 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file etmr_config.c
 * @brief 
 * 
 */


#include <stddef.h>
#include "etmr_config.h"

/*
 * Common
*/

etmr_pwm_sync_t ETMR_CM_Config0PwmSync={
    .regSyncFreq=1,
    .regSyncSel=REG_SYNC_DISABLED,
    .cntInitSyncSel=CNT_SYNC_WITH_REG,
    .maskOutputSyncSel=CHMASK_SYNC_WITH_REG,
    .regSyncTrigSrc=DISABLE_TRIGGER,
    .cntInitSyncTrigSrc=DISABLE_TRIGGER,
    .maskOutputSyncTrigSrc=DISABLE_TRIGGER,
    .hwTrigFromTmuEnable=false,
    .hwTrigFromCimEnable=false,
    .hwTrigFromPadEnable=false,
};


etmr_trig_config_t ETMR_CM_Config0TrigConf={
    .trigSrc=TRIGGER_FROM_MATCHING_EVENT,
    .pwmOutputChannel=0,
    .outputTrigFreq=1,
    .modMatchTrigEnable=false,
    .numOfChannels=0,
    .channelTrigParamConfig=NULL,
};

etmr_user_config_t ETMR_CM_Config0={
    .etmrClockSource=eTMR_CLOCK_SOURCE_INTERNALCLK,
    .etmrPrescaler=1,
    .debugMode=false,
    .syncMethod=&ETMR_CM_Config0PwmSync,
    .outputTrigConfig=&ETMR_CM_Config0TrigConf,
    .isTofIntEnabled=true,
};

etmr_state_t ETMR_CM_Config0_State;


/*
 * MC
*/


/*
 * PWM
*/


/*
 * IC
*/










etmr_ic_ch_param_t ETMR_IC_Config0InputCh[2]={
    {
        .hwChannelId=2,
        .edge=eTMR_DUAL_EDGES,
        .measurementType=eTMR_PERIOD_MEASUREMENT,
        .capHoldEn=false,  
        .filterSampleCounter=0,
        .filterSamplePeriod=0,
        .interruptEnable=true,
        .dmaEnable=false,
        .enableNotification=false,
        .channelsCallbacks=NULL,
        .channelsCallbacksParams=NULL,
    },
    {
        .hwChannelId=3,
        .edge=eTMR_DUAL_EDGES,
        .measurementType=eTMR_PERIOD_MEASUREMENT,
        .capHoldEn=false,  
        .filterSampleCounter=0,
        .filterSamplePeriod=0,
        .interruptEnable=true,
        .dmaEnable=false,
        .enableNotification=false,
        .channelsCallbacks=NULL,
        .channelsCallbacksParams=NULL,
    },
};

etmr_ic_ch_pair_param_t ETMR_IC_Config0InputChPair[1]={
    {
        .hwChannelPairId=1,
        .combEn=true,
        .combSrc=eTMR_COMB_SRC_EVEN,
    },
};

etmr_ic_param_t ETMR_IC_Config0={
    .numChannels=2,
    .countValue=65535,
    .inputChConfig=ETMR_IC_Config0InputCh,
    .numChannelPairs=1,
    .inputChPairConfig=ETMR_IC_Config0InputChPair,
};


/*
 * OC
*/


/*
 * QD
*/


