/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file acmp_config.c
 * @brief 
 * 
 */


#include "acmp_config.h"

/* comparatorConfig*/
static acmp_comparator_config_t ACMP_Config0ComparatorConfig={
    .acmpClkSrc=ACMP_CLK_SRC_IPC,
    .sampleMode=ACMP_COMMON_MODE,
    .edgeSelection=ACMP_NO_EDGE,
    .hardBlockOffset=false,
    .hysteresisLevel=ACMP_HYS_LEVEL_0,
    .outputSelect=ACMP_OUTPUT_FILTERED,
    .outputPolarity=ACMP_OUT_POL_NOT_INVERT,
    .powerMode=ACMP_HIGH_SPEED,
    .filterEnable=false,
    .filterClkSrc=ACMP_FILTER_SEL_FUNC_CLK,
    .filterSamplePeriod=48,
    .filterSampleCount=24,
    .autoDisableHardBlock=false,
    .interruptEnable=false,
    .dmaTriggerEnable=false,
};

/* dacConfig */
static acmp_dac_config_t ACMP_Config0DacConfig={
    .enable=true,
    .outputEnable=true,
    .voltage=128,
};

/* muxConfig */
static acmp_mux_config_t ACMP_Config0MuxConfig={
    .positiveInputSrc=ACMP_INPUT_SRC_MUX,
    .negativeInputSrc=ACMP_INPUT_SRC_DAC,
    .positiveInputChnSel=0,
    .negativeInputChnSel=0,
};

/* continuousConfig */
static acmp_continuous_config_t ACMP_Config0ContinuousConfig={
    .continuousEnable=true,
    .continuousMode=ACMP_CONTINUOUS_LOOP_MODE,
    .fixedPort=ACMP_FIXED_NEG_PORT,
    .samplePeriod=48,
    .samplePosition=24,
    .continuousInterruptEnable=true,
    .channelConfig={
        {
            .enable=true,
            .expectation=ACMP_EXPECT_POS_LESS_THAN_NEG,
        },
        {
            .enable=true,
            .expectation=ACMP_EXPECT_POS_LESS_THAN_NEG,
        },
        {
            .enable=false,
            .expectation=ACMP_EXPECT_POS_LESS_THAN_NEG,
        },
        {
            .enable=false,
            .expectation=ACMP_EXPECT_POS_LESS_THAN_NEG,
        },
        {
            .enable=false,
            .expectation=ACMP_EXPECT_POS_LESS_THAN_NEG,
        },
        {
            .enable=false,
            .expectation=ACMP_EXPECT_POS_LESS_THAN_NEG,
        },
        {
            .enable=false,
            .expectation=ACMP_EXPECT_POS_LESS_THAN_NEG,
        },
        {
            .enable=false,
            .expectation=ACMP_EXPECT_POS_LESS_THAN_NEG,
        },
    },
    
};

/* ACMP_Config0 */
const acmp_config_t ACMP_Config0={
    .comparatorConfig=&ACMP_Config0ComparatorConfig,
    .muxConfig=&ACMP_Config0MuxConfig,
    .dacConfig=&ACMP_Config0DacConfig,
    .continuousConfig=&ACMP_Config0ContinuousConfig,
};


