/* USER CODE BEGIN Header */
/* you can remove the copyright */

/*
 *  Copyright 2020-2023 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file main.c
 * @brief 
 * 
 */

/* USER CODE END Header */
#include "device_registers.h"
#include "osif.h"
#include "sdk_project_config.h"
#include <stdint.h>
/* Includes ------------------------------------------------------------------*/

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */
/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN PTD */
/* USER CODE END PTD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */
#define CHANNEL_NUM         2
#define BOARD_RED_LED_0     (GPIOE)
#define BOARD_RED_LED_0_PIN (16)
#define BOARD_RED_LED_1     (GPIOA)
#define BOARD_RED_LED_1_PIN (20)
/* Red led 0 */
#define RED_LED_0_OFF()     PINS_DRV_ClearPins(BOARD_RED_LED_0, (1 << BOARD_RED_LED_0_PIN))
#define RED_LED_0_ON()      PINS_DRV_SetPins(BOARD_RED_LED_0, (1 << BOARD_RED_LED_0_PIN))
/* Red led 1 */
#define RED_LED_1_OFF()     PINS_DRV_ClearPins(BOARD_RED_LED_1, (1 << BOARD_RED_LED_1_PIN))
#define RED_LED_1_ON()      PINS_DRV_SetPins(BOARD_RED_LED_1, (1 << BOARD_RED_LED_1_PIN))
/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */
/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/
/* USER CODE BEGIN PV */
/* USER CODE END PV */

/* Private function declare --------------------------------------------------*/
/* USER CODE BEGIN PFDC */
/* USER CODE END PFDC */
static void Board_Init(void);

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */
void ACMP0_IRQHandler(void)
{
    for (uint8_t channel = 0; channel < CHANNEL_NUM; channel++)
    {
        /* If channel's voltage is greater than DAC voltage */
        if (ACMP_DRV_GetChannelOutput(0, channel))
        {
            if (channel == 0)
            {
                /* Red led 0 light on */
                RED_LED_0_ON();
            }
            else
            {
                /* Red led 1 light on */
                RED_LED_1_ON();
            }
        }
    }
    /* Clear channel flags to exit interrupt normally */
    ACMP_DRV_ClearChannelFlags(0);
}

/* USER CODE END 0 */


/**
 * @brief  The application entry point.
 * @retval int
 */
int main(void)
{
    /* USER CODE BEGIN 1 */
    uint8_t value = 0;
    /* USER CODE END 1 */ 
    Board_Init();
    /* USER CODE BEGIN 2 */
    /* Enable ACMP interrupt */
    INT_SYS_EnableIRQ(ACMP0_IRQn);
    /* Enable ACMP */
    ACMP_DRV_Enable(0);
    /* USER CODE END 2 */

    /* Infinite loop */
    /* USER CODE BEGIN WHILE */
    while (1)
    {
        /* Light off red led 0 and red led 1 if channel's voltage is less than DAC voltage */
        RED_LED_0_OFF();
        RED_LED_1_OFF();

        value++;
        if (value > 255)
        {
            value = 0;
        }
        OSIF_TimeDelay(10);
        ACMP0->DAC &= ~(ACMP_DAC_VAL_MASK);
        ACMP0->DAC |= ACMP_DAC_VAL(value);
        /* USER CODE END WHILE */
        /* USER CODE BEGIN 3 */
    }
    /* USER CODE END 3 */
}

static void Board_Init(void)
{
    CLOCK_SYS_Init(g_clockManConfigsArr,CLOCK_MANAGER_CONFIG_CNT,g_clockManCallbacksArr,CLOCK_MANAGER_CALLBACK_CNT);
    CLOCK_SYS_UpdateConfiguration(CLOCK_MANAGER_ACTIVE_INDEX,CLOCK_MANAGER_POLICY_AGREEMENT);
    PINS_DRV_Init(NUM_OF_CONFIGURED_PINS0,g_pin_mux_InitConfigArr0);
    ACMP_DRV_Init(0,&ACMP_Config0);
}

/* USER CODE BEGIN 4 */
/* USER CODE END 4 */
