/*
 * Copyright 2020-2022 Yuntu Microelectronics co.,ltd
 * All rights reserved.
 *
 * YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 * used strictly in accordance with the applicable license terms. By expressly
 * accepting such terms or by downloading, installing, activating and/or otherwise
 * using the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software. The production use license in
 * Section 2.3 is expressly granted for this software.
 */

#include "secure_boot_YTM32B1HA0.h"

/* 
 * add the CAMC result array definition of sections as below with "SB_CMAC_SEG" to place it into 
 * section ".sb_cmac" allocated in linker file 
 */
 #if defined (__ICCARM__)
__root const uint8_t cmac0[16] SB_CMAC_SEG = {0};
__root const uint8_t cmac1[16] SB_CMAC_SEG = {0};
#else
const uint8_t cmac0[16] SB_CMAC_SEG = {0};
const uint8_t cmac1[16] SB_CMAC_SEG = {0};
#endif

/* add the secure boot section config structure definitions as below with "SB_CONFIG_SECTION_SEG" 
 * to place it into section ".sb_config_section" allocated in linker file 
 */
#if defined (__ICCARM__)
__root const secure_boot_section_config_t secure_boot_section0 SB_CONFIG_SECTION_SEG = {
#else
const secure_boot_section_config_t secure_boot_section0 SB_CONFIG_SECTION_SEG = {
#endif
    .secure_boot_marker = SECURE_BOOT_SECTION_MARKER,
    .aes_key_size = KEY_LEN_128_BITS,
    .key_slot     = 1,
    .start_addr   = 0x02000800,
    .length       = 0x200,
    .cmac_addr    = (uint32_t)&cmac0[0],
};

#if defined (__ICCARM__)
__root const secure_boot_section_config_t secure_boot_section1 SB_CONFIG_SECTION_SEG = {
#else
const secure_boot_section_config_t secure_boot_section1 SB_CONFIG_SECTION_SEG = {
#endif
    .secure_boot_marker = SECURE_BOOT_SECTION_MARKER,
    .aes_key_size = KEY_LEN_128_BITS,
    .key_slot     = 2,
    .start_addr   = 0x02000A00,
    .length       = 0x0200,
    .cmac_addr    = (uint32_t)&cmac1[0],
};

/* add the secure boot group config structure definitions as below with "SB_CONFIG_GROUP_SEG" 
 * to place it into section ".sb_group_section" allocated in linker file 
 */
#if defined (__ICCARM__)
__root const secure_boot_group_config_t secure_boot_group SB_CONFIG_SECTION_SEG = {
#else
const secure_boot_group_config_t secure_boot_group SB_CONFIG_SECTION_SEG = {
#endif
    .secure_boot_group_marker = SECURE_BOOT_GROUP_MARKER,
    .secure_boot_section_num  = 2,
    .encrypt                  = true,
    .aes_key_size             = KEY_LEN_128_BITS,
    .key_slot                 = 0,
    .section_config_addr[0]   = (uint32_t)&secure_boot_section0, 
    .section_config_addr[1]   = (uint32_t)&secure_boot_section1,
};

/* BVT Header section
 * include configuration refer to BVT_t
 */

#define BOOT_CONFIG_WORD  (BVT_BCW_CPDIVS_SET(1) | CM7_0_M_EN)

/* define the timeout of ADG watchdog of the application main core */
#define APP_WDG_TIMEOUT  (120000)    /* 10ms respect to 12MHz SIRC as reference clock*/
/* Flash erased status */
#define RESERVED                        ( 0xFFFFFFFF )

/* BVT Header configuration */
#if defined (__ICCARM__)
__root const bvt_header_config_t bvt_header BVT_HEADER_SEG = {
#else
const bvt_header_config_t bvt_header BVT_HEADER_SEG = {
#endif
    BVT_VALID_MARK,                 /* BVT marker */
    BOOT_CONFIG_WORD,               /* Boot configuration word */
    (uint32_t)&secure_boot_group,   /* secure boot start address */
    RESERVED,                       /* lifecycle configuration */
    DEFAULT_START_ADDRESS,          /* CM7 main core start address */
    RESERVED,
    RESERVED,
    RESERVED,
    RESERVED,
    RESERVED,
    APP_WDG_TIMEOUT,                /* timeout set of the WDG watchdog of the  application core */
};

/*******************************************************************************
 * EOF
 ******************************************************************************/
