/*
 *  Copyright 2020-2022 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 *
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 *
 * @file peripherals_osire_config.c
 * @brief
 *
 */

#include "peripherals_osire_config.h"

/* Save pinMux of SPI_PCS and memory base of PCTRL of each strip */
static OSIRE_PinMuxConfigType pcsPinMux[NUMBER_OF_STRIPS_SPI] = 
{
    /* PTC14 is SPI_PCS of strip0 and pinMux is PCTRL_MUX_ALT3 */
    {.pinMux = (uint8_t)PCTRL_MUX_ALT3, .pctrlPtr = (uint32_t *)&(PCTRLC->PCR[14])},
};

/* Save pinMux of SPI_SCK and memory base of PCTRL of each strip */
static OSIRE_PinMuxConfigType clkPinMux[NUMBER_OF_STRIPS_SPI] = 
{
    /* PTC15 is SPI_SCK of strip0 and pinMux is PCTRL_MUX_ALT3 */
    {.pinMux = (uint8_t)PCTRL_MUX_ALT3, .pctrlPtr = (uint32_t *)&(PCTRLC->PCR[15])},
};

/* Pin configuration of each strip */
OSIRE_PinConfigType pinConfigSPI[NUMBER_OF_STRIPS_SPI] = 
{
    {
        .stripNr    = 0U,                /* Strip number */
        .instanceNr = OSIRE_SPI_2,       /* The instance number of SPI */
        .pcsPinMux  = &pcsPinMux[0],     /* The pinMux of SPI_PCS */
        .clkPinMux  = &clkPinMux[0],     /* The pinMux of SPI_SCK */
    },
};

OSIRE_TimeoutType timeoutChannelsSPI[NUMBER_OF_STRIPS_SPI] = 
{
    {
        .stripNr = 0U,                  /* Strip number */
        .timeoutDuration = 100,         /* Timeout is 100 and unit is decided by timer */
    },
};

OSIRE_ConfigType osire[NUMBER_OF_INTERFACES] = 
{
    {
         .nrOfStrips = NUMBER_OF_STRIPS_SPI,    /* Number of strips which use SPI */
         OSIRE_Callback,                        /* Callback of SPI */
         OSIRE_INTERFACE_SPI,                   /* Current interface is SPI */
         pinConfigSPI,                          /* Pin configuration of each strip */
         timeoutChannelsSPI,                    /* Timeout of each strip */
         OSIRE_USING_INTERRUPTS,                       /* OSIRE uses interrupt to transfer */
         0U,                                    /* TX channel of DMA */
         1U,                                    /* RX channel of DMA */
    },
};