/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file pin_mux.c
 * @brief 
 * 
 */



#include "pin_mux.h"

/*! @brief User configuration cfg InitConfigArr0 array */
const pin_settings_config_t g_pin_mux_InitConfigArr0[NUM_OF_CONFIGURED_PINS0] = {
    /* PTD_7-22-LINFlexD2_TX-URAT_TX */
    {
        .base = PCTRLD,
        .pinPortIdx = 7U,
        .pullConfig = PCTRL_INTERNAL_PULL_NOT_ENABLED,
        .rateSelect = PCTRL_FAST_SLEW_RATE,
        .passiveFilter = false,
        .driveSelect = PCTRL_LOW_DRIVE_STRENGTH,
        .mux = PCTRL_MUX_ALT2,
        .intConfig = PCTRL_DMA_INT_DISABLED,
        .clearIntFlag = false,
        .digitalFilter = false,
        .gpioBase = GPIOD,
        .direction = GPIO_INPUT_DIRECTION,
        .initValue = 0,
    },
    /* PTD_6-23-LINFlexD2_RX-URAT_RX */
    {
        .base = PCTRLD,
        .pinPortIdx = 6U,
        .pullConfig = PCTRL_INTERNAL_PULL_NOT_ENABLED,
        .rateSelect = PCTRL_FAST_SLEW_RATE,
        .passiveFilter = false,
        .driveSelect = PCTRL_LOW_DRIVE_STRENGTH,
        .mux = PCTRL_MUX_ALT2,
        .intConfig = PCTRL_DMA_INT_DISABLED,
        .clearIntFlag = false,
        .digitalFilter = false,
        .gpioBase = GPIOD,
        .direction = GPIO_INPUT_DIRECTION,
        .initValue = 0,
    },
    /* PTB_1-33-LINFlexD0_TX-LIN_TX */
    {
        .base = PCTRLB,
        .pinPortIdx = 1U,
        .pullConfig = PCTRL_INTERNAL_PULL_NOT_ENABLED,
        .rateSelect = PCTRL_FAST_SLEW_RATE,
        .passiveFilter = false,
        .driveSelect = PCTRL_LOW_DRIVE_STRENGTH,
        .mux = PCTRL_MUX_ALT2,
        .intConfig = PCTRL_DMA_INT_DISABLED,
        .clearIntFlag = false,
        .digitalFilter = false,
        .gpioBase = GPIOB,
        .direction = GPIO_INPUT_DIRECTION,
        .initValue = 0,
    },
    /* PTB_0-34-LINFlexD0_RX-LIN_RX */
    {
        .base = PCTRLB,
        .pinPortIdx = 0U,
        .pullConfig = PCTRL_INTERNAL_PULL_NOT_ENABLED,
        .rateSelect = PCTRL_FAST_SLEW_RATE,
        .passiveFilter = false,
        .driveSelect = PCTRL_LOW_DRIVE_STRENGTH,
        .mux = PCTRL_MUX_ALT2,
        .intConfig = PCTRL_DMA_INT_DISABLED,
        .clearIntFlag = false,
        .digitalFilter = false,
        .gpioBase = GPIOB,
        .direction = GPIO_INPUT_DIRECTION,
        .initValue = 0,
    },
    /* PTA_6-38-GPIO-SLP_N */
    {
        .base = PCTRLA,
        .pinPortIdx = 6U,
        .pullConfig = PCTRL_INTERNAL_PULL_UP_ENABLED,
        .rateSelect = PCTRL_FAST_SLEW_RATE,
        .passiveFilter = false,
        .driveSelect = PCTRL_LOW_DRIVE_STRENGTH,
        .mux = PCTRL_MUX_AS_GPIO,
        .intConfig = PCTRL_DMA_INT_DISABLED,
        .clearIntFlag = false,
        .digitalFilter = false,
        .gpioBase = GPIOA,
        .direction = GPIO_OUTPUT_DIRECTION,
        .initValue = 0,
    },
    /* PTA_2-48-eTMR3_CH0-WD */
    {
        .base = PCTRLA,
        .pinPortIdx = 2U,
        .pullConfig = PCTRL_INTERNAL_PULL_NOT_ENABLED,
        .rateSelect = PCTRL_FAST_SLEW_RATE,
        .passiveFilter = false,
        .driveSelect = PCTRL_LOW_DRIVE_STRENGTH,
        .mux = PCTRL_MUX_ALT2,
        .intConfig = PCTRL_DMA_INT_DISABLED,
        .clearIntFlag = false,
        .digitalFilter = false,
        .gpioBase = GPIOA,
        .direction = GPIO_INPUT_DIRECTION,
        .initValue = 0,
    },
    /* PTA_1-49-GPIO-WDO */
    {
        .base = PCTRLA,
        .pinPortIdx = 1U,
        .pullConfig = PCTRL_INTERNAL_PULL_NOT_ENABLED,
        .rateSelect = PCTRL_FAST_SLEW_RATE,
        .passiveFilter = false,
        .driveSelect = PCTRL_LOW_DRIVE_STRENGTH,
        .mux = PCTRL_MUX_AS_GPIO,
        .intConfig = PCTRL_DMA_INT_DISABLED,
        .clearIntFlag = false,
        .digitalFilter = true,
        .gpioBase = GPIOA,
        .direction = GPIO_INPUT_DIRECTION,
        .initValue = 0,
    },
    /* PTA_0-50-GPIO-WD_EN */
    {
        .base = PCTRLA,
        .pinPortIdx = 0U,
        .pullConfig = PCTRL_INTERNAL_PULL_UP_ENABLED,
        .rateSelect = PCTRL_FAST_SLEW_RATE,
        .passiveFilter = false,
        .driveSelect = PCTRL_LOW_DRIVE_STRENGTH,
        .mux = PCTRL_MUX_AS_GPIO,
        .intConfig = PCTRL_DMA_INT_DISABLED,
        .clearIntFlag = false,
        .digitalFilter = false,
        .gpioBase = GPIOA,
        .direction = GPIO_OUTPUT_DIRECTION,
        .initValue = 0,
    },
    /* PTC_16-28-GPIO-BLUE */
    {
        .base = PCTRLC,
        .pinPortIdx = 16U,
        .pullConfig = PCTRL_INTERNAL_PULL_NOT_ENABLED,
        .rateSelect = PCTRL_FAST_SLEW_RATE,
        .passiveFilter = false,
        .driveSelect = PCTRL_LOW_DRIVE_STRENGTH,
        .mux = PCTRL_MUX_AS_GPIO,
        .intConfig = PCTRL_DMA_INT_DISABLED,
        .clearIntFlag = false,
        .digitalFilter = false,
        .gpioBase = GPIOC,
        .direction = GPIO_OUTPUT_DIRECTION,
        .initValue = 1,
    },
    /* PTC_15-29-GPIO-GREEN */
    {
        .base = PCTRLC,
        .pinPortIdx = 15U,
        .pullConfig = PCTRL_INTERNAL_PULL_NOT_ENABLED,
        .rateSelect = PCTRL_FAST_SLEW_RATE,
        .passiveFilter = false,
        .driveSelect = PCTRL_LOW_DRIVE_STRENGTH,
        .mux = PCTRL_MUX_AS_GPIO,
        .intConfig = PCTRL_DMA_INT_DISABLED,
        .clearIntFlag = false,
        .digitalFilter = false,
        .gpioBase = GPIOC,
        .direction = GPIO_OUTPUT_DIRECTION,
        .initValue = 1,
    },
    /* PTC_14-30-GPIO-RED */
    {
        .base = PCTRLC,
        .pinPortIdx = 14U,
        .pullConfig = PCTRL_INTERNAL_PULL_NOT_ENABLED,
        .rateSelect = PCTRL_FAST_SLEW_RATE,
        .passiveFilter = false,
        .driveSelect = PCTRL_LOW_DRIVE_STRENGTH,
        .mux = PCTRL_MUX_AS_GPIO,
        .intConfig = PCTRL_DMA_INT_DISABLED,
        .clearIntFlag = false,
        .digitalFilter = false,
        .gpioBase = GPIOC,
        .direction = GPIO_OUTPUT_DIRECTION,
        .initValue = 0,
    },
    /* PTC_9-35-GPIO-SLPN_TEST */
    {
        .base = PCTRLC,
        .pinPortIdx = 9U,
        .pullConfig = PCTRL_INTERNAL_PULL_UP_ENABLED,
        .rateSelect = PCTRL_FAST_SLEW_RATE,
        .passiveFilter = false,
        .driveSelect = PCTRL_LOW_DRIVE_STRENGTH,
        .mux = PCTRL_MUX_AS_GPIO,
        .intConfig = PCTRL_DMA_INT_DISABLED,
        .clearIntFlag = false,
        .digitalFilter = false,
        .gpioBase = GPIOC,
        .direction = GPIO_OUTPUT_DIRECTION,
        .initValue = 1,
    },
};



/***********************************************************************************************************************
 * EOF
 **********************************************************************************************************************/

