/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file interrupt_config.c
 * @brief 
 * 
 */


#include <stddef.h>
#include "interrupt_config.h"


void INT_SYS_ConfigInit(void)
{
    INT_SYS_DisableIRQGlobal();
    /* LINFlexD0_IRQn(31) LINFlexD0_IRQHandler*/
    INT_SYS_SetPriority(LINFlexD0_IRQn,1);
    INT_SYS_EnableIRQ(LINFlexD0_IRQn);
    /* LINFlexD2_IRQn(35) LINFlexD2_IRQHandler*/
    INT_SYS_SetPriority(LINFlexD2_IRQn,1);
    INT_SYS_EnableIRQ(LINFlexD2_IRQn);
    /* pTMR0_Ch0_IRQn(48) pTMR0_Ch0_IRQHandler*/
    INT_SYS_SetPriority(pTMR0_Ch0_IRQn,1);
    INT_SYS_EnableIRQ(pTMR0_Ch0_IRQn);
    /* lpTMR0_IRQn(58) lpTMR0_IRQHandler*/
    INT_SYS_SetPriority(lpTMR0_IRQn,0);
    INT_SYS_EnableIRQ(lpTMR0_IRQn);
    INT_SYS_EnableIRQGlobal();
}

