/*
 *  Copyright 2020-2024 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file Port_Cfg.h
 * @brief 
 * 
 */


#ifndef PORT_CFG_H
#define PORT_CFG_H

#ifdef __cplusplus
extern "C"{
#endif


/*==================================================================================================
 *                                        INCLUDE FILES
==================================================================================================*/
#include "Std_Types.h"

/*==================================================================================================
 *                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define PORT_VENDOR_ID_CFG               (180)
#define PORT_AR_REL_MAJOR_VER_CFG        (4)
#define PORT_AR_REL_MINOR_VER_CFG        (4)
#define PORT_AR_REL_REVISION_VER_CFG     (0)
#define PORT_SW_MAJOR_VER_CFG            (2)
#define PORT_SW_MINOR_VER_CFG            (2)
#define PORT_SW_PATCH_VER_CFG            (0)

/*==================================================================================================
 *                                     FILE VERSION CHECKS
==================================================================================================*/

/*==================================================================================================
 *                          LOCAL TYPEDEFS (STRUCTURES, UNIONS, ENUMS)
==================================================================================================*/


/*==================================================================================================
 *                                       LOCAL MACROS
==================================================================================================*/
// PortGeneral
/**
 * @brief Switches the development error detection and notification on or off.
 * @note Trace: ECUC_Port_00123
 *       range: STD_ON, STD_OFF
 */
#define PORT_DEV_ERROR_DETECT                       (STD_ON)

/**
 * @brief Pre-processor switch to enable / disable the use of the function Port_SetPinDirection().
 * @note Trace: ECUC_Port_00131
 *       range: STD_ON, STD_OFF
 */
#define PORT_SET_PIN_DIRECTION_API                   (STD_ON)

/**
 * @brief Pre-processor switch to enable / disable the use of the function Port_SetPinMode().
 * @note Trace: ECUC_Port_00132
 *       range: STD_ON, STD_OFF
 */
#define PORT_SET_PIN_MODE_API                        (STD_ON)

/**
 * @brief Pre-processor switch to enable / disable the API to read out the modules version information.
 * @note Trace: ECUC_Port_00133
 *       range: STD_ON, STD_OFF
 */
#define PORT_VERSION_INFO_API                       (STD_ON)
/**
 * @brief Pre-processor switch to use or not use the post-build config
 * @note range: STD_ON, STD_OFF      
 */
#define PORT_FIXED_PB_CONFIG (STD_OFF)


/**
 * @brief        Pre-compile PORT_HAS_DIGITAL_FILTER
 */
#define PORT_HAS_DIGITAL_FILTER (STD_ON)


/**
 * @brief        Pre-compile PORT_HAS_DIGITAL_FILTER
 */
#define PORT_HAS_SLEW_RATE (STD_ON)


/**
 * @brief        Pre-compile enable PORT_READBACK_ENABLE
 */
#define PORT_READBACK_ENABLE                        (STD_OFF)


#ifdef PORT_ENABLE_USER_MODE_SUPPORT
#ifndef MCAL_ENABLE_USER_MODE_SUPPORT
#error "Must define MCAL_ENABLE_USER_MODE_SUPPORT if PORT_ENABLE_USER_MODE_SUPPORT is defined"
#endif
#endif

/**
* @brief Support for SchM: sync/atomic operations, global interrupt disable/enable.
*        If this parameter has been configured to 'STD_ON', the MCAL driver code supports sync/atomic operations for key resource protection.
*        If it is enabled, all the SchM codes in MCAL Port driver codes will work and support sync/atomic operation with CPU global interrupt enable/disable for key resource protection. 
*        Disable it can reduce code size, but may cause potential risks when access to some critical resource!
*/
#define PORT_SCHM_SUPPORT  (STD_ON) 

/**
* @brief Port Pin symbolic names
* @details Get All Symbolic Names from configuration tool
*
*/

#define PortConf_PortPin_PortPin_PTB12     ((Port_PinType)(((1)<<8)|12))
#define PortConf_PortPin_PortPin_CLKOUT    ((Port_PinType)(((3)<<8)|10))

#ifdef __cplusplus
}
#endif

#endif /* PORT_CFG_H */

/** @} */

