/*
 *  Copyright 2020-2024 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file Mcu_PBcfg.h
 * @brief 
 * 
 */


#ifndef MCU_PB_CFG_H
#define MCU_PB_CFG_H


/*==================================================================================================
*                                        INCLUDE FILES
==================================================================================================*/
#include "Std_Types.h"


/*==================================================================================================
*                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define MCU_VENDOR_ID_PBCFG               (180)
#define MCU_AR_REL_MAJOR_VER_PBCFG        (4)
#define MCU_AR_REL_MINOR_VER_PBCFG        (4)
#define MCU_AR_REL_REVISION_VER_PBCFG     (0)
#define MCU_SW_MAJOR_VER_PBCFG            (2)
#define MCU_SW_MINOR_VER_PBCFG            (2)
#define MCU_SW_PATCH_VER_PBCFG            (0)

/**
 * @brief This union is utilized by Mcu_CmuNotification to indicate the detected CMU error.
 */
typedef struct {
    uint8 OUTRNG : 1;
    uint8 LOSR   : 1;
    uint8 LOSC   : 1;
} Mcu_CmuErrorType;



#define MCU_CONFIG_PB \
    extern const Mcu_ConfigType Mcu_Config;




#endif /* MCU_PB_CFG_H */

