/* USER CODE BEGIN Header */
/* you can remove the copyright */

/*
 *  Copyright 2020-2023 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 *
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 *
 * @file main.c
 * @brief
 *
 */

/* USER CODE END Header */
#include "Mcal.h"
/* Includes ------------------------------------------------------------------*/

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */
#include "pSIP_Etmr.h"
/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN PTD */
/* USER CODE END PTD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */
/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */
/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/
/* USER CODE BEGIN PV */
static uint32 ETMR_0_Ovf_CbkCnt = 0U;

/* USER CODE END PV */

/* Private function declare --------------------------------------------------*/
/* USER CODE BEGIN PFDC */
/* USER CODE END PFDC */
static void Board_Init(void);

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */
void Delay(uint32 Timeout)
{
    volatile uint32 Count = Timeout;

    while (Count--);
}
/* USER CODE END 0 */


/**
 * @brief  The application entry point.
 * @retval int
 */
int main(void)
{
    /* USER CODE BEGIN 1 */
    Mcu_Init(&Mcu_Config);
    Mcu_InitClock(0U);
#if (MCU_NO_PLL == STD_OFF)
    while (MCU_PLL_LOCKED != Mcu_GetPllStatus())
    {
        /* Busy wait until the system PLL is locked. */
    }
    Mcu_DistributePllClock();
#endif
    /* USER CODE END 1 */ 
    Board_Init();
    /* USER CODE BEGIN 2 */
    Port_Init(&Port_Config);
    /********* Init Pwm ************/
    Pwm_Init(&Pwm_Config);
    Platform_Init(NULL_PTR);
    eTMR0->CTRL &= (~eTMR_CTRL_EN_MASK);
    /* USER CODE END 2 */

    /* Infinite loop */
    /* USER CODE BEGIN WHILE */
    while (1)
    {
        /* USER CODE END WHILE */
        /* USER CODE BEGIN 3 */
        eTMR0->CTRL |= eTMR_CTRL_EN_MASK;   /* Enable pwm */
        Delay(900000);
    }
    /* USER CODE END 3 */
}

static void Board_Init(void)
{
}

/* USER CODE BEGIN 4 */
void ETMR_0_Ovf_Callback(void)
{
    eTMR0->STS = eTMR_STS_TOF_MASK;
    ++ETMR_0_Ovf_CbkCnt;

    if (ETMR_0_Ovf_CbkCnt >= 10)    // set pwm number, set 10 means 10 pwm
    {
        eTMR0->CTRL &= (~eTMR_CTRL_EN_MASK);
        ETMR_0_Ovf_CbkCnt = 0;
    }
}
/* USER CODE END 4 */
