# Pwm 示例代码

## 项目名称：Pwm_Demo

---
## 功能描述

此示例项目配置使能了 **4** 个 PWM 通道输出。**PwmChannel_0** 和 **PwmChannel_1** 是独立的，**PwmChannel_2** 和 **PwmChannel_3** 是互补的。然后周期性地改变 pwm 输出周期和占空比。可以通过示波器捕获 PWM 波形来验证 PWM PIN 的输出。

- 周期从 11KHz 到 1KHz，步长为 **1KHz**
- 占空比从 0% 到 100%，步长为 **10%**

本例使用的**4**个PWM 通道对应的eTMR模块和通道以及 PWM 引脚的配置如下：
  - **PwmChannel_0** --> **ETMR_0_CH_0** --> **PTB12**（在 EVB 上为 **H3-26**）  
  - **PwmChannel_1** --> **ETMR_0_CH_1** --> **PTB13**（在 EVB 上为 **H3-25**）    
  - **PwmChannel_2** --> **ETMR_0_CH_2** --> **PTB14**（在 EVB 上为 **H3-24**）    
  - **PwmChannel_3** --> **ETMR_0_CH_3** --> **PTB15**（在 EVB 上为 **H3-23**）    

**注意**：为了演示目的，**PwmChannel_2** 和 **PwmChannel_3** 被配置为具有 ***2us*** 和 ***4us*** 死区时间的互补 PWM 通道。

---
## 硬件要求
+ **EVB**：YTM32B1ME0-Q144-EVB-REVB/Rev.C
+ **调试器**：J-Link HW v9 或更高版本，需安装 YUNTU YTM32B1ME0 补丁（支持包）。

---
## 软件要求

+ **配置 & 代码生成工具**
  + **MCAL**：    云途配置工具(YCT) v2.6 或更高版本
+ **编译器工具链**
  + **GCC**     ：GNU GCC v10.3 或更高版本
  + **Keil/MDK**：ARM Keil/MDK v5.36 或更高版本
  + **IAR**     ：IAR v8.41 或更高版本
  + **VS Code**  ：Microsoft Visual Studio Code IDE v1.76 或更高版本（需要 C/C++ 支持、GNU 工具链、CMake v3.25、ninja、Cortex-Debug 扩展安装）
+ **调试器驱动**
    + **J-Link**            ：SEGGER J-Link v7.82 或更高版本，需要安装 YUNTU YTM32B1ME0 补丁（支持包）。
    + **Ozone 调试器工具**    ：SEGGER Ozone v3.28 或更高版本。

    ***注意***：需要安装 **YTM32B1ME0** 补丁，可以通过 **YCT** 获取或联系 ***云途销售/FAE 团队***。

---
## 设置步骤

+ ***步骤1***：使用 YCT 工具打开 Pwm_Demo.yct，根据您的需求配置工具链（默认使用 VS code + GCC）
+ ***步骤2***：生成代码，如果需要，您可以更改配置以适应您自己的硬件设计，如果是这样，请确保在生成代码之前所有修改都是正确的，没有任何错误存在。
+ ***步骤3***：根据您选择的，使用 VS code/IAR/Keil IDE 打开生成的项目。
+ ***步骤4***：编译项目，打开 EVB 电源并通过可用的调试器（如 J-Link 调试器）将其下载到 EVB。
+ ***步骤5***：最后，连接示波器通道观察PWM通道输出波形。

---