# Pwm Example Code

## Project Name: Pwm_Demo

---
## Function description

This example project enables **4** PWM channel outputs. **PwmChannel_0** and **PwmChannel_1** are independent, **PwmChannel_2** and **PwmChannel_3** are complementary. Then changes the pwm output period and duty periodically.  PWM wave can be captured by oscilloscope to verify the PWM PINs' output.

- Period from 11KHz to 1KHz, step is **1KHz**
- Duty cycle from 0% to 100%, step is **10%**
  
The used **4** PWM channels, eTMR instance and channels as well as the PWM pins are configured as below:
  - **PwmChannel_0** --> **ETMR_0_CH_0** --> **PTB12**(**H3-26** on the EVB)  
  - **PwmChannel_1** --> **ETMR_0_CH_1** --> **PTB13**(**H3-25** on the EVB)    
  - **PwmChannel_2** --> **ETMR_0_CH_2** --> **PTB14**(**H3-24** on the EVB)    
  - **PwmChannel_3** --> **ETMR_0_CH_3** --> **PTB15**(**H3-23** on the EVB)    
 
**Note**: For demonstration purpose, the **PwmChannel_2** and **PwmChannel_3** are configured as complementary PWM channels with ***2us*** and ***4us*** dead-time respectively.

---
## HW requirement
+ **EVB**: YTM32B1ME0-Q144-EVB-REVB/Rev.C
+ **Debugger**: J-Link HW v9 or later with YUNTU YTM32B1ME0 patch(support package) installed.

---
## SW requirement

+ **Config & Code Generation Tool**
  + **MCAL**:     Yuntu Config Tool(YCT) v2.6.0 or later version
+ **Compiler Toolchain**
  + **GCC**     : GNU GCC v10.3 or later version
  + **Keil/MDK**: ARM Keil/MDK v5.36 or later version
  + **IAR**     : IAR v8.40 or later version
  + **VS Code**  : Microsoft Visual Studio Code IDE v1.76 or later version(C/C++ support, GNU toolchain, CMake v3.25, ninja, Cortex-Debug extensions installation required)
+ **Debugger driver**
    + **J-Link**              : SEGGER J-Link v7.82 or later version, YUNTU YTM32B1ME0 patch(support package) installation required.
    + **Ozone Debugger tool**  : SEGGER Ozone v3.28 or later version.

    ***Note***:  **YTM32B1ME0** patch install required which can be obtained via **YCT** or contact ***YUNTU sales/FAE team***.

---
## Setup

+ ***Step1***: Open the Pwm_Demo.yct with the YCT tool, config the toolchain per your required(by default, the VS code + GCC are used)
+ ***Step2***：Generate the codes， you can change the configurations if needed(to adapt to your own HW design), if so, please ensure all the modifications are OK with no any errors exist before generating the code.
+ ***Step3***: Open the generated project with VS code/IAR/Keil IDE per your selected.
+ ***Step4***: Compile the project, power on the EVB and download it to the EVB via the available debugger, such as a J-Link debugger probe.
+ ***Step5***: At last, connect the oscilloscope to the PWM pins and verify the PWM wave.

---