/**
 * @file    SchM_Pwm.h
 * @version V2.2.0
 *
 * @brief   AUTOSAR SchM_Pwm module interface
 * @details API implementation for SchM_Pwm driver
 *
 * @addtogroup SCHM_PWM_MODULE
 * @{
 */
/*==================================================================================================
 *   Project              : YTMicro AUTOSAR 4.4.0 MCAL
 *   Platform             : ARM
 *   Peripheral           : eTMR
 *   Dependencies         : none
 *
 *   Autosar Version      : V4.4.0
 *   Autosar Revision     : ASR_REL_4_4_REV_0000
 *   Autosar Conf.Variant :
 *   SW Version           : V2.2.0
 *
 *
 *   (c) Copyright 2020-2023 Yuntu Microelectronics co.,ltd.
 *   All Rights Reserved.
==================================================================================================*/

#ifndef SCHM_PWM_H
#define SCHM_PWM_H

#ifdef __cplusplus
extern "C" {
#endif

/* PRQA S 0777,0779 EOF */
/*==================================================================================================
 *                               SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define SCHM_PWM_VENDOR_ID                      (180)
#define SCHM_PWM_AR_RELEASE_MAJOR_VERSION       (4)
#define SCHM_PWM_AR_RELEASE_MINOR_VERSION       (4)
#define SCHM_PWM_AR_RELEASE_REVISION_VERSION    (0)
#define SCHM_PWM_SW_MAJOR_VERSION               (2)
#define SCHM_PWM_SW_MINOR_VERSION               (2)
#define SCHM_PWM_SW_PATCH_VERSION               (0)

/*==================================================================================================
 *                                       DEFINES AND MACROS
==================================================================================================*/
#ifndef NUMBER_OF_CORES
#define NUMBER_OF_CORES (1U)
#endif

/*==================================================================================================
 *                                       FUNCTION PROTOTYPES
==================================================================================================*/
#define RTE_START_SEC_CODE
#include "Rte_MemMap.h"

RTE_FUNC extern void SchM_Enter_Pwm_PWM_EXCLUSIVE_AREA_00(void);
RTE_FUNC extern void SchM_Exit_Pwm_PWM_EXCLUSIVE_AREA_00(void);

RTE_FUNC extern void SchM_Enter_Pwm_PWM_EXCLUSIVE_AREA_01(void);
RTE_FUNC extern void SchM_Exit_Pwm_PWM_EXCLUSIVE_AREA_01(void);

RTE_FUNC extern void SchM_Enter_Pwm_PWM_EXCLUSIVE_AREA_02(void);
RTE_FUNC extern void SchM_Exit_Pwm_PWM_EXCLUSIVE_AREA_02(void);

RTE_FUNC extern void SchM_Enter_Pwm_PWM_EXCLUSIVE_AREA_03(void);
RTE_FUNC extern void SchM_Exit_Pwm_PWM_EXCLUSIVE_AREA_03(void);

RTE_FUNC extern void SchM_Enter_Pwm_PWM_EXCLUSIVE_AREA_04(void);
RTE_FUNC extern void SchM_Exit_Pwm_PWM_EXCLUSIVE_AREA_04(void);

RTE_FUNC extern void SchM_Enter_Pwm_PWM_EXCLUSIVE_AREA_05(void);
RTE_FUNC extern void SchM_Exit_Pwm_PWM_EXCLUSIVE_AREA_05(void);

RTE_FUNC extern void SchM_Enter_Pwm_PWM_EXCLUSIVE_AREA_06(void);
RTE_FUNC extern void SchM_Exit_Pwm_PWM_EXCLUSIVE_AREA_06(void);

RTE_FUNC extern void SchM_Enter_Pwm_PWM_EXCLUSIVE_AREA_07(void);
RTE_FUNC extern void SchM_Exit_Pwm_PWM_EXCLUSIVE_AREA_07(void);

RTE_FUNC extern void SchM_Enter_Pwm_PWM_EXCLUSIVE_AREA_08(void);
RTE_FUNC extern void SchM_Exit_Pwm_PWM_EXCLUSIVE_AREA_08(void);

RTE_FUNC extern void SchM_Enter_Pwm_PWM_EXCLUSIVE_AREA_09(void);
RTE_FUNC extern void SchM_Exit_Pwm_PWM_EXCLUSIVE_AREA_09(void);

RTE_FUNC extern void SchM_Enter_Pwm_PWM_EXCLUSIVE_AREA_10(void);
RTE_FUNC extern void SchM_Exit_Pwm_PWM_EXCLUSIVE_AREA_10(void);

#define RTE_STOP_SEC_CODE
#include "Rte_MemMap.h"

#ifdef __cplusplus
}
#endif

#endif /* SCHM_PWM_H */

/** @} */

