/**
 * @file    Pwm_Lld_Etmr_Reg.h
 * @version V2.2.0
 *
 * @brief   YUNTU Pwm_Lld_Etmr module interface
 * @details API implementation for Pwm_Lld_Etmr driver
 *
 * @addtogroup PWM_LLD_ETMR_MODULE
 * @{
 */
/*==================================================================================================
 *   Project              : YTMicro AUTOSAR 4.4.0 MCAL
 *   Platform             : ARM
 *   Peripheral           : eTMR
 *   Dependencies         : none
 *
 *   Autosar Version      : V4.4.0
 *   Autosar Revision     : ASR_REL_4_4_REV_0000
 *   Autosar Conf.Variant :
 *   SW Version           : V2.2.0
 *
 *   (c) Copyright 2020-2024 Yuntu Microelectronics co.,ltd.
 *   All Rights Reserved.
==================================================================================================*/

#ifndef PWM_LLD_ETMR_REG_H
#define PWM_LLD_ETMR_REG_H

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
 *                                      INCLUDE FILES
==================================================================================================*/
#if defined(UNIT_TEST)
#include "fakeEtmr.h"
#include "fakeCim.h"
#else
#include "pSIP_Etmr.h"
#include "pSIP_Cim.h"
#endif

/*==================================================================================================
 *                               SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define PWM_LLD_ETMR_REG_VENDOR_ID              (180)
#define PWM_LLD_ETMR_REG_MODULE_ID              (121)
#define PWM_LLD_ETMR_REG_AR_REL_MAJOR_VER       (4)
#define PWM_LLD_ETMR_REG_AR_REL_MINOR_VER       (4)
#define PWM_LLD_ETMR_REG_AR_REL_REVISION_VER    (0)
#define PWM_LLD_ETMR_REG_SW_MAJOR_VER           (2)
#define PWM_LLD_ETMR_REG_SW_MINOR_VER           (2)
#define PWM_LLD_ETMR_REG_SW_PATCH_VER           (0)

#ifdef __cplusplus
}
#endif

#endif /* PWM_LLD_ETMR_REG_H */

/** @} */

