/**
*   @file    pSIP_Stu.h
*   @version
*
*   @brief   AUTOSAR Stu register map
*   @details Register map for STU
*
*   @addtogroup Stu_MODULE
*   @{
*/
/*==================================================================================================
*   Project              : YTMicro AUTOSAR 4.4.0 MCAL
*   Platform             : ARM
*   Peripheral           : Stu
*   Dependencies         : none
*
*   Autosar Version      : V4.4.0
*   Autosar Revision     : ASR_REL_4_4_REV_0000
*   Autosar Conf.Variant :
*   SW Version           : V2.2.0
*
*   (c) Copyright 2020-2023 Yuntu Microelectronics co.,ltd.
*   All Rights Reserved.
==================================================================================================*/
/*==================================================================================================
==================================================================================================*/

#ifndef PSIP_STU_H
#define PSIP_STU_H

/*=================================================================================================
*                                        INCLUDE FILES
=================================================================================================*/

#include "Std_Types.h"

/*==================================================================================================
*                              STU REGISTER MAP
==================================================================================================*/

/**
 * @addtogroup STU_Peripheral_Access_Layer STU Peripheral Access Layer
 * @{
 */


/** STU - Size of Registers Arrays */

/* STU Register Layout Typedef */
typedef struct {
    uint32 CTRL;                               /**< Control Register, offset: 0x0000 */
    uint32 CUT_CNT;                            /**< Clock Under Test Count Register, offset: 0x0004 */
    uint32 REF_CNT;                            /**< Reference Clock Count Register, offset: 0x0008 */
    uint32 CUT_TARGET;                         /**< Under Test Target Count Register, offset: 0x000C */
    uint32 REF_TARGET;                         /**< Reference Clock Target Count Register, offset: 0x0010 */
    uint32 STS;                                /**< Status Register, offset: 0x0014 */
    uint32 REF_CNT_SAVED;                      /**< Reference Clock Count Saved Register, offset: 0x0018 */

} STU_Type, *STU_MemMapPtr;

/** Number of instances of the STU module. */
#define STU_INSTANCE_COUNT                        (1u)

/* STU base address */
#define STU_BASE_ADDR32                                   (0x40077000U)
#define STU                                               ((volatile STU_Type *)(STU_BASE_ADDR32))

/** Array initializer of STU peripheral base addresses */
#define STU_BASE_ADDRS                                     { STU_BASE_ADDR32 }
/** Array initializer of STU peripheral base pointers */
#define STU_BASE_PTRS                                      { STU }

#define STU_CTRL_OFFSET32                                  (0x0000U)                    /**< Offset for Control Register */
#define STU_CUT_CNT_OFFSET32                               (0x0004U)                    /**< Offset for Clock Under Test Count Register */
#define STU_REF_CNT_OFFSET32                               (0x0008U)                    /**< Offset for Reference Clock Count Register */
#define STU_CUT_TARGET_OFFSET32                            (0x000CU)                    /**< Offset for Under Test Target Count Register */
#define STU_REF_TARGET_OFFSET32                            (0x0010U)                    /**< Offset for Reference Clock Target Count Register */
#define STU_STS_OFFSET32                                   (0x0014U)                    /**< Offset for Status Register */
#define STU_REF_CNT_SAVED_OFFSET32                         (0x0018U)                    /**< Offset for Reference Clock Count Saved Register */


/**
 * @addtogroup STU Register Mask
 * @{
 */
/* STU_CTRL Register */
#define STU_CTRL_CUT_SEL_MASK                              (0x7F00U)
#define STU_CTRL_CUT_SEL_SHIFT                             (8U)
#define STU_CTRL_CUT_SEL(x)                                (((uint32)(((uint32)(x)) << STU_CTRL_CUT_SEL_SHIFT)) & STU_CTRL_CUT_SEL_MASK)
#define STU_CTRL_CUT_PREDIV_MASK                           (0xFFU)
#define STU_CTRL_CUT_PREDIV_SHIFT                          (0U)
#define STU_CTRL_CUT_PREDIV(x)                             (((uint32)(((uint32)(x)) << STU_CTRL_CUT_PREDIV_SHIFT)) & STU_CTRL_CUT_PREDIV_MASK)
/* STU_CUT_CNT Register */
#define STU_CUT_CNT_CUT_CNT_MASK                           (0xFFFFFFFFU)
#define STU_CUT_CNT_CUT_CNT_SHIFT                          (0U)
#define STU_CUT_CNT_CUT_CNT(x)                             (((uint32)(((uint32)(x)) << STU_CUT_CNT_CUT_CNT_SHIFT)) & STU_CUT_CNT_CUT_CNT_MASK)
/* STU_REF_CNT Register */
#define STU_REF_CNT_REF_CNT_MASK                           (0xFFFFFFFFU)
#define STU_REF_CNT_REF_CNT_SHIFT                          (0U)
#define STU_REF_CNT_REF_CNT(x)                             (((uint32)(((uint32)(x)) << STU_REF_CNT_REF_CNT_SHIFT)) & STU_REF_CNT_REF_CNT_MASK)
/* STU_CUT_TARGET Register */
#define STU_CUT_TARGET_CUT_TARGET_MASK                     (0xFFFFFFFFU)
#define STU_CUT_TARGET_CUT_TARGET_SHIFT                    (0U)
#define STU_CUT_TARGET_CUT_TARGET(x)                       (((uint32)(((uint32)(x)) << STU_CUT_TARGET_CUT_TARGET_SHIFT)) & STU_CUT_TARGET_CUT_TARGET_MASK)
/* STU_REF_TARGET Register */
#define STU_REF_TARGET_REF_TARGET_MASK                     (0xFFFFFFFFU)
#define STU_REF_TARGET_REF_TARGET_SHIFT                    (0U)
#define STU_REF_TARGET_REF_TARGET(x)                       (((uint32)(((uint32)(x)) << STU_REF_TARGET_REF_TARGET_SHIFT)) & STU_REF_TARGET_REF_TARGET_MASK)
/* STU_STS Register */
#define STU_STS_CUT_CNT_START_MASK                         (0x4U)
#define STU_STS_CUT_CNT_START_SHIFT                        (2U)
#define STU_STS_CUT_CNT_START(x)                           (((uint32)(((uint32)(x)) << STU_STS_CUT_CNT_START_SHIFT)) & STU_STS_CUT_CNT_START_MASK)
#define STU_STS_CUT_CNT_STOP_MASK                          (0x2U)
#define STU_STS_CUT_CNT_STOP_SHIFT                         (1U)
#define STU_STS_CUT_CNT_STOP(x)                            (((uint32)(((uint32)(x)) << STU_STS_CUT_CNT_STOP_SHIFT)) & STU_STS_CUT_CNT_STOP_MASK)
#define STU_STS_REF_CNT_STOP_MASK                          (0x1U)
#define STU_STS_REF_CNT_STOP_SHIFT                         (0U)
#define STU_STS_REF_CNT_STOP(x)                            (((uint32)(((uint32)(x)) << STU_STS_REF_CNT_STOP_SHIFT)) & STU_STS_REF_CNT_STOP_MASK)
/* STU_REF_CNT_SAVED Register */
#define STU_REF_CNT_SAVED_REF_CNT_SAVED_MASK               (0xFFFFFFFFU)
#define STU_REF_CNT_SAVED_REF_CNT_SAVED_SHIFT              (0U)
#define STU_REF_CNT_SAVED_REF_CNT_SAVED(x)                 (((uint32)(((uint32)(x)) << STU_REF_CNT_SAVED_REF_CNT_SAVED_SHIFT)) & STU_REF_CNT_SAVED_REF_CNT_SAVED_MASK)


/**
 * @}
 */ /* end of group STU_Register_Masks */


/**
 * @}
 */ /* end of group STU_Peripheral_Access_Layer */

#endif /* PSIP_STU_H */

