/*
 * Copyright 2017-2018 YTM
 * All rights reserved.
 *
 * YTM Confidential. This software is owned or controlled by YTM and may only be
 * used strictly in accordance with the applicable license terms. By expressly
 * accepting such terms or by downloading, installing, activating and/or otherwise
 * using the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software. The production use license in
 * Section 2.3 is expressly granted for this software.
 */


#include "device_registers.h"
#include "system_YTM32B1LE0.h"
#include "stdbool.h"

/* ----------------------------------------------------------------------------
   -- Core clock
   ---------------------------------------------------------------------------- */

uint32_t SystemCoreClock = DEFAULT_SYSTEM_CLOCK;

#define CPM_REG_BASE              (0x40064000)

#define CPM_PMUTRIM               (*((volatile uint32_t *) (CPM_REG_BASE + 0x20)))
#define CPM_FIRCTRIM              (*((volatile uint32_t *) (CPM_REG_BASE + 0x24)))



/*FUNCTION**********************************************************************
 *
 * Function Name : SystemInit
 * Description   : This function disables the watchdog, enables FPU
 * and the power mode protection if the corresponding feature macro
 * is enabled. SystemInit is called from startup_device file.
 *
 * Implements    : SystemInit_Activity
 *END**************************************************************************/
void SystemInit(void)
{
/**************************************************************************/
/* RCU CONTROL */
/**************************************************************************/
    IPC->CTRL[IPC_CIM_INDEX] |= IPC_CTRL_CLKEN_MASK;
    CIM->CTRL |= CIM_CTRL_LOCKUPEN_MASK;
/**************************************************************************/
/* WDOG DISABLE*/
/**************************************************************************/
#if (DISABLE_WDOG)
    WDG->SVCR = 0xB631;
    WDG->SVCR = 0xC278;
    WDG->CR &= ~WDG_CR_EN_MASK;
#endif /* (DISABLE_WDOG) */
    /* Enable flash prefetch */
    EFM->CTRL |= EFM_CTRL_PREFETCH_EN_MASK;
}

/*FUNCTION**********************************************************************
 *
 * Function Name : SystemCoreClockUpdate
 * Description   : This function must be called whenever the core clock is changed
 * during program execution. It evaluates the clock register settings and calculates
 * the current core clock.
 *
 * Implements    : SystemCoreClockUpdate_Activity
 *END**************************************************************************/
void SystemCoreClockUpdate(void)
{
}

/*FUNCTION**********************************************************************
 *
 * Function Name : SystemSoftwareReset
 * Description   : This function is used to initiate a system reset
 *
 * Implements    : SystemSoftwareReset_Activity
 *END**************************************************************************/
void SystemSoftwareReset(void)
{
    uint32_t regValue;

    /* Read Application Interrupt and Reset Control Register */
    regValue = SDK_SCB->AIRCR;

    /* Clear register key */
    regValue &= ~( SDK_SCB_AIRCR_VECTKEY_MASK);

    /* Configure System reset request bit and Register Key */
    regValue |= SDK_SCB_AIRCR_VECTKEY(FEATURE_SCB_VECTKEY);
    regValue |= SDK_SCB_AIRCR_SYSRESETREQ(0x1u);

    /* Write computed register value */
    SDK_SCB->AIRCR = regValue;
}

/*******************************************************************************
 * EOF
 ******************************************************************************/
