# Description

The YTM32 Software Development Kit (YTM32 SDK) is an extensive suite of peripheral abstraction layers, peripheral drivers, RTOS and so on designed to simplify and accelerate application development on Yuntu Microcontrollers.

# Directory Structure

- SDK
  - CMSIS
  - platform
  - rtos
  - freertos (v10.4.6)
  - utility

# Compiler and IDE versions

SDK contains many demos base on Yuntu Config Tool(YCT), and the version of supported IDE as follows:

- GCC (9.3.1)
- IAR (8.40)
- MDK (5.35)

# YTM32B1LE0 release change Log

## YTM32B1LE0 1.1.0

- [Bug]: Fixed ACMP clear channel flag and clear output flag functions.
- [Bug]: Fixed data assignment operation and command launch may be interrupted by other flash address assignment operation during this period.
- [Bug]: Fixed the macro of the configuration register is used incorrently in the FLEXCAN_SetEnchanceRxFifoFilter function of flexcan_hw_access.c.
- [Bug]: FLEXCAN_SetMsgBuffIntCmd() needs to disable global interrupt and enable in the end.
- [Bug]: Fix issue in flexcan_driver.h: Correct eventType type for error_callback member in flexcan_state_t struct.
- [Bug]: Fixed the baud rate calculation formula for i2c in the SDK does not match the actual situation.
- [Bug]: Fixed ptmr irqs compile error.
- [Bug]: Fixed the enum value of sync with trigger for register loading, counter loading and chmask loading.
- [Bug]: Fixed QDTOF, TOF, RF and Fault flag clear issue.
- [Bug]: Fixed etmr_qd_mode_t enum value issue.
- [Bug]: Fixed wakeup issue from low power when using FXOSC.

- [New]: Added YCT demos.
- [New]: Added instance parameter for each API of flash driver.
- [New]: Added I2C idle timeout function.
- [New]: Added eTMR_DRV_SetChnsetIntEnable and eTMR_DRV_SetChnsetIntDisable functions to enable/disable channel interrupt at the same time.
- [New]: Added output obtain functions ACMP_DRV_GetOutput and ACMP_DRV_GetChannelOutput.
- [New]: Added enable and disable ACMP continuous mode function.
- [New]: Added UART_DRV_SetErrorInterrupts function.

- [Improve]: Optimized the sequence to start ADC, first enable, then start.
- [Improve]: Implement slave address shift left 1 bit in the I2C_DRV_SlaveInit function, not in the configuration struct.
- [Improve]: Added the function that clear etmr state in eTMR_DRV_Deinit API.
- [Improve]: Redefined the element of etmr_user_config_t debugMode=true stands for enable debug mode, debugMode=false stands for disable debug mode.
- [Improve]: Redefined the element of etmr_user_config_t syncMethod->regSyncFreq = 1 stands for 1 cycle.
- [Improve]: Used IPC software reset to reset eTMR registers.
- [Improve]: Updated the etmr_pwm_ch_param_t and etmr_pwm_param_t struct.
- [Improve]: Capitalized etmr_fault_input_polarity_t elements.
- [Improve]: Updated the name of etmr_polarity_t elements.
- [Improve]: Improved eTMR_DRV_InitPwm, eTMR_DRV_DeinitPwm, eTMR_DRV_Init APIs, but not change input parameters.
- [Improve]: Changed eTMR_DRV_UpdatePwmChannelValue to eTMR_DRV_UpdatePwmPeriodAndDuty, and updated the parameters, it can update period and duty cycle in the meanwhile.
- [Improve]: Updated eTMR_DRV_UpdatePwmChannel parameters, removed typeOfUpdate and alignMode parameters, since these two parameters do not modified generally.
- [Improve]: Updated eTMR_DRV_UpdatePwmPeriod, just remained newPeriod parameter and added a new parameter unit, and this api just update the period.
- [Improve]: Updated the struct etmr_oc_ch_param_t. Added interrupt enable configuration.
- [Improve]: Updated eTMR_DRV_DeinitOutputCompare API.
- [Improve]: Added clear load ok in the eTMR_DRV_SetChnOutMask API.
- [Improve]: Removed internalCurrentControl element in acmp_comparator_config_t struct because of no feature in the device.

## Updated API Illustration

- ACMP:
    - ACMP_DRV_EnableContinuous: Added to enable continuous mode.
    - ACMP_DRV_DisableContinuous: Added to disable continuous mode.
    - ACMP_DRV_GetOutput: Added to get acmp output value.
    - ACMP_DRV_GetChannelOutput: Added to get channel output value in continuous mode.
- ADC:
    - ADC_DRV_GetReadyFlag: This function returns the state of the ADC Ready.
    - ADC_DRV_GetSampEndFlag: This function returns the state of the Sample End.
    - ADC_DRV_ClearReadyFlagCmd: This function is used to clear Eeady flag.
    - ADC_DRV_ClearSampEndFlagCmd: This function is used to clear Sample End flag.
- Flash:
    - Need to add instance parameter for each api.
- I2C:
    - I2C_DRV_MasterSetBaudRate: This API fixes the baud rate calculation formula, and adds idle timeout function.
    - I2C_DRV_SlaveInit: This API implements slave address shift left 1 bit, not in the i2c peripheral configuration.
- eTMR:
    - eTMR_DRV_Deinit: This API adds feature that clear etmr state.
    - eTMR_DRV_SetChnOutMask: This API adds clear load ok before setting out mask.
    - eTMR_DRV_UpdatePwmPeriodAndDuty: eTMR_DRV_UpdatePwmChannelValue is modified to eTMR_DRV_UpdatePwmPeriodAndDuty, and updates period and duty cycle according to input parameters fastly.
    - eTMR_DRV_UpdatePwmChannel: This API removes typeOfUpdate and alignMode parameters, and just considers different duty cycles.
    - eTMR_DRV_UpdatePwmPeriod: This API changes parameters, and just updates pwm period.
    - eTMR_DRV_SyncWithSoftTrigger: Added to use software synchronization to reload register value.
- UART:
    - UART_DRV_SetErrorInterrupts: Enable or disable the UART error interrupts.

# YTM32B1MC0 release change Log

## YTM32B1MC0 1.0.0