/*
 *  Copyright 2020-2024 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file Wdg_Mld_Cfg.h
 * @brief 
 * 
 */


#ifndef WDG_MLD_CFG_H
#define WDG_MLD_CFG_H

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
 *                                         INCLUDE FILES                                         
==================================================================================================*/
#include "Wdg_Lld_Cfg.h"
#include "Ewdg_Lld_Cfg.h"

/*==================================================================================================
 *                                 SOURCE FILE VERSION INFORMATION                                 
==================================================================================================*/
#define WDG_MLD_CFG_VENDOR_ID           (180)
#define WDG_MLD_CFG_AR_REL_MAJOR_VER    (4)
#define WDG_MLD_CFG_AR_REL_MINOR_VER    (4)
#define WDG_MLD_CFG_AR_REL_REVISION_VER (0)
#define WDG_MLD_CFG_SW_MAJOR_VER        (2)
#define WDG_MLD_CFG_SW_MINOR_VER        (0)
#define WDG_MLD_CFG_SW_PATCH_VER        (0)

/*==================================================================================================
 *                                       DEFINES AND MACROS                                       
==================================================================================================*/
/**
 * @brief   WDG INST0 enable
 */
#define WDG_MLD_INST0_ENABLE        (WDG_LLD_ENABLE)

/**
 * @brief   WDG INST1 enable
 */
#define WDG_MLD_INST1_ENABLE        (EWDG_LLD_ENABLE)

/**
 * @brief   WDG MLD development error detection
 */
#define WDG_MLD_DEV_ERROR_DETECT    (WDG_LLD_DEV_ERROR_DETECT || EWDG_LLD_DEV_ERROR_DETECT)

/**
 * @brief   WDG MLD interrupt 0 used
 */
#define WDG_MLD_ISR0_USED           (WDG_LLD_ISR_USED)

/**
 * @brief   WDG MLD interrupt 1 used
 */
#define WDG_MLD_ISR1_USED           (EWDG_LLD_ISR_USED)

/**
 * @brief   WDG MLD run on ROM or RAM
 */
#define WDG_MLD_RUN_ON_ROM          (WDG_LLD_RUN_ON_ROM || EWDG_LLD_RUN_ON_ROM)

/**
 * @brief   WDG MLD deinit API
 */
#define WDG_MLD_DEINIT_API          (WDG_LLD_DEINIT_API || EWDG_LLD_DEINIT_API)

#ifdef __cplusplus
}
#endif

#endif /* WDG_MLD_CFG_H */

/** @} */
