/*
 *  Copyright 2020-2024 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file Wdg_Lld_PBcfg.h
 * @brief 
 * 
 */


#ifndef WDG_LLD_PBCFG_H
#define WDG_LLD_PBCFG_H

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
 *                                          INCLUDE FILES                                          
==================================================================================================*/
#include "Wdg_Lld_Cfg.h"
#include "Wdg_Lld_Types.h"

/*==================================================================================================
 *                                 SOURCE FILE VERSION INFORMATION                                 
==================================================================================================*/
#define WDG_LLD_PBCFG_VENDOR_ID             (180)
#define WDG_LLD_PBCFG_AR_REL_MAJOR_VER      (4)
#define WDG_LLD_PBCFG_AR_REL_MINOR_VER      (4)
#define WDG_LLD_PBCFG_AR_REL_REVISION_VER   (0)
#define WDG_LLD_PBCFG_SW_MAJOR_VER          (2)
#define WDG_LLD_PBCFG_SW_MINOR_VER          (0)
#define WDG_LLD_PBCFG_SW_PATCH_VER          (0)    

/*==================================================================================================
 *                                  GLOBAL CONSTANTS DECLARATIONS                                  
==================================================================================================*/
#define WDG_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "Wdg_MemMap.h"

WDG_CONST extern const Wdg_Lld_ConfigType Wdg_Lld_OffModeSettings_Config;
WDG_CONST extern const Wdg_Lld_ConfigType Wdg_Lld_SlowModeSettings_Config;
WDG_CONST extern const Wdg_Lld_ConfigType Wdg_Lld_FastModeSettings_Config;

#define WDG_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "Wdg_MemMap.h"

/*==================================================================================================
 *                                      FUNCTION PROTOTYPES
==================================================================================================*/

#ifdef __cplusplus
}
#endif

#endif /* WDG_LLD_PBCFG_H */

/** @} */
