/*
 *  Copyright 2020-2024 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file Wdg_Lld_Cfg.h
 * @brief 
 * 
 */


#ifndef WDG_LLD_CFG_H
#define WDG_LLD_CFG_H

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
 *                                         INCLUDE FILES                                         
==================================================================================================*/
#include "Std_Types.h"

/*==================================================================================================
 *                                 SOURCE FILE VERSION INFORMATION                                 
==================================================================================================*/
#define WDG_LLD_CFG_VENDOR_ID           (180)
#define WDG_LLD_CFG_AR_REL_MAJOR_VER    (4)
#define WDG_LLD_CFG_AR_REL_MINOR_VER    (4)
#define WDG_LLD_CFG_AR_REL_REVISION_VER (0)
#define WDG_LLD_CFG_SW_MAJOR_VER        (2)
#define WDG_LLD_CFG_SW_MINOR_VER        (0)
#define WDG_LLD_CFG_SW_PATCH_VER        (0)

/*==================================================================================================
 *                                       DEFINES AND MACROS                                       
==================================================================================================*/
/**
 * @brief   WDG development error detection
 */
#define WDG_LLD_DEV_ERROR_DETECT    (STD_ON)

/**
 * @brief   WDG enable
 */
#define WDG_LLD_ENABLE              (STD_ON)

/**
 * @brief   WDG interrupt used
 */
#define WDG_LLD_ISR_USED            (STD_OFF)

/**
 * @brief   WDG run on ROM or RAM
 */
#define WDG_LLD_RUN_ON_ROM          (STD_ON)

/**
 * @brief   WDG deinit API
 */
#define WDG_LLD_DEINIT_API          (STD_ON)

/**
 * @brief   WDG timeout count
 */
#define WDG_LLD_TIMEOUT_COUNT       (65535UL)

#ifdef __cplusplus
}
#endif

#endif /* WDG_LLD_CFG_H */

/** @} */
