/*
 *  Copyright 2020-2024 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file Wdg_Cfg.c
 * @brief 
 * 
 */


#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
 *                                          INCLUDE FILES                                          
==================================================================================================*/
#include "Wdg_Cfg.h"

/*==================================================================================================
 *                                 SOURCE FILE VERSION INFORMATION                                 
==================================================================================================*/
#define WDG_VENDOR_ID_CFG_C             (180)
#define WDG_AR_REL_MAJOR_VER_CFG_C      (4)
#define WDG_AR_REL_MINOR_VER_CFG_C      (4)
#define WDG_AR_REL_REVISION_VER_CFG_C   (0)
#define WDG_SW_MAJOR_VER_CFG_C          (2)
#define WDG_SW_MINOR_VER_CFG_C          (0)
#define WDG_SW_PATCH_VER_CFG_C          (0)

/*==================================================================================================
 *                                         GLOBAL CONSTANTS                                         
==================================================================================================*/
#define WDG_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "Wdg_MemMap.h"

WDG_CONST const uint16 Wdg_InitialTimeoutCfg[WDG_NO_OF_INSTANCES] = 
{
    WDG_180_INST0_INITIAL_TIMEOUT,
    WDG_180_INST1_INITIAL_TIMEOUT
};

WDG_CONST const uint16 Wdg_MaxTimeoutCfg[WDG_NO_OF_INSTANCES] = 
{
    WDG_180_INST0_MAX_TIMEOUT,
    WDG_180_INST1_MAX_TIMEOUT
};

#define WDG_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "Wdg_MemMap.h"

#define WDG_START_SEC_CONST_UNSPECIFIED
#include "Wdg_MemMap.h"

extern WDG_CONST const Wdg_ConfigType Wdg_180_Inst0_Config;
extern WDG_CONST const Wdg_ConfigType Wdg_180_Inst1_Config;

WDG_CONST const Wdg_ConfigType * const Wdg_Config[WDG_NO_OF_INSTANCES] = 
{
    &Wdg_180_Inst0_Config,
    &Wdg_180_Inst1_Config
};

#define WDG_STOP_SEC_CONST_UNSPECIFIED
#include "Wdg_MemMap.h"

#ifdef __cplusplus
}
#endif

/** @} */
