/*
 *  Copyright 2020-2024 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file Wdg_180_Inst1_Mld_PBcfg.c
 * @brief 
 * 
 */


#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
 *                                          INCLUDE FILES                                          
==================================================================================================*/
#include "Wdg_180_Inst1_Mld_PBcfg.h"
#include "Ewdg_Lld_PBcfg.h"

/*==================================================================================================
 *                                 SOURCE FILE VERSION INFORMATION                                 
==================================================================================================*/
#define WDG_180_INST1_MLD_VENDOR_ID_PBCFG_C             (180)
#define WDG_180_INST1_MLD_AR_REL_MAJOR_VER_PBCFG_C      (4)
#define WDG_180_INST1_MLD_AR_REL_MINOR_VER_PBCFG_C      (4)
#define WDG_180_INST1_MLD_AR_REL_REVISION_VER_PBCFG_C   (0)
#define WDG_180_INST1_MLD_SW_MAJOR_VER_PBCFG_C          (2)
#define WDG_180_INST1_MLD_SW_MINOR_VER_PBCFG_C          (0)
#define WDG_180_INST1_MLD_SW_PATCH_VER_PBCFG_C          (0)

/*==================================================================================================
 *                                         GLOBAL CONSTANTS                                         
==================================================================================================*/
#define WDG_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "Wdg_MemMap.h"

WDG_CONST const Wdg_Mld_ConfigType Wdg_180_Inst1_Mld_SlowModeSettings_Config = 
{
    .WdgMldIp = WDG_MLD_IP_EWDG,
#if (WDG_LLD_ENABLE == STD_ON)
    .WdgConfig = NULL_PTR,
#endif
    .EwdgConfig = &Ewdg_Lld_SlowModeSettings_Config
};

#define WDG_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "Wdg_MemMap.h"

#ifdef __cplusplus
}
#endif

/** @} */
