/*
 *  Copyright 2020-2024 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file undefined
 * @brief 
 * 
 */


#ifndef SPI_PB_CFG_H
#define SPI_PB_CFG_H

/*==================================================================================================
*                                        INCLUDE FILES
==================================================================================================*/
#include "Std_Types.h"

/*==================================================================================================
*                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define SPI_VENDOR_ID_PBCFG                         (180)
#define SPI_AR_REL_MAJOR_VER_PBCFG                  (4)
#define SPI_AR_REL_MINOR_VER_PBCFG                  (4)
#define SPI_AR_REL_REVISION_VER_PBCFG               (0)
#define SPI_SW_MAJOR_VER_PBCFG                      (2)
#define SPI_SW_MINOR_VER_PBCFG                      (0)
#define SPI_SW_PATCH_VER_PBCFG                      (0)

/**
 * @brief        This parameter contains the number of Channels configured. It will be gathered by tools during the configuration stage.
 * @details      Defines the maximum number of supported channels for all the driver configurations.
 *
 * @ref          ECUC_Spi_00197
 */
#define SpiConf_SpiChannel_SpiChannel_0             ((Spi_ChannelType)0U)
#define SpiConf_SpiChannel_SpiChannel_1             ((Spi_ChannelType)1U)
#define SpiConf_SpiChannel_SpiChannel_2             ((Spi_ChannelType)2U)
#define SpiConf_SpiChannel_SpiChannel_3             ((Spi_ChannelType)3U)
#define SPI_MAX_CHANNEL                             (4U)

/**
 * @brief        Total number of Jobs configured.
 * @details      Defines the maximum number of supported jobs for all the driver configurations.
 *
 * @ref          ECUC_Spi_00198
 */
#define SpiConf_SpiJob_SpiJob_0                     ((Spi_JobType)0U)
#define SpiConf_SpiJob_SpiJob_1                     ((Spi_JobType)1U)
#define SpiConf_SpiJob_SpiJob_2                     ((Spi_JobType)2U)
#define SpiConf_SpiJob_SpiJob_3                     ((Spi_JobType)3U)
#define SpiConf_SpiJob_SpiJob_4                     ((Spi_JobType)4U)
#define SpiConf_SpiJob_SpiJob_5                     ((Spi_JobType)5U)
#define SPI_MAX_JOB                                 (6U)

/**
 * @brief        Total number of Sequences configured.
 * @details      Defines the maximum number of supported sequences for all the driver configurations.
 *
 * @ref          ECUC_Spi_00199
 */
#define SpiConf_SpiSequence_SpiSequence_SPI1_PCS1           ((Spi_SequenceType)0U)
#define SpiConf_SpiSequence_SpiSequence_SPI1_PCS3           ((Spi_SequenceType)1U)
#define SpiConf_SpiSequence_SpiSequence_SPI5_PCS3           ((Spi_SequenceType)2U)
#define SpiConf_SpiSequence_SpiSequence_SPI5_PCS2           ((Spi_SequenceType)3U)
#define SpiConf_SpiSequence_SpiSequence_SPI0_PCS0           ((Spi_SequenceType)4U)
#define SpiConf_SpiSequence_SpiSequence_SPI2_PCS0           ((Spi_SequenceType)5U)
#define SPI_MAX_SEQUENCE                            (6U)

#define Spi_CONFIG_PB \
    extern const Spi_ConfigType Spi_Config;

#endif
