/*
 *  Copyright 2020-2024 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file undefined
 * @brief 
 * 
 */


/*==================================================================================================
*                                        INCLUDE FILES
==================================================================================================*/
#include "Spi_Cfg.h"
#include "Spi.h"
#if (SPI_DMA_USED == STD_ON)
#include "CddDma_Cfg.h"
#endif

#if (SPI_ENABLE_DEM_REPORT_ERROR_STATUS == STD_ON)
#include "Dem.h"
#endif

/*==================================================================================================
*                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define SPI_VENDOR_ID_PBCFG_C                       (180)
#define SPI_AR_REL_MAJOR_VER_PBCFG_C                (4)
#define SPI_AR_REL_MINOR_VER_PBCFG_C                (4)
#define SPI_AR_REL_REVISION_VER_PBCFG_C             (0)
#define SPI_SW_MAJOR_VER_PBCFG_C                    (2)
#define SPI_SW_MINOR_VER_PBCFG_C                    (0)
#define SPI_SW_PATCH_VER_PBCFG_C                    (0)

/*================================================================================================== */
#if (SPI_ENABLE_DEM_REPORT_ERROR_STATUS == STD_ON)
/* Check if Spi_PBcfg.c file and Dem.h file are of the same Autosar version */
#if ((SPI_AR_REL_MAJOR_VER_PBCFG_C != DEM_AR_REL_MAJOR_VER) || \
     (SPI_AR_REL_MINOR_VER_PBCFG_C != DEM_AR_REL_MINOR_VER))
    #error "AutoSar Version Numbers of Spi_PBcfg.c and Dem.h are different"
#endif
#endif

/*================================================================================================== 
*                              GLOBAL FUNCTIONS
==================================================================================================*/

/* List of Notification Functions*/
/* Job end notifications*/

/* Sequence end notifications*/



/*==================================================================================================
*                                       LOCAL VARIABLES
==================================================================================================*/
#define SPI_START_SEC_VAR_CLEARED_UNSPECIFIED_NO_CACHEABLE
#include "Spi_MemMap.h"

/* Buffers Descriptors for EB Channels and Allocate Buffers for IB Channels */
SPI_VAR __attribute__((aligned(4))) static Spi_BufferDescriptorType Spi_EbDefaultBuffer_SpiChannel_SpiChannel_0;
SPI_VAR __attribute__((aligned(4))) static Spi_BufferDescriptorType Spi_EbDefaultBuffer_SpiChannel_SpiChannel_1;
SPI_VAR __attribute__((aligned(4))) static Spi_BufferDescriptorType Spi_EbDefaultBuffer_SpiChannel_SpiChannel_2;
SPI_VAR __attribute__((aligned(4))) static Spi_BufferDescriptorType Spi_EbDefaultBuffer_SpiChannel_SpiChannel_3;

#define SPI_STOP_SEC_VAR_CLEARED_UNSPECIFIED_NO_CACHEABLE
#include "Spi_MemMap.h"

#define SPI_START_SEC_VAR_INIT_UNSPECIFIED
#include "Spi_MemMap.h"

/* Buffers Descriptors for IB Channels */

/* Channel Configuration */
SPI_VAR static Spi_ChannelConfigType Spi_ChannelConfigs[4] =
{
    /* Channel Configuration for SpiChannel_ID: 0*/
    {
        .BufferType = SPI_EB,
        .DataWidth = 16U,
        .Length =  32,
        .MsbOrLsbFirst = MSB_FIRST,
        .DefaultValue = 100U,
        .BufferDescriptorPtr = &Spi_EbDefaultBuffer_SpiChannel_SpiChannel_0,
    },
    /* Channel Configuration for SpiChannel_ID: 1*/
    {
        .BufferType = SPI_EB,
        .DataWidth = 16U,
        .Length =  32,
        .MsbOrLsbFirst = MSB_FIRST,
        .DefaultValue = 100U,
        .BufferDescriptorPtr = &Spi_EbDefaultBuffer_SpiChannel_SpiChannel_1,
    },
    /* Channel Configuration for SpiChannel_ID: 2*/
    {
        .BufferType = SPI_EB,
        .DataWidth = 16U,
        .Length =  32,
        .MsbOrLsbFirst = MSB_FIRST,
        .DefaultValue = 1U,
        .BufferDescriptorPtr = &Spi_EbDefaultBuffer_SpiChannel_SpiChannel_2,
    },
    /* Channel Configuration for SpiChannel_ID: 3*/
    {
        .BufferType = SPI_EB,
        .DataWidth = 16U,
        .Length =  32,
        .MsbOrLsbFirst = MSB_FIRST,
        .DefaultValue = 1U,
        .BufferDescriptorPtr = &Spi_EbDefaultBuffer_SpiChannel_SpiChannel_3,
    },
};

#define SPI_STOP_SEC_VAR_INIT_UNSPECIFIED
#include "Spi_MemMap.h"

#define SPI_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "Spi_MemMap.h"

/* Channel Assignment of Jobs*/
/* Spi Job_ID: 0*/
SPI_CONST static const Spi_ChannelType Spi_Job_0_ChannelAssignment[1] =
{
    SpiConf_SpiChannel_SpiChannel_0,
};
/* Spi Job_ID: 1*/
SPI_CONST static const Spi_ChannelType Spi_Job_1_ChannelAssignment[1] =
{
    SpiConf_SpiChannel_SpiChannel_0,
};
/* Spi Job_ID: 2*/
SPI_CONST static const Spi_ChannelType Spi_Job_2_ChannelAssignment[1] =
{
    SpiConf_SpiChannel_SpiChannel_1,
};
/* Spi Job_ID: 3*/
SPI_CONST static const Spi_ChannelType Spi_Job_3_ChannelAssignment[1] =
{
    SpiConf_SpiChannel_SpiChannel_1,
};
/* Spi Job_ID: 4*/
SPI_CONST static const Spi_ChannelType Spi_Job_4_ChannelAssignment[1] =
{
    SpiConf_SpiChannel_SpiChannel_2,
};
/* Spi Job_ID: 5*/
SPI_CONST static const Spi_ChannelType Spi_Job_5_ChannelAssignment[1] =
{
    SpiConf_SpiChannel_SpiChannel_3,
};

/* Configuration of Jobs*/
SPI_CONST static const Spi_JobConfigType Spi_JobConfigs[6] =
{ 
    /* Job configuration for SpiJob_ID: 0*/
    {
        .HWUnit = 0U,
        .Priority = 0,
        .ChannelLinkPtr = Spi_Job_0_ChannelAssignment,
        .NumChannels = 1U,
        .JobEndNotification = NULL_PTR,
        .JobStatePtr = &Spi_JobState[0],
    },
    /* Job configuration for SpiJob_ID: 1*/
    {
        .HWUnit = 1U,
        .Priority = 0,
        .ChannelLinkPtr = Spi_Job_1_ChannelAssignment,
        .NumChannels = 1U,
        .JobEndNotification = NULL_PTR,
        .JobStatePtr = &Spi_JobState[1],
    },
    /* Job configuration for SpiJob_ID: 2*/
    {
        .HWUnit = 3U,
        .Priority = 0,
        .ChannelLinkPtr = Spi_Job_2_ChannelAssignment,
        .NumChannels = 1U,
        .JobEndNotification = NULL_PTR,
        .JobStatePtr = &Spi_JobState[2],
    },
    /* Job configuration for SpiJob_ID: 3*/
    {
        .HWUnit = 2U,
        .Priority = 0,
        .ChannelLinkPtr = Spi_Job_3_ChannelAssignment,
        .NumChannels = 1U,
        .JobEndNotification = NULL_PTR,
        .JobStatePtr = &Spi_JobState[3],
    },
    /* Job configuration for SpiJob_ID: 4*/
    {
        .HWUnit = 4U,
        .Priority = 0,
        .ChannelLinkPtr = Spi_Job_4_ChannelAssignment,
        .NumChannels = 1U,
        .JobEndNotification = NULL_PTR,
        .JobStatePtr = &Spi_JobState[4],
    },
    /* Job configuration for SpiJob_ID: 5*/
    {
        .HWUnit = 5U,
        .Priority = 0,
        .ChannelLinkPtr = Spi_Job_5_ChannelAssignment,
        .NumChannels = 1U,
        .JobEndNotification = NULL_PTR,
        .JobStatePtr = &Spi_JobState[5],
    },
};

/* Job Assignment of Sequence*/
/* Spi Sequence_ID: 0*/
SPI_CONST static const Spi_JobType Spi_Sequence_0_JobAssignment[1] =
{
    SpiConf_SpiJob_SpiJob_0,
};
/* Spi Sequence_ID: 1*/
SPI_CONST static const Spi_JobType Spi_Sequence_1_JobAssignment[1] =
{
    SpiConf_SpiJob_SpiJob_1,
};
/* Spi Sequence_ID: 2*/
SPI_CONST static const Spi_JobType Spi_Sequence_2_JobAssignment[1] =
{
    SpiConf_SpiJob_SpiJob_2,
};
/* Spi Sequence_ID: 3*/
SPI_CONST static const Spi_JobType Spi_Sequence_3_JobAssignment[1] =
{
    SpiConf_SpiJob_SpiJob_3,
};
/* Spi Sequence_ID: 4*/
SPI_CONST static const Spi_JobType Spi_Sequence_4_JobAssignment[1] =
{
    SpiConf_SpiJob_SpiJob_4,
};
/* Spi Sequence_ID: 5*/
SPI_CONST static const Spi_JobType Spi_Sequence_5_JobAssignment[1] =
{
    SpiConf_SpiJob_SpiJob_5,
};

/* Configuration of Sequences */
SPI_CONST static const Spi_SequenceConfigType Spi_SequenceConfigs[6] =
{
    /* Sequence Configuration for SpiSequence_ID: 0 */
    {
        .NumJobs = 1U,
        .SeqEndNotification = NULL_PTR,
        .JobIndexListPtr = Spi_Sequence_0_JobAssignment,
#if (SPI_INTERRUPTIBLE_SEQ_ALLOWED == STD_ON)
        .Interruptible = TRUE,
#endif
    },
    /* Sequence Configuration for SpiSequence_ID: 1 */
    {
        .NumJobs = 1U,
        .SeqEndNotification = NULL_PTR,
        .JobIndexListPtr = Spi_Sequence_1_JobAssignment,
#if (SPI_INTERRUPTIBLE_SEQ_ALLOWED == STD_ON)
        .Interruptible = TRUE,
#endif
    },
    /* Sequence Configuration for SpiSequence_ID: 2 */
    {
        .NumJobs = 1U,
        .SeqEndNotification = NULL_PTR,
        .JobIndexListPtr = Spi_Sequence_2_JobAssignment,
#if (SPI_INTERRUPTIBLE_SEQ_ALLOWED == STD_ON)
        .Interruptible = TRUE,
#endif
    },
    /* Sequence Configuration for SpiSequence_ID: 3 */
    {
        .NumJobs = 1U,
        .SeqEndNotification = NULL_PTR,
        .JobIndexListPtr = Spi_Sequence_3_JobAssignment,
#if (SPI_INTERRUPTIBLE_SEQ_ALLOWED == STD_ON)
        .Interruptible = TRUE,
#endif
    },
    /* Sequence Configuration for SpiSequence_ID: 4 */
    {
        .NumJobs = 1U,
        .SeqEndNotification = NULL_PTR,
        .JobIndexListPtr = Spi_Sequence_4_JobAssignment,
#if (SPI_INTERRUPTIBLE_SEQ_ALLOWED == STD_ON)
        .Interruptible = TRUE,
#endif
    },
    /* Sequence Configuration for SpiSequence_ID: 5 */
    {
        .NumJobs = 1U,
        .SeqEndNotification = NULL_PTR,
        .JobIndexListPtr = Spi_Sequence_5_JobAssignment,
#if (SPI_INTERRUPTIBLE_SEQ_ALLOWED == STD_ON)
        .Interruptible = TRUE,
#endif
    },
};

/* Configuration of External device unit */
SPI_CONST static const Spi_ExternalDeviceConfigType  Spi_ExternalDeviceConfigs[6] =
{
    
    /*External Device 0 at SPI_1, configuration*/
    {
        .Instance = (uint8)SPI_1,
#if (SPI_SLAVE_SUPPORT == STD_ON)
        .SlaveMode = FALSE,
#endif
        .WhichPcs = SPI_PCS1,
        .DualEn = FALSE,
        .SamplePoint = 0U,
        .PinConfig = 0U,
        .PcsPolarity = SPI_ACTIVE_LOW,
        .BaudRate = 1000000,
        .TimeClkToCs = 0U,
        .TimeCsToClk = 0U,
        .TimeCsToCs = 0U,
        .ClkPolarity = SPI_SCK_IDLE_LOW,
        .ClkPhase = SPI_DATA_SHIFT_TRAILING,
        .SrcClk = 24000000U,
        .IsSync = TRUE,
        .IsPcsContinuous = TRUE,
#if ((SPI_LEVEL_DELIVERED == LEVEL1) || (SPI_LEVEL_DELIVERED == LEVEL2))
#if (SPI_DMA_USED == STD_ON)
        .UseDma = FALSE,
#endif /* SPI_DMA_USED == STD_ON*/
#endif /* (SPI_LEVEL_DELIVERED == LEVEL1) || (SPI_LEVEL_DELIVERED == LEVEL2)*/
    },
    
    /*External Device 1 at SPI_1, configuration*/
    {
        .Instance = (uint8)SPI_1,
#if (SPI_SLAVE_SUPPORT == STD_ON)
        .SlaveMode = FALSE,
#endif
        .WhichPcs = SPI_PCS3,
        .DualEn = FALSE,
        .SamplePoint = 0U,
        .PinConfig = 0U,
        .PcsPolarity = SPI_ACTIVE_LOW,
        .BaudRate = 1000000,
        .TimeClkToCs = 0U,
        .TimeCsToClk = 0U,
        .TimeCsToCs = 0U,
        .ClkPolarity = SPI_SCK_IDLE_LOW,
        .ClkPhase = SPI_DATA_SHIFT_TRAILING,
        .SrcClk = 24000000U,
        .IsSync = TRUE,
        .IsPcsContinuous = TRUE,
#if ((SPI_LEVEL_DELIVERED == LEVEL1) || (SPI_LEVEL_DELIVERED == LEVEL2))
#if (SPI_DMA_USED == STD_ON)
        .UseDma = FALSE,
#endif /* SPI_DMA_USED == STD_ON*/
#endif /* (SPI_LEVEL_DELIVERED == LEVEL1) || (SPI_LEVEL_DELIVERED == LEVEL2)*/
    },
    
    /*External Device 2 at SPI_5, configuration*/
    {
        .Instance = (uint8)SPI_5,
#if (SPI_SLAVE_SUPPORT == STD_ON)
        .SlaveMode = FALSE,
#endif
        .WhichPcs = SPI_PCS2,
        .DualEn = FALSE,
        .SamplePoint = 0U,
        .PinConfig = 0U,
        .PcsPolarity = SPI_ACTIVE_LOW,
        .BaudRate = 1000000,
        .TimeClkToCs = 0U,
        .TimeCsToClk = 0U,
        .TimeCsToCs = 0U,
        .ClkPolarity = SPI_SCK_IDLE_LOW,
        .ClkPhase = SPI_DATA_SHIFT_TRAILING,
        .SrcClk = 24000000U,
        .IsSync = TRUE,
        .IsPcsContinuous = TRUE,
#if ((SPI_LEVEL_DELIVERED == LEVEL1) || (SPI_LEVEL_DELIVERED == LEVEL2))
#if (SPI_DMA_USED == STD_ON)
        .UseDma = FALSE,
#endif /* SPI_DMA_USED == STD_ON*/
#endif /* (SPI_LEVEL_DELIVERED == LEVEL1) || (SPI_LEVEL_DELIVERED == LEVEL2)*/
    },
    
    /*External Device 3 at SPI_5, configuration*/
    {
        .Instance = (uint8)SPI_5,
#if (SPI_SLAVE_SUPPORT == STD_ON)
        .SlaveMode = FALSE,
#endif
        .WhichPcs = SPI_PCS3,
        .DualEn = FALSE,
        .SamplePoint = 0U,
        .PinConfig = 0U,
        .PcsPolarity = SPI_ACTIVE_LOW,
        .BaudRate = 1000000,
        .TimeClkToCs = 0U,
        .TimeCsToClk = 0U,
        .TimeCsToCs = 0U,
        .ClkPolarity = SPI_SCK_IDLE_LOW,
        .ClkPhase = SPI_DATA_SHIFT_TRAILING,
        .SrcClk = 24000000U,
        .IsSync = TRUE,
        .IsPcsContinuous = TRUE,
#if ((SPI_LEVEL_DELIVERED == LEVEL1) || (SPI_LEVEL_DELIVERED == LEVEL2))
#if (SPI_DMA_USED == STD_ON)
        .UseDma = FALSE,
#endif /* SPI_DMA_USED == STD_ON*/
#endif /* (SPI_LEVEL_DELIVERED == LEVEL1) || (SPI_LEVEL_DELIVERED == LEVEL2)*/
    },
    
    /*External Device 4 at SPI_0, configuration*/
    {
        .Instance = (uint8)SPI_0,
#if (SPI_SLAVE_SUPPORT == STD_ON)
        .SlaveMode = FALSE,
#endif
        .WhichPcs = SPI_PCS3,
        .DualEn = FALSE,
        .SamplePoint = 0U,
        .PinConfig = 0U,
        .PcsPolarity = SPI_ACTIVE_LOW,
        .BaudRate = 1000000,
        .TimeClkToCs = 0U,
        .TimeCsToClk = 0U,
        .TimeCsToCs = 0U,
        .ClkPolarity = SPI_SCK_IDLE_LOW,
        .ClkPhase = SPI_DATA_SHIFT_LEADING,
        .SrcClk = 24000000U,
        .IsSync = TRUE,
        .IsPcsContinuous = TRUE,
#if ((SPI_LEVEL_DELIVERED == LEVEL1) || (SPI_LEVEL_DELIVERED == LEVEL2))
#if (SPI_DMA_USED == STD_ON)
        .UseDma = FALSE,
#endif /* SPI_DMA_USED == STD_ON*/
#endif /* (SPI_LEVEL_DELIVERED == LEVEL1) || (SPI_LEVEL_DELIVERED == LEVEL2)*/
    },
    
    /*External Device 5 at SPI_2, configuration*/
    {
        .Instance = (uint8)SPI_2,
#if (SPI_SLAVE_SUPPORT == STD_ON)
        .SlaveMode = FALSE,
#endif
        .WhichPcs = SPI_PCS0,
        .DualEn = FALSE,
        .SamplePoint = 0U,
        .PinConfig = 0U,
        .PcsPolarity = SPI_ACTIVE_LOW,
        .BaudRate = 1000000,
        .TimeClkToCs = 0U,
        .TimeCsToClk = 0U,
        .TimeCsToCs = 0U,
        .ClkPolarity = SPI_SCK_IDLE_LOW,
        .ClkPhase = SPI_DATA_SHIFT_LEADING,
        .SrcClk = 24000000U,
        .IsSync = TRUE,
        .IsPcsContinuous = TRUE,
#if ((SPI_LEVEL_DELIVERED == LEVEL1) || (SPI_LEVEL_DELIVERED == LEVEL2))
#if (SPI_DMA_USED == STD_ON)
        .UseDma = FALSE,
#endif /* SPI_DMA_USED == STD_ON*/
#endif /* (SPI_LEVEL_DELIVERED == LEVEL1) || (SPI_LEVEL_DELIVERED == LEVEL2)*/
    },
};

/* Spi Configuration */
SPI_CONST const Spi_ConfigType Spi_Config =
{
    .ChannelConfigPtr = Spi_ChannelConfigs, /* ChannelConfig */
    .JobConfigPtr = Spi_JobConfigs, /* JobConfig */
    .SequenceConfigPtr = Spi_SequenceConfigs, /* SequenceConfig */
    .ExternalDeviceConfigPtr = Spi_ExternalDeviceConfigs, /* ExternalDeviceConfig */

    .MaxJob = 6U, /* SpiMaxJob - number of jobs */
    .MaxChannel = 4U, /* SpiMaxChannel - number of channels */
    .MaxSequence = 6U, /* SpiMaxSequence - number of sequences */
    .MaxHWUnitUsed = 6U, /* MaxExternalDevice - number of external devices */
#if (SPI_ENABLE_DEM_REPORT_ERROR_STATUS == STD_ON)
    .SpiErrorHardwareCfg.Id = 0, /* SPI_E_HARDWARE_ERROR parameters ID of DEM error */
    .SpiErrorHardwareCfg.State = STD_OFF, /* SPI_E_HARDWARE_ERROR parameters enabling the DEM error */
#endif
};

#define SPI_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "Spi_MemMap.h"
