/*
 *  Copyright 2020-2024 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file Pwm_PBcfg.h
 * @brief 
 * 
 */


#ifndef PWM_PB_CFG_H
#define PWM_PB_CFG_H

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
 *                                        INCLUDE FILES
==================================================================================================*/
#include "Pwm_Types.h"

/*==================================================================================================
 *                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define PWM_VENDOR_ID_PBCFG               (180)
#define PWM_AR_REL_MAJOR_VER_PBCFG        (4)
#define PWM_AR_REL_MINOR_VER_PBCFG        (4)
#define PWM_AR_REL_REVISION_VER_PBCFG     (0)
#define PWM_SW_MAJOR_VER_PBCFG            (2)
#define PWM_SW_MINOR_VER_PBCFG            (0)
#define PWM_SW_PATCH_VER_PBCFG            (0)

/*==================================================================================================
 *                                       DEFINES AND MACROS
==================================================================================================*/
/**
 * @brief    Total number of configured PWM channels
 */
#define PWM_PBCFG_CHANNELS_COUNT    (6U)

/**
 * @brief    Total number of configured PWM instances
 */
#define PWM_PBCFG_INSTANCES_COUNT   (5U)

/*==================================================================================================
 *                                  GLOBAL CONSTANT DECLARATIONS
==================================================================================================*/
#define PWM_CONFIG_PB \
    extern const Pwm_ConfigType Pwm_Config;

/*==================================================================================================
 *                                   FUNCTION PROTOTYPES
==================================================================================================*/

#ifdef __cplusplus
}
#endif

#endif /* PWM_PB_CFG_H */

/** @} */
