/*
 *  Copyright 2020-2024 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file Pwm_Lld_Etmr_PBcfg.h
 * @brief 
 * 
 */


#ifndef PWM_LLD_ETMR_PBCFG_H
#define PWM_LLD_ETMR_PBCFG_H

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
 *                                        INCLUDE FILES
==================================================================================================*/
#include "Pwm_Lld_Etmr_Types.h"

/*==================================================================================================
 *                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define PWM_LLD_ETMR_VENDOR_ID_PBCFG            (180)
#define PWM_LLD_ETMR_AR_REL_MAJOR_VER_PBCFG     (4)
#define PWM_LLD_ETMR_AR_REL_MINOR_VER_PBCFG     (4)
#define PWM_LLD_ETMR_AR_REL_REVISION_VER_PBCFG  (0)
#define PWM_LLD_ETMR_SW_MAJOR_VER_PBCFG         (2)
#define PWM_LLD_ETMR_SW_MINOR_VER_PBCFG         (0)
#define PWM_LLD_ETMR_SW_PATCH_VER_PBCFG         (0)

/*==================================================================================================
 *                                       DEFINES AND MACROS                                       
==================================================================================================*/

/* eTMR instance index for instance configuration PwmEtmr_0 */
/* Channel configuration PwmEtmrCh_7 */
#define PWM_LLD_ETMR_INST_ID_ETMR_0_CH_7  (0U)

/* eTMR instance index for instance configuration PwmEtmr_1 */
/* Channel configuration PwmEtmrCh_7 */
#define PWM_LLD_ETMR_INST_ID_ETMR_1_CH_7  (1U)

/* eTMR instance index for instance configuration PwmEtmr_2 */
/* Channel configuration PwmEtmrCh_6 */
#define PWM_LLD_ETMR_INST_ID_ETMR_2_CH_6  (2U)

/* eTMR instance index for instance configuration PwmEtmr_3 */
/* Channel configuration PwmEtmrCh_0 */
#define PWM_LLD_ETMR_INST_ID_ETMR_3_CH_0  (3U)

/* eTMR instance index for instance configuration PwmEtmr_5 */
/* Channel configuration PwmEtmrCh_0 */
#define PWM_LLD_ETMR_INST_ID_ETMR_5_CH_0  (5U)
/* Channel configuration PwmEtmrCh_1 */
#define PWM_LLD_ETMR_INST_ID_ETMR_5_CH_1  (5U)

/*==================================================================================================
 *                                  GLOBAL CONSTANTS DECLARATIONS                                  
==================================================================================================*/
#define PWM_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "Pwm_MemMap.h"

/*================================================================================================*/
/* User configuration structure PwmEtmr_0 */
PWM_CONST extern const Pwm_Lld_Etmr_CfgType Pwm_Lld_Etmr_Cfg_Inst0;
/* Instance configuration structure PwmEtmr_0 */
PWM_CONST extern const Pwm_Lld_Etmr_InstCfgType Pwm_Lld_Etmr_InstCfg_Inst0;
/* Channel configuration PwmEtmrCh_7 */
PWM_CONST extern const Pwm_Lld_Etmr_ChCfgType Pwm_Lld_Etmr_ChCfg_Inst0_Ch7;

/*================================================================================================*/
/* User configuration structure PwmEtmr_1 */
PWM_CONST extern const Pwm_Lld_Etmr_CfgType Pwm_Lld_Etmr_Cfg_Inst1;
/* Instance configuration structure PwmEtmr_1 */
PWM_CONST extern const Pwm_Lld_Etmr_InstCfgType Pwm_Lld_Etmr_InstCfg_Inst1;
/* Channel configuration PwmEtmrCh_7 */
PWM_CONST extern const Pwm_Lld_Etmr_ChCfgType Pwm_Lld_Etmr_ChCfg_Inst1_Ch7;

/*================================================================================================*/
/* User configuration structure PwmEtmr_2 */
PWM_CONST extern const Pwm_Lld_Etmr_CfgType Pwm_Lld_Etmr_Cfg_Inst2;
/* Instance configuration structure PwmEtmr_2 */
PWM_CONST extern const Pwm_Lld_Etmr_InstCfgType Pwm_Lld_Etmr_InstCfg_Inst2;
/* Channel configuration PwmEtmrCh_6 */
PWM_CONST extern const Pwm_Lld_Etmr_ChCfgType Pwm_Lld_Etmr_ChCfg_Inst2_Ch6;

/*================================================================================================*/
/* User configuration structure PwmEtmr_3 */
PWM_CONST extern const Pwm_Lld_Etmr_CfgType Pwm_Lld_Etmr_Cfg_Inst3;
/* Instance configuration structure PwmEtmr_3 */
PWM_CONST extern const Pwm_Lld_Etmr_InstCfgType Pwm_Lld_Etmr_InstCfg_Inst3;
/* Channel configuration PwmEtmrCh_0 */
PWM_CONST extern const Pwm_Lld_Etmr_ChCfgType Pwm_Lld_Etmr_ChCfg_Inst3_Ch0;

/*================================================================================================*/
/* User configuration structure PwmEtmr_5 */
PWM_CONST extern const Pwm_Lld_Etmr_CfgType Pwm_Lld_Etmr_Cfg_Inst5;
/* Instance configuration structure PwmEtmr_5 */
PWM_CONST extern const Pwm_Lld_Etmr_InstCfgType Pwm_Lld_Etmr_InstCfg_Inst5;
/* Channel configuration PwmEtmrCh_0 */
PWM_CONST extern const Pwm_Lld_Etmr_ChCfgType Pwm_Lld_Etmr_ChCfg_Inst5_Ch0;
/* Channel configuration PwmEtmrCh_1 */
PWM_CONST extern const Pwm_Lld_Etmr_ChCfgType Pwm_Lld_Etmr_ChCfg_Inst5_Ch1;

#define PWM_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "Pwm_MemMap.h"

/*==================================================================================================
 *                                      FUNCTION PROTOTYPES
==================================================================================================*/
#ifdef __cplusplus
}
#endif

#endif /* PWM_LLD_ETMR_PBCFG_H */

/** @} */
