/*
 *  Copyright 2020-2024 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file Pwm_Lld_Etmr_PBcfg.c
 * @brief 
 * 
 */


#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
 *                                        INCLUDE FILES
==================================================================================================*/
#include "Pwm_Lld_Etmr_PBcfg.h"

/*==================================================================================================
 *                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define PWM_LLD_ETMR_VENDOR_ID_PBCFG_C              (180)
#define PWM_LLD_ETMR_AR_REL_MAJOR_VER_PBCFG_C       (4)
#define PWM_LLD_ETMR_AR_REL_MINOR_VER_PBCFG_C       (4)
#define PWM_LLD_ETMR_AR_REL_REVISION_VER_PBCFG_C    (0)
#define PWM_LLD_ETMR_SW_MAJOR_VER_PBCFG_C           (2)
#define PWM_LLD_ETMR_SW_MINOR_VER_PBCFG_C           (0)
#define PWM_LLD_ETMR_SW_PATCH_VER_PBCFG_C           (0)

/*==================================================================================================
 *                                         GLOBAL CONSTANTS                                         
==================================================================================================*/
#define PWM_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "Pwm_MemMap.h"
                                                

/*================================================================================================*/
/* Instance configuration structure PwmEtmr_0 */
PWM_CONST const Pwm_Lld_Etmr_InstCfgType Pwm_Lld_Etmr_InstCfg_Inst0 = 
{
    .Period = 10000U,
    .DebugModeEnable = TRUE,
    .ClockPrescaler = 11U,
    .ClockSource = PWM_LLD_ETMR_CLKSRC_BUS,
    .OvfIrqEn = FALSE,
    .OvfCallback = NULL_PTR
};

/* Channel configuration PwmEtmrCh_7 */
PWM_CONST const Pwm_Lld_Etmr_ChCfgType Pwm_Lld_Etmr_ChCfg_Inst0_Ch7 = 
{
    .ChannelId = 7U,
    .DutyCycle = 16384U,
    .DeadTime = 0U,
    .AlignMode = PWM_LLD_ETMR_ALIGN_MODE_CENTER,
    .Polarity = PWM_LLD_ETMR_POLARITY_NOT_INVERT,
    .IdleState = PWM_LLD_ETMR_OUTPUT_STATE_LOW,
    .ChMode = PWM_LLD_ETMR_MODE_INDEPENDENT
};

PWM_CONST static const Pwm_Lld_Etmr_ChCfgType * const Pwm_Lld_Etmr_ChCfgArr_Inst0[1U] = 
{
    &Pwm_Lld_Etmr_ChCfg_Inst0_Ch7,
};

/* User configuration structure PwmEtmr_0 */
PWM_CONST const Pwm_Lld_Etmr_CfgType Pwm_Lld_Etmr_Cfg_Inst0 = 
{
    .ChannelCount = 1U,
    .InstCfg = &Pwm_Lld_Etmr_InstCfg_Inst0,
    .ChCfgArr = Pwm_Lld_Etmr_ChCfgArr_Inst0
};

/*================================================================================================*/
/* Instance configuration structure PwmEtmr_1 */
PWM_CONST const Pwm_Lld_Etmr_InstCfgType Pwm_Lld_Etmr_InstCfg_Inst1 = 
{
    .Period = 5000U,
    .DebugModeEnable = TRUE,
    .ClockPrescaler = 119U,
    .ClockSource = PWM_LLD_ETMR_CLKSRC_BUS,
    .OvfIrqEn = FALSE,
    .OvfCallback = NULL_PTR
};

/* Channel configuration PwmEtmrCh_7 */
PWM_CONST const Pwm_Lld_Etmr_ChCfgType Pwm_Lld_Etmr_ChCfg_Inst1_Ch7 = 
{
    .ChannelId = 7U,
    .DutyCycle = 8192U,
    .DeadTime = 0U,
    .AlignMode = PWM_LLD_ETMR_ALIGN_MODE_CENTER,
    .Polarity = PWM_LLD_ETMR_POLARITY_NOT_INVERT,
    .IdleState = PWM_LLD_ETMR_OUTPUT_STATE_LOW,
    .ChMode = PWM_LLD_ETMR_MODE_INDEPENDENT
};

PWM_CONST static const Pwm_Lld_Etmr_ChCfgType * const Pwm_Lld_Etmr_ChCfgArr_Inst1[1U] = 
{
    &Pwm_Lld_Etmr_ChCfg_Inst1_Ch7,
};

/* User configuration structure PwmEtmr_1 */
PWM_CONST const Pwm_Lld_Etmr_CfgType Pwm_Lld_Etmr_Cfg_Inst1 = 
{
    .ChannelCount = 1U,
    .InstCfg = &Pwm_Lld_Etmr_InstCfg_Inst1,
    .ChCfgArr = Pwm_Lld_Etmr_ChCfgArr_Inst1
};

/*================================================================================================*/
/* Instance configuration structure PwmEtmr_2 */
PWM_CONST const Pwm_Lld_Etmr_InstCfgType Pwm_Lld_Etmr_InstCfg_Inst2 = 
{
    .Period = 5000U,
    .DebugModeEnable = TRUE,
    .ClockPrescaler = 119U,
    .ClockSource = PWM_LLD_ETMR_CLKSRC_BUS,
    .OvfIrqEn = FALSE,
    .OvfCallback = NULL_PTR
};

/* Channel configuration PwmEtmrCh_6 */
PWM_CONST const Pwm_Lld_Etmr_ChCfgType Pwm_Lld_Etmr_ChCfg_Inst2_Ch6 = 
{
    .ChannelId = 6U,
    .DutyCycle = 16384U,
    .DeadTime = 0U,
    .AlignMode = PWM_LLD_ETMR_ALIGN_MODE_CENTER,
    .Polarity = PWM_LLD_ETMR_POLARITY_NOT_INVERT,
    .IdleState = PWM_LLD_ETMR_OUTPUT_STATE_LOW,
    .ChMode = PWM_LLD_ETMR_MODE_INDEPENDENT
};

PWM_CONST static const Pwm_Lld_Etmr_ChCfgType * const Pwm_Lld_Etmr_ChCfgArr_Inst2[1U] = 
{
    &Pwm_Lld_Etmr_ChCfg_Inst2_Ch6,
};

/* User configuration structure PwmEtmr_2 */
PWM_CONST const Pwm_Lld_Etmr_CfgType Pwm_Lld_Etmr_Cfg_Inst2 = 
{
    .ChannelCount = 1U,
    .InstCfg = &Pwm_Lld_Etmr_InstCfg_Inst2,
    .ChCfgArr = Pwm_Lld_Etmr_ChCfgArr_Inst2
};

/*================================================================================================*/
/* Instance configuration structure PwmEtmr_3 */
PWM_CONST const Pwm_Lld_Etmr_InstCfgType Pwm_Lld_Etmr_InstCfg_Inst3 = 
{
    .Period = 120000U,
    .DebugModeEnable = TRUE,
    .ClockPrescaler = 0U,
    .ClockSource = PWM_LLD_ETMR_CLKSRC_BUS,
    .OvfIrqEn = FALSE,
    .OvfCallback = NULL_PTR
};

/* Channel configuration PwmEtmrCh_0 */
PWM_CONST const Pwm_Lld_Etmr_ChCfgType Pwm_Lld_Etmr_ChCfg_Inst3_Ch0 = 
{
    .ChannelId = 0U,
    .DutyCycle = 16384U,
    .DeadTime = 0U,
    .AlignMode = PWM_LLD_ETMR_ALIGN_MODE_CENTER,
    .Polarity = PWM_LLD_ETMR_POLARITY_NOT_INVERT,
    .IdleState = PWM_LLD_ETMR_OUTPUT_STATE_LOW,
    .ChMode = PWM_LLD_ETMR_MODE_INDEPENDENT
};

PWM_CONST static const Pwm_Lld_Etmr_ChCfgType * const Pwm_Lld_Etmr_ChCfgArr_Inst3[1U] = 
{
    &Pwm_Lld_Etmr_ChCfg_Inst3_Ch0,
};

/* User configuration structure PwmEtmr_3 */
PWM_CONST const Pwm_Lld_Etmr_CfgType Pwm_Lld_Etmr_Cfg_Inst3 = 
{
    .ChannelCount = 1U,
    .InstCfg = &Pwm_Lld_Etmr_InstCfg_Inst3,
    .ChCfgArr = Pwm_Lld_Etmr_ChCfgArr_Inst3
};


/*================================================================================================*/
/* Instance configuration structure PwmEtmr_5 */
PWM_CONST const Pwm_Lld_Etmr_InstCfgType Pwm_Lld_Etmr_InstCfg_Inst5 = 
{
    .Period = 10000U,
    .DebugModeEnable = TRUE,
    .ClockPrescaler = 11U,
    .ClockSource = PWM_LLD_ETMR_CLKSRC_BUS,
    .OvfIrqEn = FALSE,
    .OvfCallback = NULL_PTR
};

/* Channel configuration PwmEtmrCh_0 */
PWM_CONST const Pwm_Lld_Etmr_ChCfgType Pwm_Lld_Etmr_ChCfg_Inst5_Ch0 = 
{
    .ChannelId = 0U,
    .DutyCycle = 16384U,
    .DeadTime = 0U,
    .AlignMode = PWM_LLD_ETMR_ALIGN_MODE_CENTER,
    .Polarity = PWM_LLD_ETMR_POLARITY_NOT_INVERT,
    .IdleState = PWM_LLD_ETMR_OUTPUT_STATE_LOW,
    .ChMode = PWM_LLD_ETMR_MODE_INDEPENDENT
};
/* Channel configuration PwmEtmrCh_1 */
PWM_CONST const Pwm_Lld_Etmr_ChCfgType Pwm_Lld_Etmr_ChCfg_Inst5_Ch1 = 
{
    .ChannelId = 1U,
    .DutyCycle = 16384U,
    .DeadTime = 0U,
    .AlignMode = PWM_LLD_ETMR_ALIGN_MODE_CENTER,
    .Polarity = PWM_LLD_ETMR_POLARITY_NOT_INVERT,
    .IdleState = PWM_LLD_ETMR_OUTPUT_STATE_LOW,
    .ChMode = PWM_LLD_ETMR_MODE_INDEPENDENT
};

PWM_CONST static const Pwm_Lld_Etmr_ChCfgType * const Pwm_Lld_Etmr_ChCfgArr_Inst5[2U] = 
{
    &Pwm_Lld_Etmr_ChCfg_Inst5_Ch0,
    &Pwm_Lld_Etmr_ChCfg_Inst5_Ch1,
};

/* User configuration structure PwmEtmr_5 */
PWM_CONST const Pwm_Lld_Etmr_CfgType Pwm_Lld_Etmr_Cfg_Inst5 = 
{
    .ChannelCount = 2U,
    .InstCfg = &Pwm_Lld_Etmr_InstCfg_Inst5,
    .ChCfgArr = Pwm_Lld_Etmr_ChCfgArr_Inst5
};

#define PWM_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "Pwm_MemMap.h"

#ifdef __cplusplus
}
#endif

/** @} */
