/*
 *  Copyright 2020-2024 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file undefined
 * @brief 
 * 
 */


#ifndef PWM_LLD_ETMR_CFG_H
#define PWM_LLD_ETMR_CFG_H

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
 *                                          INCLUDE FILES                                        
==================================================================================================*/
#include "Std_Types.h"

/*==================================================================================================
 *                                SOURCE FILE VERSION INFORMATION                                
==================================================================================================*/
#define PWM_LLD_ETMR_VENDOR_ID_CFG              (180)
#define PWM_LLD_ETMR_AR_REL_MAJOR_VER_CFG       (4)
#define PWM_LLD_ETMR_AR_REL_MINOR_VER_CFG       (4)
#define PWM_LLD_ETMR_AR_REL_REVISION_VER_CFG    (0)
#define PWM_LLD_ETMR_SW_MAJOR_VER_CFG           (2)
#define PWM_LLD_ETMR_SW_MINOR_VER_CFG           (0)
#define PWM_LLD_ETMR_SW_PATCH_VER_CFG           (0)

/*==================================================================================================
 *                                       DEFINES AND MACROS                                       
==================================================================================================*/
/**
 * @brief   Switch to enable the development error detection.
 */
#define PWM_LLD_ETMR_DEV_ERROR_DETECT   (STD_OFF)

/**
 * @brief   eTMR timeout count
 */
#define PWM_LLD_ETMR_TIMEOUT_COUNT      (65535U)

#ifdef __cplusplus
}
#endif

#endif /* PWM_LLD_ETMR_CFG_H */
