/*
 *  Copyright 2020-2024 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file Port_Cfg.h
 * @brief 
 * 
 */


#ifndef PORT_CFG_H
#define PORT_CFG_H

#ifdef __cplusplus
extern "C"{
#endif


/*==================================================================================================
 *                                        INCLUDE FILES
==================================================================================================*/
#include "Std_Types.h"

/*==================================================================================================
 *                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define PORT_VENDOR_ID_CFG               (180)
#define PORT_AR_REL_MAJOR_VER_CFG        (4)
#define PORT_AR_REL_MINOR_VER_CFG        (4)
#define PORT_AR_REL_REVISION_VER_CFG     (0)
#define PORT_SW_MAJOR_VER_CFG            (2)
#define PORT_SW_MINOR_VER_CFG            (0)
#define PORT_SW_PATCH_VER_CFG            (0)

/*==================================================================================================
 *                                     FILE VERSION CHECKS
==================================================================================================*/

/*==================================================================================================
 *                          LOCAL TYPEDEFS (STRUCTURES, UNIONS, ENUMS)
==================================================================================================*/


/*==================================================================================================
 *                                       LOCAL MACROS
==================================================================================================*/
// PortGeneral
/**
 * @brief Switches the development error detection and notification on or off.
 * @note Trace: ECUC_Port_00123
 *       range: STD_ON, STD_OFF
 */
#define PORT_DEV_ERROR_DETECT                       (STD_ON)

/**
 * @brief Pre-processor switch to enable / disable the use of the function Port_SetPinDirection().
 * @note Trace: ECUC_Port_00131
 *       range: STD_ON, STD_OFF
 */
#define PORT_SET_PIN_DIRECTION_API                   (STD_ON)

/**
 * @brief Pre-processor switch to enable / disable the use of the function Port_SetPinMode().
 * @note Trace: ECUC_Port_00132
 *       range: STD_ON, STD_OFF
 */
#define PORT_SET_PIN_MODE_API                        (STD_ON)

/**
 * @brief Pre-processor switch to enable / disable the API to read out the modules version information.
 * @note Trace: ECUC_Port_00133
 *       range: STD_ON, STD_OFF
 */
#define PORT_VERSION_INFO_API                       (STD_ON)
/**
 * @brief Pre-processor switch to use or not use the post-build config
 * @note range: STD_ON, STD_OFF      
 */
#define PORT_FIXED_PB_CONFIG (STD_OFF)



#ifdef PORT_ENABLE_USER_MODE_SUPPORT
#ifndef MCAL_ENABLE_USER_MODE_SUPPORT
#error "Must define MCAL_ENABLE_USER_MODE_SUPPORT if PORT_ENABLE_USER_MODE_SUPPORT is defined"
#endif
#endif

/**
* @brief Support for SchM: sync/atomic operations, global interrupt disable/enable.
*        If this parameter has been configured to 'STD_ON', the MCAL driver code supports sync/atomic operations for key resource protection.
*        If it is enabled, all the SchM codes in MCAL Port driver codes will work and support sync/atomic operation with CPU global interrupt enable/disable for key resource protection. 
*        Disable it can reduce code size, but may cause potential risks when access to some critical resource!
*/
#define PORT_SCHM_SUPPORT  (STD_ON) 

/**
* @brief Port Pin symbolic names
* @details Get All Symbolic Names from configuration tool
*
*/

#define PortConfigSet_PTOR_A_PTA7_HALL1_ADC   ((Port_PinType)(((0)<<8)|7))
#define PortConfigSet_PTOR_A_PTA6_SPI0_BUCK_CS1   ((Port_PinType)(((0)<<8)|6))
#define PortConfigSet_PTOR_A_PTA17_TPS_BOOST_EN   ((Port_PinType)(((0)<<8)|17))
#define PortConfigSet_PTOR_A_PTA3_AD_HS2   ((Port_PinType)(((0)<<8)|3))
#define PortConfigSet_PTOR_A_PTA2_AD_HS1   ((Port_PinType)(((0)<<8)|2))
#define PortConfigSet_PTOR_A_PTA1_AD_VBAT   ((Port_PinType)(((0)<<8)|1))
#define PortConfigSet_PTOR_A_PTA0_OUT_5V_AD   ((Port_PinType)(((0)<<8)|0))
#define PortConfigSet_PTOR_A_PTA16_VLDO_5V_AD   ((Port_PinType)(((0)<<8)|16))
#define PortConfigSet_PTOR_A_PTA15_MOTOR_SPI_CS2   ((Port_PinType)(((0)<<8)|15))
#define PortConfigSet_PTOR_A_PTA14_HSS2_IN1   ((Port_PinType)(((0)<<8)|14))
#define PortConfigSet_PTOR_A_PTA13_PWM_H2   ((Port_PinType)(((0)<<8)|13))
#define PortConfigSet_PTOR_A_PTA12_PWM_H1   ((Port_PinType)(((0)<<8)|12))
#define PortConfigSet_PTOR_A_PTA11_OUT_5V_EN   ((Port_PinType)(((0)<<8)|11))
#define PortConfigSet_PTOR_A_PTA9_MOTOR_SPI_CS1   ((Port_PinType)(((0)<<8)|9))
#define PortConfigSet_PTOR_A_PTA8_MOTOR_SPI_MOSI1   ((Port_PinType)(((0)<<8)|8))
#define PortConfigSet_PTOR_B_PTB5_HSSS_CLK   ((Port_PinType)(((1)<<8)|5))
#define PortConfigSet_PTOR_B_PTB4_BUCK_EN2   ((Port_PinType)(((1)<<8)|4))
#define PortConfigSet_PTOR_B_PTB3_RB_NTC_AD2   ((Port_PinType)(((1)<<8)|3))
#define PortConfigSet_PTOR_B_PTB2_RB_NTC_AD7   ((Port_PinType)(((1)<<8)|2))
#define PortConfigSet_PTOR_B_PTB1_RB_NTC_AD8   ((Port_PinType)(((1)<<8)|1))
#define PortConfigSet_PTOR_B_PTB0_RB_NTC_AD10   ((Port_PinType)(((1)<<8)|0))
#define PortConfigSet_PTOR_B_PTB17_SPI0_BOOST_CS   ((Port_PinType)(((1)<<8)|17))
#define PortConfigSet_PTOR_B_PTB16_SPI0_MOSI   ((Port_PinType)(((1)<<8)|16))
#define PortConfigSet_PTOR_B_PTB15_SPI0_MISO   ((Port_PinType)(((1)<<8)|15))
#define PortConfigSet_PTOR_B_PTB14_SPI0_SCK   ((Port_PinType)(((1)<<8)|14))
#define PortConfigSet_PTOR_B_PTB12_Board_NTC_AD   ((Port_PinType)(((1)<<8)|12))
#define PortConfigSet_PTOR_B_PTB11_HS_CS2   ((Port_PinType)(((1)<<8)|11))
#define PortConfigSet_PTOR_B_PTB10_DIA_EN2   ((Port_PinType)(((1)<<8)|10))
#define PortConfigSet_PTOR_B_PTB9_HS_CS1   ((Port_PinType)(((1)<<8)|9))
#define PortConfigSet_PTOR_B_PTB8_DIA_EN1   ((Port_PinType)(((1)<<8)|8))
#define PortConfigSet_PTOR_B_PTB13_ADC_McuLogicInput_4   ((Port_PinType)(((1)<<8)|13))
#define PortConfigSet_PTOR_C_PTC3_RB_NTC_AD3   ((Port_PinType)(((2)<<8)|3))
#define PortConfigSet_PTOR_C_PTC2_MUC_Wake   ((Port_PinType)(((2)<<8)|2))
#define PortConfigSet_PTOR_C_PTC1_RB_NTC_AD5   ((Port_PinType)(((2)<<8)|1))
#define PortConfigSet_PTOR_C_PTC0_HALL2_ADC   ((Port_PinType)(((2)<<8)|0))
#define PortConfigSet_PTOR_C_PTC17_RB_NTC_AD6   ((Port_PinType)(((2)<<8)|17))
#define PortConfigSet_PTOR_C_PTC16_RB_NTC_AD1   ((Port_PinType)(((2)<<8)|16))
#define PortConfigSet_PTOR_C_PTC15_McuLogicInput_2   ((Port_PinType)(((2)<<8)|15))
#define PortConfigSet_PTOR_C_PTC14_McuLogicInput_1   ((Port_PinType)(((2)<<8)|14))
#define PortConfigSet_PTOR_C_PTC13_BUCK_EN   ((Port_PinType)(((2)<<8)|13))
#define PortConfigSet_PTOR_C_PTC12_LSSSS_PWM3   ((Port_PinType)(((2)<<8)|12))
#define PortConfigSet_PTOR_C_PTC11_LSSSS_PWM2   ((Port_PinType)(((2)<<8)|11))
#define PortConfigSet_PTOR_C_PTC10_LSSSS_PWM1   ((Port_PinType)(((2)<<8)|10))
#define PortConfigSet_PTOR_C_PTC9_MCU_TX2   ((Port_PinType)(((2)<<8)|9))
#define PortConfigSet_PTOR_C_PTC8_MCU_RX2   ((Port_PinType)(((2)<<8)|8))
#define PortConfigSet_PTOR_C_PTC7_MCU_CAN0_TX   ((Port_PinType)(((2)<<8)|7))
#define PortConfigSet_PTOR_C_PTC6_MCU_CAN0_RX   ((Port_PinType)(((2)<<8)|6))
#define PortConfigSet_PTOR_D_PTD17_MCU_RX1   ((Port_PinType)(((3)<<8)|17))
#define PortConfigSet_PTOR_D_PTD16_CAN_EN   ((Port_PinType)(((3)<<8)|16))
#define PortConfigSet_PTOR_D_PTD15_SLP_EN   ((Port_PinType)(((3)<<8)|15))
#define PortConfigSet_PTOR_D_PTD14_SPI1_BUCK_CS3   ((Port_PinType)(((3)<<8)|14))
#define PortConfigSet_PTOR_D_PTD13_SPI1_BUCK_CS2   ((Port_PinType)(((3)<<8)|13))
#define PortConfigSet_PTOR_D_PTD7_BUCK_EN3   ((Port_PinType)(((3)<<8)|7))
#define PortConfigSet_PTOR_D_PTD6_BUCK_EN4   ((Port_PinType)(((3)<<8)|6))
#define PortConfigSet_PTOR_D_PTD5_BUCK_EN1   ((Port_PinType)(((3)<<8)|5))
#define PortConfigSet_PTOR_D_PTD12_SPI1_MISO   ((Port_PinType)(((3)<<8)|12))
#define PortConfigSet_PTOR_D_PTD11_SPI1_MOSI   ((Port_PinType)(((3)<<8)|11))
#define PortConfigSet_PTOR_D_PTD10_SPI1_SCK   ((Port_PinType)(((3)<<8)|10))
#define PortConfigSet_PTOR_D_PTD9_CV10_EN   ((Port_PinType)(((3)<<8)|9))
#define PortConfigSet_PTOR_D_PTD8_CV9_EN   ((Port_PinType)(((3)<<8)|8))
#define PortConfigSet_PTOR_D_PTD4_CV10_AD   ((Port_PinType)(((3)<<8)|4))
#define PortConfigSet_PTOR_D_PTD3_CV9_AD   ((Port_PinType)(((3)<<8)|3))
#define PortConfigSet_PTOR_D_PTD2_H_S_S_S_5_AD   ((Port_PinType)(((3)<<8)|2))
#define PortConfigSet_PTOR_E_PTE16_MOTOR_SPI_MISO1   ((Port_PinType)(((4)<<8)|16))
#define PortConfigSet_PTOR_E_PTE15_MOTOR_SPI_SCK1   ((Port_PinType)(((4)<<8)|15))
#define PortConfigSet_PTOR_E_PTE11_MCU_LIN_TX   ((Port_PinType)(((4)<<8)|11))
#define PortConfigSet_PTOR_E_PTE10_MCU_LIN_RX   ((Port_PinType)(((4)<<8)|10))
#define PortConfigSet_PTOR_E_PTE13_MOTOR_EN   ((Port_PinType)(((4)<<8)|13))
#define PortConfigSet_PTOR_E_PTE5_MCU_CAN0_TX   ((Port_PinType)(((4)<<8)|5))
#define PortConfigSet_PTOR_E_PTE4_MCU_CAN0_RX   ((Port_PinType)(((4)<<8)|4))
#define PortConfigSet_PTOR_E_PTE14_MCU_CAN_STB   ((Port_PinType)(((4)<<8)|14))
#define PortConfigSet_PTOR_E_PTE3_MCU_CAN_ERR   ((Port_PinType)(((4)<<8)|3))
#define PortConfigSet_PTOR_E_PTE12_MCU_TX1   ((Port_PinType)(((4)<<8)|12))
#define PortConfigSet_PTOR_E_PTE9_I2C_SDA   ((Port_PinType)(((4)<<8)|9))
#define PortConfigSet_PTOR_E_PTE8_I2C_SCL   ((Port_PinType)(((4)<<8)|8))
#define PortConfigSet_PTOR_E_PTE7_PWMH2   ((Port_PinType)(((4)<<8)|7))
#define PortConfigSet_PTOR_E_PTE6_DRV_OFF2   ((Port_PinType)(((4)<<8)|6))
#define PortConfigSet_PTOR_E_PTE2_MOTOR_SPI_MOSI2   ((Port_PinType)(((4)<<8)|2))
#define PortConfigSet_PTOR_E_PTE1_MOTOR_SPI_MISO2   ((Port_PinType)(((4)<<8)|1))
#define PortConfigSet_PTOR_E_PTE0_MOTOR_SPI_SCK2   ((Port_PinType)(((4)<<8)|0))

#ifdef __cplusplus
}
#endif

#endif /* PORT_CFG_H */

/** @} */