/*
 *  Copyright 2020-2024 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file Mcal.h
 * @brief 
 * 
 */



#ifndef MCAL_H
#define MCAL_H




#ifdef __cplusplus
extern "C"{
#endif

/*==================================================================================================
*                                        INCLUDE FILES
* 1) system and project includes
* 2) needed interfaces from external units
* 3) internal and external interfaces from this unit
==================================================================================================*/

#include "Compiler.h"
#include "Std_Types.h"

#include "Mcu.h"
#include "Mcu_PBcfg.h"
#include "Adc.h"
#include "Adc_PBcfg.h"
#include "Can.h"
#include "Can_PBcfg.h"
#include "Dio.h"
#include "EcuM.h"
#include "CddDma.h"
#include "CddDma_PBcfg.h"
#include "Crypto.h"
#include "Det.h"
#include "Fee.h"
#include "Fls.h"
#include "Fls_PBcfg.h"
#include "Gpt.h"
#include "Gpt_PBcfg.h"
#include "Icu.h"
#include "Icu_PBcfg.h"
#include "Lin.h"
#include "Lin_PBcfg.h"
#include "Port.h"
#include "Port_PBcfg.h"
#include "Pwm.h"
#include "Pwm_PBcfg.h"
#include "Pwm_Lld_Etmr_PBcfg.h"
#include "Spi.h"
#include "Spi_PBcfg.h"
#include "Wdg_180_Inst0.h"
#include "Wdg_180_Inst0_PBcfg.h"
#include "Wdg_180_Inst0_Mld_PBcfg.h"
#include "Wdg_Lld_PBcfg.h"
#include "Wdg.h"
#include "Wdg_180_Inst1.h"
#include "Wdg_180_Inst1_PBcfg.h"
#include "Wdg_180_Inst1_Mld_PBcfg.h"
#include "Ewdg_Lld_PBcfg.h"
#include "Platform.h"
#include "CddI2c.h"
#include "CddI2c_PBcfg.h"
#include "CddUart.h"

#ifdef MCU_CONFIG_PB
MCU_CONFIG_PB
#endif
#ifdef ADC_CONFIG_PB
ADC_CONFIG_PB
#endif
#ifdef CAN_CONFIG_PB
CAN_CONFIG_PB
#endif
#ifdef CDDDMA_CONFIG_PB
CDDDMA_CONFIG_PB
#endif
#ifdef FLS_CONFIG_PB
FLS_CONFIG_PB
#endif
#ifdef GPT_CONFIG_PB
GPT_CONFIG_PB
#endif
#ifdef ICU_CONFIG_PB
ICU_CONFIG_PB
#endif
#ifdef LIN_CONFIG_PB
LIN_CONFIG_PB
#endif
#ifdef PORT_CONFIG_PB
PORT_CONFIG_PB
#endif
#ifdef PWM_CONFIG_PB
PWM_CONFIG_PB
#endif
#ifdef PWM_LLD_ETMR_CONFIG_PB
PWM_LLD_ETMR_CONFIG_PB
#endif
#ifdef SPI_CONFIG_PB
SPI_CONFIG_PB
#endif
#ifdef WDG_180_INST0_CONFIG_PB
WDG_180_INST0_CONFIG_PB
#endif
#ifdef WDG_180_INST0_MLD_CONFIG_PB
WDG_180_INST0_MLD_CONFIG_PB
#endif
#ifdef WDG_LLD_CONFIG_PB
WDG_LLD_CONFIG_PB
#endif
#ifdef WDG_180_INST1_CONFIG_PB
WDG_180_INST1_CONFIG_PB
#endif
#ifdef WDG_180_INST1_MLD_CONFIG_PB
WDG_180_INST1_MLD_CONFIG_PB
#endif
#ifdef EWDG_LLD_CONFIG_PB
EWDG_LLD_CONFIG_PB
#endif
#ifdef CDDI2C_CONFIG_PB
CDDI2C_CONFIG_PB
#endif

/*==================================================================================================
*                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define MCAL_VENDOR_ID                    180
#define MCAL_MODULE_ID                    0
#define MCAL_AR_RELEASE_MAJOR_VERSION     4
#define MCAL_AR_RELEASE_MINOR_VERSION     4
#define MCAL_AR_RELEASE_REVISION_VERSION  0
#define MCAL_SW_MAJOR_VERSION             2
#define MCAL_SW_MINOR_VERSION             0
#define MCAL_SW_PATCH_VERSION             0


/*==================================================================================================
*                                     FILE VERSION CHECKS
==================================================================================================*/
#ifndef DISABLE_MCAL_INTERMODULE_ASR_CHECK
    /* Check if source file and Compiler.h header file are of the same Autosar version */
    #if ((MCAL_AR_RELEASE_MAJOR_VERSION != COMPILER_AR_RELEASE_MAJOR_VERSION) || \
         (MCAL_AR_RELEASE_MINOR_VERSION != COMPILER_AR_RELEASE_MINOR_VERSION))
        #error "AutoSar Version Numbers of Mcal.h and Compiler.h are different"
    #endif
#endif

#ifndef DISABLE_MCAL_INTERMODULE_ASR_CHECK
    /* Check if source file and Std_Types.h header file are of the same Autosar version */
    #if ((MCAL_AR_RELEASE_MAJOR_VERSION != STD_AR_RELEASE_MAJOR_VERSION) || \
         (MCAL_AR_RELEASE_MINOR_VERSION != STD_AR_RELEASE_MINOR_VERSION))
        #error "AutoSar Version Numbers of Mcal.h and Std_Types.h are different"
    #endif
#endif



#define __ASM __asm


#ifdef __cplusplus
}
#endif



#endif

