/*
 *  Copyright 2020-2024 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file Lin_Cfg.h
 * @brief 
 * 
 */


#ifndef LIN_CFG_H
#define LIN_CFG_H

#ifdef __cplusplus
extern "C"{
#endif

/*==================================================================================================
 *                                        INCLUDE FILES
==================================================================================================*/
#include "Std_Types.h"
#include "EcuM.h"

/*==================================================================================================
 *                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define LIN_VENDOR_ID_CFG                   (180)
#define LIN_AR_REL_MAJOR_VER_CFG            (4)
#define LIN_AR_REL_MINOR_VER_CFG            (4)
#define LIN_AR_REL_REVISION_VER_CFG         (0)
#define LIN_SW_MAJOR_VER_CFG                (2)
#define LIN_SW_MINOR_VER_CFG                (0)
#define LIN_SW_PATCH_VER_CFG                (0)

/*==================================================================================================
 *                                       LOCAL MACROS
==================================================================================================*/

/*==================================================================================================
 *                                        LinGeneral
==================================================================================================*/

/**
 * @brief       Switches the development error detection and notification on or off.
 * @details     * true: detection and notification is enabled.
                * false: detection and notification is disabled.
 * @ref         ECUC_Lin_00066
 */
#define LIN_DEV_ERROR_DETECT                        (STD_ON)
/**
 * @brief        Switches the Lin_GetVersionInfo function ON or OFF.
 * @ref          ECUC_Lin_00067
 */
#define LIN_VERSION_INFO_API                        (STD_OFF)
/**
 * @brief        Specifies the InstanceId of this module instance. If only one instance is present it shall have the Id 0.
 * @ref          ECUC_Lin_00179
 */
#define LIN_INDEX                                   (0)
/**
 * @brief        Specifies the maximum number of loops for blocking function until a timeout is raised in short term wait loops
 * @ref          ECUC_Lin_00093
 */
#define LIN_TIMEOUT_DURATION                        (1000)

/**
 * @brief        Specifies if the LIN hardware channel supports wake up functionality
 * @ref          ECUC_Lin_00182
 */
#define LIN_CHANNEL_WAKEUP_SUPPORT                  (STD_ON)

/**
 * @brief        Specifies if the LIN hardware frame timeout detection is enabled.
 * @details
 */
#define LIN_FRAME_TIMEOUT_DISABLE                  (STD_OFF)

/**
 * @brief        Specifies if the LIN hardware Dem is enabled.
 * @details
 */
#define LIN_DEM_DISABLE                            (STD_ON)

/**
 * @brief        LIN have one unified interrupt.
 * @details      This define enable when LINFlexd only have one interrupt for each channel
 */
#define LIN_HAS_UNIFIED_INTERRUPT                   (TRUE)

/**
 * @brief        Number of configured channels
 */
#define LIN_CHANNEL_USED_NUM                        (1)

/**
 * @brief        Number of Max channels of the IC
 */
#define LIN_CHANNEL_MAX_NUM                         (6)

/**
 * @brief       Max number of data bytes in one frame
 */
#define LIN_MAX_DATA_LENGTH                         (8U)


#define LIN_MASTER_API_SUPPORT                      (STD_OFF)


#define LIN_SLAVE_API_SUPPORT                       (STD_OFF)

#undef  LIN_SLAVE_API_SUPPORT
#define LIN_SLAVE_API_SUPPORT                       (STD_ON)

#define LIN_DEINIT_API_SUPPORT                      (STD_ON)

#define LIN_SCHM_SUPPORT                            (STD_OFF)

#ifdef LIN_ENABLE_USER_MODE_SUPPORT
#ifndef MCAL_ENABLE_USER_MODE_SUPPORT
#error "Must define MCAL_ENABLE_USER_MODE_SUPPORT if LIN_ENABLE_USER_MODE_SUPPORT is defined"
#endif
#endif

#define LINFLEXD_IP_3_LIN_OCCUPY

/**
* @brief            Pre-compile Support.
*/
#define LIN_FIXED_PB_CONFIG  (STD_OFF)

/*==================================================================================================
 *                                       SYMBOLIC NAME
==================================================================================================*/
#define LinConf_LinChannel_LinChannel_0 (0U)

#ifdef __cplusplus
}
#endif

#endif /* LIN_CFG_H */

/** @} */
