/*
 *  Copyright 2020-2024 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file Icu_PBcfg.c
 * @brief 
 * 
 */


#include "Icu.h"
#include "Icu_Lld_Etmr.h"
#include "Icu_Lld_Port.h"
#include "Icu_Base.h"
/*==================================================================================================
*                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define ICU_VENDOR_ID_PBCFG_C (180)
#define ICU_AR_REL_MAJOR_VER_PBCFG_C (4)
#define ICU_AR_REL_MINOR_VER_PBCFG_C (4)
#define ICU_AR_REL_REVISION_VER_PBCFG_C (0)
#define ICU_SW_MAJOR_VER_PBCFG_C (2)
#define ICU_SW_MINOR_VER_PBCFG_C (0)
#define ICU_SW_PATCH_VER_PBCFG_C (0)

/*================================================================================================== */




#define ICU_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "Icu_MemMap.h"

ICU_CONST const Icu_ChannelConfigType Icu_ChannelConfig[2] = 
{
    {
        .IcuChannelId = 0,
        .IcuHwIp = ICU_ETMR,
        .IcuHwIpInstance = ICU_ETMR5,
        
        .IcuHwChannel = 3,
        .IcuDefaultStartEdge = ICU_RISING_EDGE,
        .IcuWakeupCapability = FALSE,
        .IcuMeasurementMode = ICU_MODE_SIGNAL_MEASUREMENT,        
        .SignalMeasurementProperty = ICU_DUTY_CYCLE,
    },
    {
        .IcuChannelId = 1,
        .IcuHwIp = ICU_ETMR,
        .IcuHwIpInstance = ICU_ETMR0,
        
        .IcuHwChannel = 0,
        .IcuDefaultStartEdge = ICU_RISING_EDGE,
        .IcuWakeupCapability = FALSE,
        .IcuMeasurementMode = ICU_MODE_SIGNAL_MEASUREMENT,        
        .SignalMeasurementProperty = ICU_DUTY_CYCLE,
    },
};

 
ICU_CONST const IcuEtmrChannelType EtmrListChannels_0[1]=
{
    {         
        .ChannelNum = 3,
        },
};
ICU_CONST const IcuEtmrChannelType EtmrListChannels_1[1]=
{
    {         
        .ChannelNum = 0,
        },
};


ICU_CONST const Icu_EtmrConfigType Icu_EtmrConfig[2]=
{
    {
        .IcuEtmrModule = ICU_ETMR5,
        .IcuEtmrCount = 2,
        .IcuEtmrChannelPtr = (IcuEtmrChannelType*)EtmrListChannels_0,
        .IcuEtmrClockSource = ICU_MC_CLOCK_SOURCE_FASTBUSCLK,
        .IcuEtmrPrescaler = 11,    
        .IcuEtmrModValue = 0,
    },    
    {
        .IcuEtmrModule = ICU_ETMR0,
        .IcuEtmrCount = 2,
        .IcuEtmrChannelPtr = (IcuEtmrChannelType*)EtmrListChannels_1,
        .IcuEtmrClockSource = ICU_MC_CLOCK_SOURCE_FASTBUSCLK,
        .IcuEtmrPrescaler = 11,    
        .IcuEtmrModValue = 0,
    },    
};
/*
ICU_CONST const Icu_LptmrConfigType Icu_LptmrConfig[0]=
{

};
*/




ICU_CONST const Icu_HwInterruptConfigType Icu_HwInterruptConfig[2]=
{
    {         
        .IcuIsrHwId = ICU_ETMR_5_CH_3,
        .IcuIsrEnable = FALSE,     
    },
    {         
        .IcuIsrHwId = ICU_ETMR_0_CH_0,
        .IcuIsrEnable = FALSE,     
    },
};
ICU_CONST const Icu_ConfigType Icu_Config = {
    .ChannelConfigPtr = (Icu_ChannelConfigType*)Icu_ChannelConfig,
    .IcuEtmrConfigPtr = (Icu_EtmrConfigType*) Icu_EtmrConfig,
    .IcuLptmrConfigPtr = (Icu_LptmrConfigType*)NULL_PTR,
    .IcuPortConfigPtr = (Icu_PortConfigType*) NULL_PTR,
    .IcuLpCmpConfigPtr = (Icu_LpCmpConfigType*) NULL_PTR,
    .IcuHwInterruptConfigPtr = (Icu_HwInterruptConfigType*)Icu_HwInterruptConfig,
    .IcuChannelCount = 2,
};
#define ICU_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "Icu_MemMap.h"
