/*
 *  Copyright 2020-2024 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file Ewdg_Lld_PBcfg.h
 * @brief 
 * 
 */


#ifndef EWDG_LLD_PBCFG_H
#define EWDG_LLD_PBCFG_H

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
 *                                          INCLUDE FILES                                          
==================================================================================================*/
#include "Ewdg_Lld_Cfg.h"
#include "Ewdg_Lld_Types.h"

/*==================================================================================================
 *                                 SOURCE FILE VERSION INFORMATION                                 
==================================================================================================*/
#define EWDG_LLD_PBCFG_VENDOR_ID            (180)
#define EWDG_LLD_PBCFG_AR_REL_MAJOR_VER     (4)
#define EWDG_LLD_PBCFG_AR_REL_MINOR_VER     (4)
#define EWDG_LLD_PBCFG_AR_REL_REVISION_VER  (0)
#define EWDG_LLD_PBCFG_SW_MAJOR_VER         (2)
#define EWDG_LLD_PBCFG_SW_MINOR_VER         (0)
#define EWDG_LLD_PBCFG_SW_PATCH_VER         (0)

/*==================================================================================================
 *                                  GLOBAL CONSTANTS DECLARATIONS                                  
==================================================================================================*/
#define WDG_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "Wdg_MemMap.h"

WDG_CONST extern const Ewdg_Lld_ConfigType Ewdg_Lld_SlowModeSettings_Config;

#define WDG_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "Wdg_MemMap.h"

/*==================================================================================================
 *                                      FUNCTION PROTOTYPES
==================================================================================================*/

#ifdef __cplusplus
}
#endif

#endif /* EWDG_LLD_PBCFG_H */

/** @} */
