/*
 *  Copyright 2020-2024 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file Dio_Cfg.h
 * @brief 
 * 
 */


#ifndef DIO_CFG_H
#define DIO_CFG_H

#ifdef __cplusplus
extern "C"{
#endif

/*==================================================================================================
*                                        INCLUDE FILES
==================================================================================================*/
#include "Std_Types.h"

/*==================================================================================================
*                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define DIO_VENDOR_ID_CFG               (180)
#define DIO_AR_REL_MAJOR_VER_CFG        (4)
#define DIO_AR_REL_MINOR_VER_CFG        (4)
#define DIO_AR_REL_REVISION_VER_CFG     (0)
#define DIO_SW_MAJOR_VER_CFG            (2)
#define DIO_SW_MINOR_VER_CFG            (0)
#define DIO_SW_PATCH_VER_CFG            (0)

/*==================================================================================================
*                                     FILE VERSION CHECKS
==================================================================================================*/

/*==================================================================================================
*                          LOCAL TYPEDEFS (STRUCTURES, UNIONS, ENUMS)
==================================================================================================*/


/*==================================================================================================
*                                       LOCAL MACROS
==================================================================================================*/
/**
 * @defgroup Container_DioGeneral 
 * @brief Definitions port pin ID
*/
/** @{ */
/**
 * @brief Switches the Default Error Tracer (Det) detection and notification ON or OFF
 * @trace ECUC_Dio_00142
 * @option STD_ON, STD_OFF
 */
#define DIO_DEV_ERROR_DETECT (STD_OFF)

/** @{ */
/**
 * @brief Switches the GPIO IP Dio Development Error Detect ON or OFF
 * @trace ECUC_Dio_00142
 * @option STD_ON, STD_OFF
 */
#define GPIO_DEV_ERROR_DETECT (STD_OFF)

/**
 * @brief Adds / removes the service Dio_FlipChannel() from the code
 * @trace ECUC_Dio_00153
 * @option STD_ON, STD_OFF
 */
#define DIO_FLIP_CHANNEL_API (STD_ON)

/**
 * @brief Adds / removes the service Dio_GetVersionInfo() from the code
 * @trace ECUC_Dio_00143
 * @option STD_ON, STD_OFF
 */
#define DIO_VERSION_INFO_API (STD_OFF)

/**
 * @brief Enable / Disable the possibility to support continual Dio channel ID.
 * @option STD_ON, STD_OFF
 */
#define DIO_CHANNELID_CONTINUITY (STD_OFF)

/**
 * @brief Adds / removes the service Dio_MaskedWritePort() from the code
 * @option STD_ON, STD_OFF
 */
#define DIO_MASKED_WRITE_PORT_API (STD_ON)


#ifdef DIO_ENABLE_USER_MODE_SUPPORT
#ifndef MCAL_ENABLE_USER_MODE_SUPPORT
#error "Must define MCAL_ENABLE_USER_MODE_SUPPORT if DIO_ENABLE_USER_MODE_SUPPORT is defined"
#endif
#endif

/**
* @brief Support for SchM: sync/atomic operations, global interrupt disable/enable.
*        If this parameter has been configured to 'STD_ON', the MCAL driver code supports sync/atomic operations for key resource protection.
*        If it is enabled, all the SchM codes in MCAL Dio driver codes will work and support sync/atomic operation with CPU global interrupt enable/disable for key resource protection. 
*        Disable it can reduce code size, but may cause potential risks when access to some critical resource!
*/
#define DIO_SCHM_SUPPORT  (STD_ON) 

/**
 * @brief Enable / Disable the possibility to support multicore.
 * @option STD_ON, STD_OFF
 */
#define DIO_MULTICORE_SUPPORT (STD_OFF)

/* For YTM32B1ME0-LQFP-144 */
/**
 * @defgroup Dio_Port_Pin_Mask
 * @brief Define the hardware port pin mask of each port
 */
/** @{ */
#define DIO_PORTA_PINS_MASK (0xfe03ffffU) /* available pin of PORTA */
#define DIO_PORTB_PINS_MASK (0x3af7ffffU) /* available pin of PORTB */
#define DIO_PORTC_PINS_MASK (0xf88bffffU) /* available pin of PORTC */
#define DIO_PORTD_PINS_MASK (0x79cffffcU) /* available pin of PORTD */
#define DIO_PORTE_PINS_MASK (0x3f9ffffU)  /* available pin of PORTE */
/** @} */

/**
 * @defgroup Symbolic name for the static Dio_Port_ID
 * @brief Numeric identifier of the DIO port. 
 * @details user can use either the static Dio_Port_ID or dynamic Dio_Port_ID by the tool
 * @trace ECUC_Dio_00145, SWS_Dio_00113， SWS_Dio_00026
 */
/** @{ */
#define DioPort_PORT_A (0x00U)
#define DioPort_PORT_B (0x01U)
#define DioPort_PORT_C (0x02U)
#define DioPort_PORT_D (0x03U)
#define DioPort_PORT_E (0x04U)
/** @} */

/*==================================================================================================
*                                      LOCAL CONSTANTS
==================================================================================================*/

/*==================================================================================================
*                                      LOCAL VARIABLES
==================================================================================================*/

/*==================================================================================================
*                                      GLOBAL CONSTANTS
==================================================================================================*/
/**
 * @defgroup Symbolic name for the dynamic Dio_Port_ID
 * @brief Numeric identifier of the DIO port. 
 * @details Not all MCU ports may be used for DIO, thus there may be "gaps" in the list of all IDs. 
 *      This value will be assigned to the DIO port symbolic name (i.e. the SHORT-NAME of the DioPort 
 *      container)
 *      user can use either the static Dio_Port_ID or dynamic Dio_Port_ID by the tool
 * @trace ECUC_Dio_00145, SWS_Dio_00113， SWS_Dio_00026
 */
/** @{ */
#define DioConf_DioPort_DioPort_0 (0x0U)
#define DioConf_DioPort_DioPort_1 (0x1U)
#define DioConf_DioPort_DioPort_2 (0x2U)
#define DioConf_DioPort_DioPort_3 (0x3U)
#define DioConf_DioPort_DioPort_4 (0x4U)

/**
 * @defgroup Symbolic name for Dio_Channel_ID
 * @brief Numeric identifier of the DIO channel. 
 * @details It's generated by the tool, the value is the index of the channel in the port with the 
 *           port name.
 * @trace ECUC_Dio_00147， SWS_Dio_00026
 */
/** @{ */
#define DioConf_DioChannel_PTA14_HSS2_IN1        (((0U << 8U) + 14U))
#define DioConf_DioChannel_PTA12_DIA_EN1        (((0U << 8U) + 12U))
#define DioConf_DioChannel_PTA11_OUT_5V_EN        (((0U << 8U) + 11U))
#define DioConf_DioChannel_PTA17_TPS_BOOST_EN        (((0U << 8U) + 17U))
#define DioConf_DioChannel_PTA2_AD_HS1        (((0U << 8U) + 2U))
#define DioConf_DioChannel_PTB5_HSSS_CLK        (((1U << 8U) + 5U))
#define DioConf_DioChannel_PTB4_BUCK_EN2        (((1U << 8U) + 4U))
#define DioConf_DioChannel_PTB11_HS_CS2        (((1U << 8U) + 11U))
#define DioConf_DioChannel_PTB10_DIA_EN2        (((1U << 8U) + 10U))
#define DioConf_DioChannel_PTB9_HS_CS1        (((1U << 8U) + 9U))
#define DioConf_DioChannel_PTC2_MUC_Wake        (((2U << 8U) + 2U))
#define DioConf_DioChannel_PTC13_BUCK_EN        (((2U << 8U) + 13U))
#define DioConf_DioChannel_PTC0_RB_NTC_AD4        (((2U << 8U) + 0U))
#define DioConf_DioChannel_PTD17_LIN_SLP_EN        (((3U << 8U) + 17U))
#define DioConf_DioChannel_PTD7_BUCK_EN3        (((3U << 8U) + 7U))
#define DioConf_DioChannel_PTD6_BUCK_EN4        (((3U << 8U) + 6U))
#define DioConf_DioChannel_PTD5_BUCK_EN1        (((3U << 8U) + 5U))
#define DioConf_DioChannel_PTD9_CV10_EN        (((3U << 8U) + 9U))
#define DioConf_DioChannel_PTD8_CV9_EN        (((3U << 8U) + 8U))
#define DioConf_DioChannel_PTD16_MCU_CAN_EN        (((3U << 8U) + 16U))
#define DioConf_DioChannel_PTE16        (((4U << 8U) + 16U))
#define DioConf_DioChannel_PTE15        (((4U << 8U) + 15U))
#define DioConf_DioChannel_PTE11        (((4U << 8U) + 11U))
#define DioConf_DioChannel_PTE10        (((4U << 8U) + 10U))
#define DioConf_DioChannel_PTE13_MOTOR_EN        (((4U << 8U) + 13U))
#define DioConf_DioChannel_PTE14_MCU_CAN_STB        (((4U << 8U) + 14U))
#define DioConf_DioChannel_PTE3_MCU_CAN_ERR        (((4U << 8U) + 3U))
/** @} */

/**
 * @defgroup Symbolic name for Dio_Channel_Group_ID
 * @brief Numeric identifier of the DIO channel group. 
 * @details It's generated by the tool, the value is the index of the channel group in the port with the 
 *           port name.
 * @trace ECUC_Dio_00147， SWS_Dio_00026
 */
/** @{ */
/** @} */

#define DIO_CHANNEL_GROUP_0 0U
#define DIO_CHANNEL_GROUP_1 0U
#define DIO_CHANNEL_GROUP_2 0U
#define DIO_CHANNEL_GROUP_3 0U
#define DIO_CHANNEL_GROUP_4 0U

/**
 * @brief Define the channel group number used in the application
 *        if the group number larger than zero, enable chanel group operations APIs
 * @option actual
 */
#define DIO_CHANNEL_GROUP_NUMBER (0U  + DIO_CHANNEL_GROUP_0  + DIO_CHANNEL_GROUP_1  + DIO_CHANNEL_GROUP_2  + DIO_CHANNEL_GROUP_3  + DIO_CHANNEL_GROUP_4 )

/*==================================================================================================
*                                      GLOBAL VARIABLES
==================================================================================================*/

#ifdef __cplusplus
}
#endif

#endif /* for DIO_CFG_H */

/** @} */
