/**
*   @file    CddUart_Mld_PBCfg.h
*   @version 
*   @brief   AUTOSAR CddUart module interface
*   @details API implementation for CddUart driver cfg.
*/
/*==================================================================================================
*   Project              : YTMicro AUTOSAR 4.4.0 MCAL
*   Platform             : ARM
*   Peripheral           : uart
*   Dependencies         : none
*
*   Autosar Version      : V4.4.0
*   Autosar Revision     : ASR_REL_4_4_REV_0000
*   Autosar Conf.Variant :
*   SW Version           : V2.0.0
*   
*
*   (c) Copyright 2020-2023 Yuntu Microelectronics co.,ltd. 
*   All Rights Reserved.
==================================================================================================*/


#ifndef CDDUART_MLD_PBCFG_H
#define CDDUART_MLD_PBCFG_H

#ifdef __cplusplus
extern "C"{
#endif

/*==================================================================================================
                                         INCLUDE FILES
 1) system and project includes
 2) needed interfaces from external units
 3) internal and external interfaces from this unit
==================================================================================================*/
#include "CddUart_Mld_Types.h"
/*==================================================================================================
*                               FILE VERSION INFORMATION
==================================================================================================*/
#define CDDUART_VENDOR_ID_MLD_CFG               (180)
#define CDDUART_AR_REL_MAJOR_VER_MLD_CFG        (4)
#define CDDUART_AR_REL_MINOR_VER_MLD_CFG        (4)
#define CDDUART_AR_REL_REVISION_VER_MLD_CFG     (0)
#define CDDUART_SW_MAJOR_VER_MLD_CFG            (2)
#define CDDUART_SW_MINOR_VER_MLD_CFG            (0)
#define CDDUART_SW_PATCH_VER_MLD_CFG            (0)
/*==================================================================================================
*                                            CONSTANTS
==================================================================================================*/

/*==================================================================================================
*                                       DEFINES AND MACROS
==================================================================================================*/

/*==================================================================================================
*                                              ENUMS
==================================================================================================*/

/*==================================================================================================
*                                  STRUCTURES AND OTHER TYPEDEFS
==================================================================================================*/

/*==================================================================================================
*                                  GLOBAL VARIABLE DECLARATIONS
==================================================================================================*/

/*==================================================================================================
*                                       FUNCTION PROTOTYPES
==================================================================================================*/
extern const CddUart_Mld_HwConfigType CddUart_Mld_HwConfig_0;

#define CDDUART_LINFLEXD_1_USED

#ifdef __cplusplus
}
#endif

#endif  /* CDDUART_MLD_PBCFG_H */ 
