
#ifndef CDDUART_CFG_H
#define CDDUART_CFG_H

#ifdef __cplusplus
extern "C"{
#endif

/*==================================================================================================
*                                        INCLUDE FILES
==================================================================================================*/
#include "Std_Types.h"
#include "CddUart_Types.h"
#include "CddUart_Mld_PBCfg.h"
/*==================================================================================================
*                               FILE VERSION INFORMATION
==================================================================================================*/
#define CDDUART_VENDOR_ID_CFG               (180)
#define CDDUART_AR_REL_MAJOR_VER_CFG        (4)
#define CDDUART_AR_REL_MINOR_VER_CFG        (4)
#define CDDUART_AR_REL_REVISION_VER_CFG     (0)
#define CDDUART_SW_MAJOR_VER_CFG            (2)
#define CDDUART_SW_MINOR_VER_CFG            (0)
#define CDDUART_SW_PATCH_VER_CFG            (0)
/*==================================================================================================
                                      FILE VERSION CHECKS
==================================================================================================*/
/* Check if current file and CddUart header file are of the same Autosar version */
#if (CDDUART_VENDOR_ID_CFG != CDDUART_VENDOR_ID_MLD_CFG)
#error "CddUart_Mld_PBCfg.h and CddUart_Cfg.h have different vendor ids"
#endif

/* Check if source file and CddUart header file are of the same Autosar version */
#if ((CDDUART_AR_REL_MAJOR_VER_CFG != CDDUART_AR_REL_MAJOR_VER_MLD_CFG) || \
     (CDDUART_AR_REL_MINOR_VER_CFG != CDDUART_AR_REL_MINOR_VER_MLD_CFG) || \
     (CDDUART_AR_REL_REVISION_VER_CFG != CDDUART_AR_REL_REVISION_VER_MLD_CFG) \
    )
#error "AutoSar Version Numbers of CddUart_Mld_PBCfg.h  and CddUart_Cfg.h are different"
#endif

/* Check if source file and CddUart header file are of the same Software version */
#if ((CDDUART_SW_MAJOR_VER_CFG != CDDUART_SW_MAJOR_VER_MLD_CFG) || \
     (CDDUART_SW_MINOR_VER_CFG != CDDUART_SW_MINOR_VER_MLD_CFG) || \
     (CDDUART_SW_PATCH_VER_CFG != CDDUART_SW_PATCH_VER_MLD_CFG) \
    )
#error "Software Version Numbers of CddUart_Mld_PBCfg.h  and CddUart_Cfg.h are different"
#endif
/*==================================================================================================
 *                          LOCAL TYPEDEFS (STRUCTURES, UNIONS, ENUMS)
==================================================================================================*/
#define CDDUART_Channel_0  0U
/*==================================================================================================
*                                       DEFINITIONS AND MACROS
==================================================================================================*/
/* @brief Enables / Disables multicore support */
#define CDDUART_MULTICORE_SUPPORT          (STD_OFF) 

/* @brief Enables / Disables PreCompile support when there is a single configuration */
#define CDDUART_PRECOMPILE_SUPPORT         (STD_OFF)

/* @brief Enables / Disables DET development errors detection and reporting */
#define CDDUART_DEV_ERROR_DETECT            (STD_ON) 
/* @brief Enables / Disables Runtime errors detection and reporting */
#define CDDUART_RUNTIME_ERROR_DETECT       (STD_OFF) 
/* @brief Number of loops before returning Timeout status */
#define CDDUART_TIMEOUT_VALUE_US           (1000U)

/* @brief Switches the Uart_GetVersionInfo() API ON or OFF. Support for version info API. */
#define CDDUART_VERSION_INFO_API            (STD_ON) 

/* @brief Uart has feature DMA enable. */
#define CDDUART_HAS_DMA_ENABLED            (STD_OFF) 


#ifdef CDDUART_ENABLE_USER_MODE_SUPPORT
#ifndef MCAL_ENABLE_USER_MODE_SUPPORT
#error "Must define MCAL_ENABLE_USER_MODE_SUPPORT if CDDUART_ENABLE_USER_MODE_SUPPORT is defined"
#endif
#endif
/**
* @brief Support for SchM: sync/atomic operations, global interrupt disable/enable.
*/
#define CDDUART_SCHM_SUPPORT                (STD_ON) 
/* @brief Number of available hardware instances */
#define CDDUART_NUMBER_OF_INSTANCES             (LINFlexD_INSTANCE_COUNT)
/**
* @brief        All CoreIDs are supported by Uart driver.
*/

#define CDDUART_MAX_PARTITIONS             (1U)



/* @brief Number of Channels configured. */
#define CDDUART_CH_MAX_CONFIG              (1U)
/**
* @brief          Uart driver configuration type structure.
* @details        This is the type of the pointer to the external data
*                 Uart Channels.
*                 A pointer of such a structure is provided to the Uart driver
*                 initialization routine for configuration of the Uart hardware
*                 channel.
*
*
*
*/
/* implements     Uart_ConfigType_structure */
typedef struct
{
    uint32 PartitionCoreId;                                 /**< @brief Partition configured of the core  */
    /**
     * @brief     Hardware channel.
     * @details   Constant pointer of the constant external data
     *            structure containing the overall initialization data
     *            for all the configured Uart Channels.
     */
    const CddUart_ChannelConfigType *Configs[CDDUART_CH_MAX_CONFIG];
} CddUart_ConfigType;
extern const CddUart_ConfigType* const CddUart_PBCfgVariant[CDDUART_MAX_PARTITIONS];

#ifdef __cplusplus
}
#endif

#endif  /* CDDUART_CFG_H */