/**
*   @file    CddUart_Cfg.c
*   @version 
*   @brief   Mcu Uart configure file.
*/
/*==================================================================================================
*   Project              : YTMicro AUTOSAR 4.4.0 MCAL
*   Platform             : ARM
*   Peripheral           : uart
*   Dependencies         : none
*
*   Autosar Version      : V4.4.0
*   Autosar Revision     : ASR_REL_4_4_REV_0000
*   Autosar Conf.Variant :
*   SW Version           : V2.0.0
*   
*
*   (c) Copyright 2020-2023 Yuntu Microelectronics co.,ltd. 
*   All Rights Reserved.
==================================================================================================*/
#ifdef __cplusplus
extern "C"{
#endif

/*==================================================================================================
*                                        INCLUDE FILES
* 1) system and project includes
* 2) needed interfaces from external units
* 3) internal and external interfaces from this unit
==================================================================================================*/
#include "CddUart_Cfg.h"
/*==================================================================================================
*                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define CDDUART_VENDOR_ID_CFG_C               (180)
#define CDDUART_AR_REL_MAJOR_VER_CFG_C        (4)
#define CDDUART_AR_REL_MINOR_VER_CFG_C        (4)
#define CDDUART_AR_REL_REVISION_VER_CFG_C     (0)
#define CDDUART_SW_MAJOR_VER_CFG_C            (2)
#define CDDUART_SW_MINOR_VER_CFG_C            (0)
#define CDDUART_SW_PATCH_VER_CFG_C            (0)
/*==================================================================================================
                                 GLOBAL VARIABLE DECLARATIONS
==================================================================================================*/

/*==================================================================================================
*                          LOCAL TYPEDEFS (STRUCTURES, UNIONS, ENUMS)
==================================================================================================*/

/*==================================================================================================
*                                       LOCAL MACROS
==================================================================================================*/
#define UART_CORE_ID     ((uint32)0U)
/*==================================================================================================
*                                      LOCAL CONSTANTS
==================================================================================================*/


/*==================================================================================================
*                                      LOCAL VARIABLES
==================================================================================================*/

/*==================================================================================================
*                                      GLOBAL CONSTANTS
==================================================================================================*/
#define CDDUART_START_SEC_CONST_UNSPECIFIED
#include "CddUart_MemMap.h"
/**
* @brief          Configuration for Uart Channel 0
*/
CDDUART_VAR const CddUart_ChannelConfigType Uart_ChannelConfig_0 =
{
    CDDUART_Channel_0, /*Uart Channel Id*/
    UART_CORE_ID, /*Uart Channel Core Id*/
    120000000, /* Clock frequency */
    &CddUart_Mld_HwConfig_0  /* Uart Hardware config */
};

/**
* @brief          Configuration for Uart driver
*/
CDDUART_VAR static const CddUart_ConfigType CddUart_Config =
{
    UART_CORE_ID,
    {
        &Uart_ChannelConfig_0,  
    }
};
/**
* @brief          Uart Configuration data for Uart_pxPBcfgVariantPredefined.
*
*/
/**
* @violates @ref Uart_VS_0_PBcfg_c_REF_3 Function with external linkage is not visible.
* @violates @ref Uart_VS_0_PBcfg_c_REF_4 These functions
                 represent the API of the driver. External linkage is needed to "export" the API.
* @violates @ref Uart_VS_0_PBcfg_c_REF_5 This violation is due to exporting
                 the externally configured initialization structure used by the "<MA>_Init" function.
*/
CDDUART_VAR const CddUart_ConfigType* const CddUart_PBCfgVariant[CDDUART_MAX_PARTITIONS] =
{

    &CddUart_Config
};
#define CDDUART_STOP_SEC_CONST_UNSPECIFIED
#include "CddUart_MemMap.h"

#ifdef __cplusplus
}
#endif
