/*
 *  Copyright 2020-2024 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file Can_PBcfg.c
 * @brief 
 * 
 */


#ifdef __cplusplus
extern "C"{
#endif

/**
 * @page misra_violations MISRA-C:2012 violations
 */

/*==================================================================================================
 *                                        INCLUDE FILES
==================================================================================================*/
#include "Can.h"
#include "Can_Drv.h"

/*==================================================================================================
*                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define CAN_VENDOR_ID_PBCFG_C           (180)
#define CAN_AR_REL_MAJOR_VER_PBCFG_C    (4)
#define CAN_AR_REL_MINOR_VER_PBCFG_C    (4)
#define CAN_AR_REL_REVISION_VER_PBCFG_C (0)
#define CAN_SW_MAJOR_VER_PBCFG_C        (2)
#define CAN_SW_MINOR_VER_PBCFG_C        (0)
#define CAN_SW_PATCH_VER_PBCFG_C        (0)

/*==================================================================================================
*                                         CALLBACKS
==================================================================================================*/



#define CAN_START_SEC_CODE
#include "Can_MemMap.h"
CAN_FUNC __attribute__((weak)) boolean CanReceiveCallOut(uint8 Hrh, Can_IdType CanId, uint8 CanDataLegth, const uint8* CanSduPtr ){(void)Hrh; (void)CanId; (void)CanDataLegth; (void)CanSduPtr; return TRUE;}



#define CAN_STOP_SEC_CODE
#include "Can_MemMap.h"
/*==================================================================================================
*                                         CONSTANTS
==================================================================================================*/
#define CAN_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "Can_MemMap.h"
#if (CAN_ENHANCE_FIFO_USEAGE == STD_ON)
CAN_CONST const Can_FilterOfStdFifoType StdRxFifoFltConfig_0[8] =
{
    {
        .FilterCodeStd1 = 0x2B3U,
        .FilterCodeStd2 = 0x7FFU,
        .EnhanceRxFifoFilterFormat = CAN_FILTER_FORMAT_ACC_MASK_MODE
    },
    {
        .FilterCodeStd1 = 0x2B4U,
        .FilterCodeStd2 = 0x7FFU,
        .EnhanceRxFifoFilterFormat = CAN_FILTER_FORMAT_ACC_MASK_MODE
    },
    {
        .FilterCodeStd1 = 0x2B5U,
        .FilterCodeStd2 = 0x7FFU,
        .EnhanceRxFifoFilterFormat = CAN_FILTER_FORMAT_ACC_MASK_MODE
    },
    {
        .FilterCodeStd1 = 0x2B6U,
        .FilterCodeStd2 = 0x7FFU,
        .EnhanceRxFifoFilterFormat = CAN_FILTER_FORMAT_ACC_MASK_MODE
    },
    {
        .FilterCodeStd1 = 0x2B7U,
        .FilterCodeStd2 = 0x7FFU,
        .EnhanceRxFifoFilterFormat = CAN_FILTER_FORMAT_ACC_MASK_MODE
    },
    {
        .FilterCodeStd1 = 0x721U,
        .FilterCodeStd2 = 0x7FFU,
        .EnhanceRxFifoFilterFormat = CAN_FILTER_FORMAT_ACC_MASK_MODE
    },
    {
        .FilterCodeStd1 = 0x732U,
        .FilterCodeStd2 = 0x7FFU,
        .EnhanceRxFifoFilterFormat = CAN_FILTER_FORMAT_ACC_MASK_MODE
    },
    {
        .FilterCodeStd1 = 0x7DFU,
        .FilterCodeStd2 = 0x7FFU,
        .EnhanceRxFifoFilterFormat = CAN_FILTER_FORMAT_ACC_MASK_MODE
    },
};

CAN_CONST const Can_EnhanceRxFifoConfigType Can_EnhanceRxFifoConfig_0 =
{
    .EnhanceRxFifoWatermarkNum = 1U,
    .ExtRxFifoFilterNum = 0U,
    .StdRxFifoFilterNum = 8U,
    .ExtRxFifoFltConfigPtr = NULL_PTR,
    .StdRxFifoFltConfigPtr = StdRxFifoFltConfig_0,
};

#endif/*#if (CAN_ENHANCE_FIFO_USEAGE == STD_ON)*/
#if (CAN_LEGACY_FIFO_USEAGE == STD_ON)


#endif/*#if (CAN_LEGACY_FIFO_USEAGE == STD_ON)*/

#if (CAN_FD_USEAGE == STD_ON)
CAN_CONST const CAN_FdBdrConfigType Can_FdBdrConfig_0[1] =
{
    {
        .CanFdBaudrate      = 2000U,
        .CanFdTxBdrSwitch   = TRUE,
        .CanFdPreDiv        = 1U,
        .CanFdPropSeg       = 6U,
        .CanFdSeg1          = 2U,
        .CanFdSeg2          = 3U,
        .CanFdSyncJumpWidth = 1U,
        .CanFdTdcOffset     = 9U
    },
};	
CAN_CONST const CAN_FdBdrConfigType Can_FdBdrConfig_1[1] =
{
    {
        .CanFdBaudrate      = 2000U,
        .CanFdTxBdrSwitch   = TRUE,
        .CanFdPreDiv        = 1U,
        .CanFdPropSeg       = 6U,
        .CanFdSeg1          = 2U,
        .CanFdSeg2          = 3U,
        .CanFdSyncJumpWidth = 1U,
        .CanFdTdcOffset     = 9U
    },
};	
#endif

CAN_CONST const Can_BdrConfigType CanControllerBaudrateConfig_0[1] = 
{
    {	
        .CanBaudrateConfigID = 0U,
        .CanBaudrate         = 500U,
        .CanPreDiv           = 2U,
        .CanPropSeg          = 9U,
        .CanSeg1             = 8U,
        .CanSeg2             = 6U,
        .CanSyncJumpWidth    = 1U,
#if (CAN_FD_USEAGE == STD_ON)
        .CanFdBdrConfig = (const CAN_FdBdrConfigType *)&Can_FdBdrConfig_0[0],
#endif
    },
};
CAN_CONST const Can_BdrConfigType CanControllerBaudrateConfig_1[1] = 
{
    {	
        .CanBaudrateConfigID = 0U,
        .CanBaudrate         = 500U,
        .CanPreDiv           = 2U,
        .CanPropSeg          = 9U,
        .CanSeg1             = 8U,
        .CanSeg2             = 6U,
        .CanSyncJumpWidth    = 1U,
#if (CAN_FD_USEAGE == STD_ON)
        .CanFdBdrConfig = (const CAN_FdBdrConfigType *)&Can_FdBdrConfig_1[0],
#endif
    },
};

CAN_CONST const Can_MbRegionConfigType MbRegionConfig_0[2] =
{
    {
        .MbPlSizeType     = CAN_PLSIZE_64_BYTES,
        .MbMsgBufferNum   = 7U,
        .PayloadSize      = 64U,
        .PayloadRamLength = 72U	    
    },
    {
        .MbPlSizeType     = CAN_PLSIZE_64_BYTES,
        .MbMsgBufferNum   = 7U,
        .PayloadSize      = 64U,
        .PayloadRamLength = 72U	    
    },
};
CAN_CONST const Can_MbRegionConfigType MbRegionConfig_1[2] =
{
    {
        .MbPlSizeType     = CAN_PLSIZE_64_BYTES,
        .MbMsgBufferNum   = 7U,
        .PayloadSize      = 64U,
        .PayloadRamLength = 72U	    
    },
    {
        .MbPlSizeType     = CAN_PLSIZE_64_BYTES,
        .MbMsgBufferNum   = 7U,
        .PayloadSize      = 64U,
        .PayloadRamLength = 72U	    
    },
};


CAN_CONST const Can_PayloadConfigType	Can_PayloadConfig_0 =
{
    .MbRegionNum     = (Can_HwObjRegionType)2U,
    .MbRegionConfig  = MbRegionConfig_0,
    .ChPayloadMaxNum = 14U,
    .RxFifoType      = CAN_RX_FIFO_ENHANCE,
#if (CAN_ENHANCE_FIFO_USEAGE == STD_ON)
    .EnhanceRxFifoConfigPtr = &Can_EnhanceRxFifoConfig_0,	/*!< Point the rx fifo config */
#endif
#if (CAN_LEGACY_FIFO_USEAGE == STD_ON)
    .LegacyRxFifoConfigPtr  = NULL_PTR,
#endif
};

CAN_CONST const Can_PayloadConfigType	Can_PayloadConfig_1 =
{
    .MbRegionNum     = (Can_HwObjRegionType)2U,
    .MbRegionConfig  = MbRegionConfig_1,
    .ChPayloadMaxNum = 14U,
    .RxFifoType      = CAN_RX_FIFO_NONE,
#if (CAN_ENHANCE_FIFO_USEAGE == STD_ON)
    .EnhanceRxFifoConfigPtr = NULL_PTR,	/*!< Point the rx fifo config */
#endif
#if (CAN_LEGACY_FIFO_USEAGE == STD_ON)
    .LegacyRxFifoConfigPtr  = NULL_PTR,
#endif
};

CAN_CONST const Can_FilterOfMbType Can_FilterConfig_0[1] =
{
    {	
        .FilterCode = 0x122U,    		
        .MaskCode   = 0x7FFU,
    }
};
CAN_CONST const Can_FilterOfMbType Can_FilterConfig_1[1] =
{
    {	
        .FilterCode = 0x160U,    		
        .MaskCode   = 0x7FFU,
    }
};
CAN_CONST const Can_FilterOfMbType Can_FilterConfig_2[1] =
{
    {	
        .FilterCode = 0x17EU,    		
        .MaskCode   = 0x7FFU,
    }
};
CAN_CONST const Can_FilterOfMbType Can_FilterConfig_3[1] =
{
    {	
        .FilterCode = 0x268U,    		
        .MaskCode   = 0x7FFU,
    }
};
CAN_CONST const Can_FilterOfMbType Can_FilterConfig_4[1] =
{
    {	
        .FilterCode = 0x361U,    		
        .MaskCode   = 0x7FFU,
    }
};



CAN_CONST const Can_HohConfigType Can_HohConfig[12] =
{
    {
        .CanObjId          = 0U,
        .CanChannelId      = 0U,
        .CanHwObjRegionId  = CAN_RAM_REGION_0,
        .CanHwObjNum       = 1U,
        .ObjectType        = CAN_RECEIVE,
#if ((CAN_RX_PROCESS_HAS_POLLING == STD_ON) || (CAN_TX_PROCESS_HAS_POLLING == STD_ON))
        .UsePolling        = FALSE,
        .PollingPeriodId   = 255U,
#endif
#if (DEVELOPPING == STD_ON)
        .BasicFullType     = CAN_HANDLE_BASIC,
#endif
        .MsgIdType         = CAN_STANDARD_ID,
        .FilterConfig      = Can_FilterConfig_0,
    },
    {
        .CanObjId          = 1U,
        .CanChannelId      = 0U,
        .CanHwObjRegionId  = CAN_RAM_REGION_0,
        .CanHwObjNum       = 1U,
        .ObjectType        = CAN_RECEIVE,
#if ((CAN_RX_PROCESS_HAS_POLLING == STD_ON) || (CAN_TX_PROCESS_HAS_POLLING == STD_ON))
        .UsePolling        = FALSE,
        .PollingPeriodId   = 255U,
#endif
#if (DEVELOPPING == STD_ON)
        .BasicFullType     = CAN_HANDLE_BASIC,
#endif
        .MsgIdType         = CAN_STANDARD_ID,
        .FilterConfig      = Can_FilterConfig_1,
    },
    {
        .CanObjId          = 2U,
        .CanChannelId      = 0U,
        .CanHwObjRegionId  = CAN_RAM_REGION_0,
        .CanHwObjNum       = 1U,
        .ObjectType        = CAN_RECEIVE,
#if ((CAN_RX_PROCESS_HAS_POLLING == STD_ON) || (CAN_TX_PROCESS_HAS_POLLING == STD_ON))
        .UsePolling        = FALSE,
        .PollingPeriodId   = 255U,
#endif
#if (DEVELOPPING == STD_ON)
        .BasicFullType     = CAN_HANDLE_BASIC,
#endif
        .MsgIdType         = CAN_STANDARD_ID,
        .FilterConfig      = Can_FilterConfig_2,
    },
    {
        .CanObjId          = 3U,
        .CanChannelId      = 0U,
        .CanHwObjRegionId  = CAN_RAM_REGION_0,
        .CanHwObjNum       = 1U,
        .ObjectType        = CAN_RECEIVE,
#if ((CAN_RX_PROCESS_HAS_POLLING == STD_ON) || (CAN_TX_PROCESS_HAS_POLLING == STD_ON))
        .UsePolling        = FALSE,
        .PollingPeriodId   = 255U,
#endif
#if (DEVELOPPING == STD_ON)
        .BasicFullType     = CAN_HANDLE_BASIC,
#endif
        .MsgIdType         = CAN_STANDARD_ID,
        .FilterConfig      = Can_FilterConfig_3,
    },
    {
        .CanObjId          = 4U,
        .CanChannelId      = 0U,
        .CanHwObjRegionId  = CAN_RAM_REGION_0,
        .CanHwObjNum       = 1U,
        .ObjectType        = CAN_RECEIVE,
#if ((CAN_RX_PROCESS_HAS_POLLING == STD_ON) || (CAN_TX_PROCESS_HAS_POLLING == STD_ON))
        .UsePolling        = FALSE,
        .PollingPeriodId   = 255U,
#endif
#if (DEVELOPPING == STD_ON)
        .BasicFullType     = CAN_HANDLE_BASIC,
#endif
        .MsgIdType         = CAN_STANDARD_ID,
        .FilterConfig      = Can_FilterConfig_4,
    },
    {
        .CanObjId          = 5U,
        .CanChannelId      = 0U,
        .CanHwObjRegionId  = CAN_RX_FIFO_ENHANCE,
        .CanHwObjNum       = 32U,
        .ObjectType        = CAN_RECEIVE,
#if ((CAN_RX_PROCESS_HAS_POLLING == STD_ON) || (CAN_TX_PROCESS_HAS_POLLING == STD_ON))
        .UsePolling        = FALSE,
        .PollingPeriodId   = 255U,
#endif
#if (DEVELOPPING == STD_ON)
        .BasicFullType     = CAN_HANDLE_BASIC,
#endif
    },
    {
        .CanObjId          = 6U,
        .CanChannelId      = 0U,
        .CanHwObjRegionId  = CAN_RAM_REGION_0,
        .CanHwObjNum       = 1U,
        .ObjectType        = CAN_TRANSMIT,
#if ((CAN_RX_PROCESS_HAS_POLLING == STD_ON) || (CAN_TX_PROCESS_HAS_POLLING == STD_ON))
        .UsePolling        = FALSE,
        .PollingPeriodId   = 255U,
#endif
#if (CAN_FD_USEAGE == STD_ON)
        .CanFdPaddingValue = 0xccU,
#endif	
#if (DEVELOPPING == STD_ON)
        .TrigTransEnable   = FALSE,
#endif
#if (DEVELOPPING == STD_ON)
        .BasicFullType     = CAN_HANDLE_BASIC,
#endif
    },
    {
        .CanObjId          = 7U,
        .CanChannelId      = 0U,
        .CanHwObjRegionId  = CAN_RAM_REGION_0,
        .CanHwObjNum       = 1U,
        .ObjectType        = CAN_TRANSMIT,
#if ((CAN_RX_PROCESS_HAS_POLLING == STD_ON) || (CAN_TX_PROCESS_HAS_POLLING == STD_ON))
        .UsePolling        = FALSE,
        .PollingPeriodId   = 255U,
#endif
#if (CAN_FD_USEAGE == STD_ON)
        .CanFdPaddingValue = 0xccU,
#endif	
#if (DEVELOPPING == STD_ON)
        .TrigTransEnable   = FALSE,
#endif
#if (DEVELOPPING == STD_ON)
        .BasicFullType     = CAN_HANDLE_BASIC,
#endif
    },
    {
        .CanObjId          = 8U,
        .CanChannelId      = 0U,
        .CanHwObjRegionId  = CAN_RAM_REGION_1,
        .CanHwObjNum       = 1U,
        .ObjectType        = CAN_TRANSMIT,
#if ((CAN_RX_PROCESS_HAS_POLLING == STD_ON) || (CAN_TX_PROCESS_HAS_POLLING == STD_ON))
        .UsePolling        = FALSE,
        .PollingPeriodId   = 255U,
#endif
#if (CAN_FD_USEAGE == STD_ON)
        .CanFdPaddingValue = 0xccU,
#endif	
#if (DEVELOPPING == STD_ON)
        .TrigTransEnable   = FALSE,
#endif
#if (DEVELOPPING == STD_ON)
        .BasicFullType     = CAN_HANDLE_BASIC,
#endif
    },
    {
        .CanObjId          = 9U,
        .CanChannelId      = 0U,
        .CanHwObjRegionId  = CAN_RAM_REGION_1,
        .CanHwObjNum       = 1U,
        .ObjectType        = CAN_TRANSMIT,
#if ((CAN_RX_PROCESS_HAS_POLLING == STD_ON) || (CAN_TX_PROCESS_HAS_POLLING == STD_ON))
        .UsePolling        = FALSE,
        .PollingPeriodId   = 255U,
#endif
#if (CAN_FD_USEAGE == STD_ON)
        .CanFdPaddingValue = 0xccU,
#endif	
#if (DEVELOPPING == STD_ON)
        .TrigTransEnable   = FALSE,
#endif
#if (DEVELOPPING == STD_ON)
        .BasicFullType     = CAN_HANDLE_BASIC,
#endif
    },
    {
        .CanObjId          = 10U,
        .CanChannelId      = 0U,
        .CanHwObjRegionId  = CAN_RAM_REGION_1,
        .CanHwObjNum       = 1U,
        .ObjectType        = CAN_TRANSMIT,
#if ((CAN_RX_PROCESS_HAS_POLLING == STD_ON) || (CAN_TX_PROCESS_HAS_POLLING == STD_ON))
        .UsePolling        = FALSE,
        .PollingPeriodId   = 255U,
#endif
#if (CAN_FD_USEAGE == STD_ON)
        .CanFdPaddingValue = 0xccU,
#endif	
#if (DEVELOPPING == STD_ON)
        .TrigTransEnable   = FALSE,
#endif
#if (DEVELOPPING == STD_ON)
        .BasicFullType     = CAN_HANDLE_BASIC,
#endif
    },
    {
        .CanObjId          = 11U,
        .CanChannelId      = 0U,
        .CanHwObjRegionId  = CAN_RAM_REGION_1,
        .CanHwObjNum       = 1U,
        .ObjectType        = CAN_TRANSMIT,
#if ((CAN_RX_PROCESS_HAS_POLLING == STD_ON) || (CAN_TX_PROCESS_HAS_POLLING == STD_ON))
        .UsePolling        = FALSE,
        .PollingPeriodId   = 255U,
#endif
#if (CAN_FD_USEAGE == STD_ON)
        .CanFdPaddingValue = 0xccU,
#endif	
#if (DEVELOPPING == STD_ON)
        .TrigTransEnable   = FALSE,
#endif
#if (DEVELOPPING == STD_ON)
        .BasicFullType     = CAN_HANDLE_BASIC,
#endif
    },
};


CAN_CONST const Can_CallbackEntranceType	Can_CallbackEntrance_0 =
{	
#if ((CAN_LEGACY_FIFO_USEAGE == STD_ON) || (CAN_ENHANCE_FIFO_USEAGE == STD_ON))	
    .ReceiveFifoFullCallback		= NULL_PTR,
    .ReceiveFifoOverflowCallback	= NULL_PTR,
#endif    
    .OverrunCallback    = NULL_PTR,
    .WarningCallback    = NULL_PTR,
    .BusoffCallback     = NULL_PTR,
    .ErrorCallback      = NULL_PTR,
    .ErrFastCallback    = NULL_PTR,
    .ErrNceCallback     = NULL_PTR,
    .ErrCeCallback      = NULL_PTR,
#if (CAN_WAKEUP_SUPPORT == STD_ON)
    .WakeupCallback     = NULL_PTR,
#endif
#if (CAN_ICOM_USEAGE == STD_ON)
    .IcomCallback       = NULL_PTR,
#endif
}; 

CAN_CONST const Can_CallbackEntranceType	Can_CallbackEntrance_1 =
{	
#if ((CAN_LEGACY_FIFO_USEAGE == STD_ON) || (CAN_ENHANCE_FIFO_USEAGE == STD_ON))	
    .ReceiveFifoFullCallback		= NULL_PTR,
    .ReceiveFifoOverflowCallback	= NULL_PTR,
#endif    
    .OverrunCallback    = NULL_PTR,
    .WarningCallback    = NULL_PTR,
    .BusoffCallback     = NULL_PTR,
    .ErrorCallback      = NULL_PTR,
    .ErrFastCallback    = NULL_PTR,
    .ErrNceCallback     = NULL_PTR,
    .ErrCeCallback      = NULL_PTR,
#if (CAN_WAKEUP_SUPPORT == STD_ON)
    .WakeupCallback     = NULL_PTR,
#endif
#if (CAN_ICOM_USEAGE == STD_ON)
    .IcomCallback       = NULL_PTR,
#endif
}; 


CAN_CONST const Can_ChannelConfigType Can_ChannelConfig[2] = 
{ 	
    {
        .CanChannelId            = 0U,
        .CanHwChId               = FLEXCAN_0,
        .CanChActivation         = TRUE,
        .ChBaseAddr              = (uint32 *)1073938432U,
        .CanTrippleSamp          = FALSE,
        /* Do not need to take care of 'CanAutoBusoffRecovery' param, The driver ensures that
           when a Busoff occurs, the Can controller will always enter the STOPPED state and 
           has complied with MCAL requirements */
        .CanAutoBusoffRecovery   = TRUE, 
        .CanRxProcessing         = CAN_PROCESS_INTERRUPT,
        .CanTxProcessing         = CAN_PROCESS_INTERRUPT,
        .CanBusoffProcessing     = CAN_PROCESS_INTERRUPT,
#if (CAN_WAKEUP_SUPPORT == STD_ON)	
        .CanWakeupProcessing     = CAN_PROCESS_INTERRUPT,
        .CanWakeupSupport        = FALSE,
        .EcuMWakeupSource        = FALSE,
#endif		
#if (CAN_WAKEUP_FUNCTIONALITY_API == STD_ON)	
        .CanWakeupFunctionalityAPI = FALSE,
#endif	
#if (CAN_FD_USEAGE == STD_ON)		
        .FdUseage                = TRUE,
        .IsoModeUseage           = TRUE,
#endif
        .CanTimeQuantaSource     = CAN_CLOCK_SOURCE_OSC,
        .ChBaudrateNum           = 1U,
        .DefaultBdrConfig        = &CanControllerBaudrateConfig_0[0],
        .BdrConfigPtr            = CanControllerBaudrateConfig_0,
        .PayloadConfigPtr        = &Can_PayloadConfig_0,
        .CanCallbackPtr          = &Can_CallbackEntrance_0,
        .RamMbNum                = 64,
        .RamIrmqEn               = TRUE,
#if (CAN_MEMECC_FEATURE == STD_ON)
        .RamEnhFifoEn            = TRUE,
        .RamHrTimeStmpEn         = TRUE,
        .RamEnhMbMemEn           = FALSE,
#endif
    },
    {
        .CanChannelId            = 1U,
        .CanHwChId               = FLEXCAN_1,
        .CanChActivation         = TRUE,
        .ChBaseAddr              = (uint32 *)1073954816U,
        .CanTrippleSamp          = FALSE,
        /* Do not need to take care of 'CanAutoBusoffRecovery' param, The driver ensures that
           when a Busoff occurs, the Can controller will always enter the STOPPED state and 
           has complied with MCAL requirements */
        .CanAutoBusoffRecovery   = TRUE, 
        .CanRxProcessing         = CAN_PROCESS_INTERRUPT,
        .CanTxProcessing         = CAN_PROCESS_INTERRUPT,
        .CanBusoffProcessing     = CAN_PROCESS_INTERRUPT,
#if (CAN_WAKEUP_SUPPORT == STD_ON)	
        .CanWakeupProcessing     = CAN_PROCESS_INTERRUPT,
        .CanWakeupSupport        = FALSE,
        .EcuMWakeupSource        = FALSE,
#endif		
#if (CAN_WAKEUP_FUNCTIONALITY_API == STD_ON)	
        .CanWakeupFunctionalityAPI = FALSE,
#endif	
#if (CAN_FD_USEAGE == STD_ON)		
        .FdUseage                = TRUE,
        .IsoModeUseage           = TRUE,
#endif
        .CanTimeQuantaSource     = CAN_CLOCK_SOURCE_OSC,
        .ChBaudrateNum           = 1U,
        .DefaultBdrConfig        = &CanControllerBaudrateConfig_1[0],
        .BdrConfigPtr            = CanControllerBaudrateConfig_1,
        .PayloadConfigPtr        = &Can_PayloadConfig_1,
        .CanCallbackPtr          = &Can_CallbackEntrance_1,
        .RamMbNum                = 64,
        .RamIrmqEn               = TRUE,
#if (CAN_MEMECC_FEATURE == STD_ON)
        .RamEnhFifoEn            = TRUE,
        .RamHrTimeStmpEn         = TRUE,
        .RamEnhMbMemEn           = FALSE,
#endif
    },
};

/**
 * @brief CAN config
 */
CAN_CONST const Can_ConfigType Can_Config = 
{ 	
    .CanChannelNum        = 2U,
    .CanHohNum            = 12U,
    .CanHrhNum            = 6U,
    .CanChCfgPtr          = Can_ChannelConfig,
    .CanHohCfgPtr         = Can_HohConfig,
    .CanReceiveCallback   = CanReceiveCallOut,
    .CanTransmitCallback  = NULL_PTR,
#if ((CAN_ENHANCE_FIFO_USEAGE == STD_ON) || (CAN_LEGACY_FIFO_USEAGE == STD_ON))
#if (CAN_FIFO_IDHIT_USEAGE == STD_ON)
    .CanIdhitCallback     = NULL_PTR,
#endif
#endif
#if (CAN_ICOM_USEAGE == STD_ON)
    .CanIcomNum           = 0U,
    .CanIcomCfgPtr        = NULL_PTR,
#endif
};

#define CAN_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "Can_MemMap.h"/*memory map finish*/

#ifdef __cplusplus
}
#endif

/** @} */
