/*
 *  Copyright 2020-2024 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file Can_Cfg.h
 * @brief 
 * 
 */


#ifndef CAN_CFG_H
#define CAN_CFG_H

#ifdef __cplusplus
extern "C"{
#endif

/**
 * @page misra_violations MISRA-C:2012 violations
 *
 */

/*==================================================================================================
*                                        INCLUDE FILES
==================================================================================================*/
#include "Can_GeneralTypes.h"

/*==================================================================================================
*                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define CAN_VENDOR_ID_CFG            (180)
#define CAN_AR_REL_MAJOR_VER_CFG     (4)
#define CAN_AR_REL_MINOR_VER_CFG     (4)
#define CAN_AR_REL_REVISION_VER_CFG  (0)
#define CAN_SW_MAJOR_VER_CFG         (2)
#define CAN_SW_MINOR_VER_CFG         (0)
#define CAN_SW_PATCH_VER_CFG         (0)

/*==================================================================================================
*                                       LOCAL MACROS
==================================================================================================*/
/**
 * @brief        Switches the development error detection and notification on or off.
 * @details      * true: detection and notification is enabled.
 * false: detection and notification is disabled.
 *
 * @ref          ECUC_Can_00064
 * @scope        LOCAL
 */
#define CAN_DEV_ERROR_DETECT           (STD_ON)

/**
 * @brief        The support of the Can_SetBaudrate API is optional.
 * @details      If this parameter is set to true the Can_SetBaudrate API shall be supported. 
 	Otherwise the API is not supported.
 *
 * @ref          ECUC_Can_00482
 * @scope        ECU
 */
#define CAN_SET_BAUDRATE_API           (STD_OFF)
/**
* @brief        Switches the Can_GetVersionInfo() API ON or OFF.
*
* @ref          ECUC_Can_00106
* @scope        LOCAL
*/
#define CAN_VERSION_INFO_API           (STD_OFF)
/**
* @brief        Specifies the InstanceId of this module instance. If only one instance is 
*	present it shall have the Id 0.
*
* @ref          ECUC_Can_00320
* @scope        LOCAL
*/
#define CAN_INDEX                      (0)
/**
* @brief        This parameter describes the period for cyclic call to Can_MainFunction_Mode. 
* Unit is seconds.
*
* @ref          ECUC_Can_00376
* @scope
*/
#define CAN_MAIN_FUNCTION_MODE_PERIOD          (0.001)


/**
* @brief        Specifies the maximum time for blocking function until a timeout is detected. 
* Unit is seconds.
*
* @ref          ECUC_Can_00113
* @scope        LOCAL
*/
#define CAN_TIMEOUT_DURATION                   (0.0001)

#define CAN_DMA_USEAGE                         (STD_OFF)


#ifdef CAN_ENABLE_USER_MODE_SUPPORT
#ifndef MCAL_ENABLE_USER_MODE_SUPPORT
#error "Must define MCAL_ENABLE_USER_MODE_SUPPORT if CAN_ENABLE_USER_MODE_SUPPORT is defined"
#endif
#endif

/* CanGeneral_CanIcomGeneral */
#define CAN_PUBLIC_ICOM_SUPPORT        (STD_OFF)
/**
* @brief      	Defines the level of Pretended Networking.
* @details       This parameter is reserved for future implementations 
*				(Pretended Networking level 2).
*
* @ref          ECUC_Can_00445
* @scope        ECU
* @note range: s
*   CAN_ICOM_LEVEL_ONE
*   CAN_ICOM_LEVEL_TWO
*/
#define CAN_ICOM_LEVEL                 (CAN_ICOM_LEVEL_ONE)
/**
* @brief        Defines the variant, which is supported by this CanController
*
* @ref          ECUC_Can_00446
* @scope        ECU
* @note range: s
*   CAN_ICOM_VARIANT_HW
*   CAN_ICOM_VARIANT_NONE
*   CAN_ICOM_VARIANT_SW
*/
#define CAN_ICOM_VARIANT               (CAN_ICOM_VARIANT_NONE)
/* CanGeneral_CanMainFunctionRWPeriods */
/**
* @brief         This parameter describes the period for cyclic call to Can_MainFunction_Read 
*				or Can_MainFunction_Write depending on the referring item. Unit is seconds. 
*				Different poll-cycles will be configurable if more than one 
*				CanMainFunctionPeriod is configured. In this case multiple 
*				Can_MainFunction_Read() or Can_MainFunction_Write() will be provided by 
*				the CAN Driver module.
*
* @ref           ECUC_Can_00484
* @scope         LOCAL 
*/
#define CAN_MAIN_FUNCTION_RW_PERIOD    (STD_OFF)

#define CAN_CHANNEL_USED_NUM           (6U)
#define CAN_CHANNEL_MAX_NUM            (6U)

#define CAN_WAKEUP_FUNCTIONALITY_API   (STD_OFF)


#define CAN_FLOAT_TABLE_CODE_MODE      (STD_OFF)	

#define CAN_MAIN_FUNCTION_RW_PERIOD_OPTION_NUM (0U)

#define	CAN_ENHANCE_FIFO_CHANNEL_NUM   (3U)

#define	CAN_MAXIM_DATA_LENGTH          (64)

#define	CAN_MAILBOX_REGION_NUM         (2U)

#define CAN_MEMECC_FEATURE             (STD_ON)

#define CAN_SCHM_SUPPORT               (STD_ON)

#define CAN_FIFO_IDHIT_USEAGE          (STD_OFF)

#define CAN_API_DEINIT_ENABLE                          (STD_ON)
#define CAN_API_DISABLECONTROLLERINTERRUPTS_ENABLE     (STD_ON)
#define CAN_API_ENABLECONTROLLERINTERRUPTS_ENABLE      (STD_ON)
#define CAN_API_GETCONTROLLERERRORSTATE_ENABLE         (STD_ON)
#define CAN_API_GETCONTROLLERMODE_ENABLE               (STD_ON)
#define CAN_API_GETCONTROLLERRXERRORCOUNTER_ENABLE     (STD_ON)
#define CAN_API_GETCONTROLLERTXERRORCOUNTER_ENABLE     (STD_ON)
#define CAN_API_MAINFUNCTIONWAKEUP_ENABLE              (STD_OFF)
#define CAN_API_ABORTCONTROLLERPENDINGMESSAGE_ENABLE   (STD_OFF)

/*==================================================================================================
 *                                       SYMBOLIC NAME
==================================================================================================*/
#define CanConf_CanController_CanController_CAN0    (0U)
#define CanConf_CanController_CanController_CAN1    (1U)

#define CanConf_CanHardwareObject_CanHardwareObject_RX_0x122    (0U)
#define CanConf_CanHardwareObject_CanHardwareObject_RX_0x160    (1U)
#define CanConf_CanHardwareObject_CanHardwareObject_RX_0x17E    (2U)
#define CanConf_CanHardwareObject_CanHardwareObject_RX_0x268    (3U)
#define CanConf_CanHardwareObject_CanHardwareObject_RX_0x361    (4U)
#define CanConf_CanHardwareObject_CanHardwareObject_RX_ENHANCE_FIFO    (5U)
#define CanConf_CanHardwareObject_CanHardwareObject_TX_0x420    (6U)
#define CanConf_CanHardwareObject_CanHardwareObject_TX_0x421    (7U)
#define CanConf_CanHardwareObject_CanHardwareObject_TX_0x7A1    (8U)
#define CanConf_CanHardwareObject_CanHardwareObject_TX_0x7B2    (9U)
#define CanConf_CanHardwareObject_CanHardwareObject_TX_0x4BC    (10U)
#define CanConf_CanHardwareObject_CanHardwareObject_TX_0x4BD    (11U)

/*==================================================================================================
 *                                      PRECMPILE CONFIG
==================================================================================================*/
#define CAN_LOGIC_CHANNEL_0_MAP         (FLEXCAN_0)
#define CAN_LOGIC_CHANNEL_0_USEAGE      (STD_ON)
#define FLEXCAN_0_MAP                   (STD_ON)
#define CAN_0_FD_USEAGE    (STD_ON)
#define CAN_0_ENHANCE_FIFO_USEAGE    (STD_ON)
#define CAN_0_LEGACY_FIFO_USEAGE    (STD_OFF)
#define CAN_0_NONE_FIFO_USEAGE    (STD_OFF)
#define CAN_0_DMA_USEAGE    (STD_OFF)
#define CAN_0_RX_PROCESS_MODE    (CAN_EVENT_PROCESS_INTERRUPT)
#define CAN_0_TX_PROCESS_MODE    (CAN_EVENT_PROCESS_INTERRUPT)
#define CAN_0_BUSOFF_PROCESS_MODE    (CAN_EVENT_PROCESS_INTERRUPT)
#define CAN_0_RAM_REGION_NUM    (2U)
#define CAN_0_CAN_RAM_REGION_0_MB_NUM    (7U)
#define CAN_0_CAN_RAM_REGION_1_MB_NUM    (7U)

#define CAN_LOGIC_CHANNEL_1_MAP         (FLEXCAN_1)
#define CAN_LOGIC_CHANNEL_1_USEAGE      (STD_ON)
#define FLEXCAN_1_MAP                   (STD_ON)
#define CAN_1_FD_USEAGE    (STD_ON)
#define CAN_1_ENHANCE_FIFO_USEAGE    (STD_OFF)
#define CAN_1_LEGACY_FIFO_USEAGE    (STD_OFF)
#define CAN_1_NONE_FIFO_USEAGE    (STD_ON)
#define CAN_1_DMA_USEAGE    (STD_OFF)
#define CAN_1_RX_PROCESS_MODE    (CAN_EVENT_PROCESS_INTERRUPT)
#define CAN_1_TX_PROCESS_MODE    (CAN_EVENT_PROCESS_INTERRUPT)
#define CAN_1_BUSOFF_PROCESS_MODE    (CAN_EVENT_PROCESS_INTERRUPT)
#define CAN_1_RAM_REGION_NUM    (2U)
#define CAN_1_CAN_RAM_REGION_0_MB_NUM    (7U)
#define CAN_1_CAN_RAM_REGION_1_MB_NUM    (7U)


extern uint16 * Can_RxFifoLatestIdhit[6];



#ifdef __cplusplus
}
#endif

#endif /* CAN_CFG_H */

/** @} */
