/*
 *  Copyright 2020-2024 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file undefined
 * @brief 
 * 
 */

#include "Adc.h"
#include "Adc_Cfg.h"
#ifdef ADC_DMA_SUPPORTED
#include "CddDma_Cfg.h"
#endif

/*==================================================================================================
*                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define ADC_VENDOR_ID_PBCFG_C               (180)
#define ADC_AR_REL_MAJOR_VER_PBCFG_C        (4)
#define ADC_AR_REL_MINOR_VER_PBCFG_C        (4)
#define ADC_AR_REL_REVISION_VER_PBCFG_C     (0)
#define ADC_SW_MAJOR_VER_PBCFG_C            (2)
#define ADC_SW_MINOR_VER_PBCFG_C           (0)
#define ADC_SW_PATCH_VER_PBCFG_C           (0)

/*================================================================================================== */
/**
 * @brief          Config number of ADC Hw units.
 */
#define ADC_UNIT_NUMBER                         (2U)

/**
 * @brief          Max number of ADC Hw units.
 */
#define ADC_GROUP_NUMBER                        (4U)

/*****************************************************************************************************/
#if(ADC_GRP_NOTIF_CAPABILITY == STD_ON)




#endif

#define ADC_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "Adc_MemMap.h"

/*Group channels definetion*/
ADC_CONST static const Adc_ChannelType AdcGroup_0_Channel[6] = 
{
    ADC0_SE11_ADCH11,
    ADC0_SE9_ADCH9,
    ADC0_SE15_ADCH15,
    ADC0_SE14_ADCH14,
    ADC0_SE7_ADCH7,
    ADC0_SE6_ADCH6,
};
ADC_CONST static const Adc_ChannelType AdcGroup_1_Channel[6] = 
{
    ADC0_SE5_ADCH5,
    ADC0_SE4_ADCH4,
    ADC0_SE1_ADCH1,
    ADC0_SE0_ADCH0,
    ADC0_SE13_ADCH13,
    ADC0_SE12_ADCH12,
};
ADC_CONST static const Adc_ChannelType AdcGroup_2_Channel[5] = 
{
    ADC1_SE7_ADCH7,
    ADC1_SE6_ADCH6,
    ADC1_SE3_ADCH3,
    ADC1_SE2_ADCH2,
    ADC1_SE1_ADCH1,
};
ADC_CONST static const Adc_ChannelType AdcGroup_3_Channel[3] = 
{
    ADC1_SE13_ADCH13,
    ADC1_SE11_ADCH11,
    ADC1_SE8_ADCH8,
};

/**/

ADC_CONST static const Adc_GroupDefType AdcGroup_0_ChannelsInf = 
{
    .GroupChannels       = &AdcGroup_0_Channel[0],
    .GroupChannelsNum    = 6,
    .GroupInHwUnitId     = ADC_0,
};
ADC_CONST static const Adc_GroupDefType AdcGroup_1_ChannelsInf = 
{
    .GroupChannels       = &AdcGroup_1_Channel[0],
    .GroupChannelsNum    = 6,
    .GroupInHwUnitId     = ADC_0,
};

ADC_CONST static const Adc_GroupDefType AdcGroup_2_ChannelsInf = 
{
    .GroupChannels       = &AdcGroup_2_Channel[0],
    .GroupChannelsNum    = 5,
    .GroupInHwUnitId     = ADC_1,
};
ADC_CONST static const Adc_GroupDefType AdcGroup_3_ChannelsInf = 
{
    .GroupChannels       = &AdcGroup_3_Channel[0],
    .GroupChannelsNum    = 3,
    .GroupInHwUnitId     = ADC_1,
};

#if (ADC_UNIT_NUMBER != 0)
#if (ADC_UNIT_NUMBER > ADC_MAX_HW_UNITS)
    #error "Config too many ADC Hw Unit !"
#else
ADC_CONST const Adc_HwUnitType Adc_HwUnitConfiguration[ADC_UNIT_NUMBER] = {
{
    .HwUnitId = ADC_0,
    .ClockSource = ADC_BUSCLK,
    .Prescale = 0,
        .StartupTime = 41,
},
{
    .HwUnitId = ADC_1,
    .ClockSource = ADC_BUSCLK,
    .Prescale = 0,
        .StartupTime = 41,
},
};
#endif /* ADC_UNIT_NUMBER > ADC_MAX_HW_UNITS */
#endif /* ADC_UNIT_NUMBER != 0 */

ADC_CONST const Adc_ChannelSampleType AdcGroup_0_ChannelSample = {
    .ChannelSampTime = 2,
    .ChannelConvTime = 0,
    .ChannelRefVoltsrcHigh = 0,
    .ChannelRefVoltsrcLow = 0,
    .ChannelResolution = ADC_RESOLUTION_12BIT,
};
ADC_CONST const Adc_ChannelSampleType AdcGroup_1_ChannelSample = {
    .ChannelSampTime = 2,
    .ChannelConvTime = 0,
    .ChannelRefVoltsrcHigh = 0,
    .ChannelRefVoltsrcLow = 0,
    .ChannelResolution = ADC_RESOLUTION_12BIT,
};
ADC_CONST const Adc_ChannelSampleType AdcGroup_2_ChannelSample = {
    .ChannelSampTime = 2,
    .ChannelConvTime = 0,
    .ChannelRefVoltsrcHigh = 0,
    .ChannelRefVoltsrcLow = 0,
    .ChannelResolution = ADC_RESOLUTION_12BIT,
};
ADC_CONST const Adc_ChannelSampleType AdcGroup_3_ChannelSample = {
    .ChannelSampTime = 2,
    .ChannelConvTime = 0,
    .ChannelRefVoltsrcHigh = 0,
    .ChannelRefVoltsrcLow = 0,
    .ChannelResolution = ADC_RESOLUTION_12BIT,
};

ADC_CONST const Adc_GroupSampleType AdcGroup_0_Configuration = 
{
    .GroupAccessMode = ADC_ACCESS_MODE_SINGLE,
    .GroupConversionMode = ADC_CONV_MODE_ONESHOT,
#if (ADC_PRIORITY_IMPLEMENTATION != ADC_PRIORITY_NONE)
    .GroupPriority = 0,
#endif /* (ADC_PRIORITY_IMPLEMENTATION != ADC_PRIORITY_NONE) */
    .GroupReplacement = ADC_GROUP_REPL_ABORT_RESTART,
    .GroupTriggSrc = ADC_TRIGG_SRC_SW,
#if (ADC_HW_TRIGGER_API == STD_ON)
    .HwTrigSignal = ADC_HW_TRIG_RISING_EDGE,
    .HwTrigTimer = 0,
#endif /* (ADC_HW_TRIGGER_API == STD_ON) */
    .StreamingBufferMode = ADC_STREAM_BUFFER_LINEAR,
    .StreamingNumSamples = 1,
    .GroupDefinition = &AdcGroup_0_ChannelsInf,
    .NotificationFunc = NULL_PTR,
    .IntcAndDmaCfg = ADC_INTC_ENABLED,
};
ADC_CONST const Adc_GroupSampleType AdcGroup_1_Configuration = 
{
    .GroupAccessMode = ADC_ACCESS_MODE_SINGLE,
    .GroupConversionMode = ADC_CONV_MODE_ONESHOT,
#if (ADC_PRIORITY_IMPLEMENTATION != ADC_PRIORITY_NONE)
    .GroupPriority = 0,
#endif /* (ADC_PRIORITY_IMPLEMENTATION != ADC_PRIORITY_NONE) */
    .GroupReplacement = ADC_GROUP_REPL_ABORT_RESTART,
    .GroupTriggSrc = ADC_TRIGG_SRC_SW,
#if (ADC_HW_TRIGGER_API == STD_ON)
    .HwTrigSignal = ADC_HW_TRIG_RISING_EDGE,
    .HwTrigTimer = 0,
#endif /* (ADC_HW_TRIGGER_API == STD_ON) */
    .StreamingBufferMode = ADC_STREAM_BUFFER_LINEAR,
    .StreamingNumSamples = 1,
    .GroupDefinition = &AdcGroup_1_ChannelsInf,
    .NotificationFunc = NULL_PTR,
    .IntcAndDmaCfg = ADC_INTC_ENABLED,
};
ADC_CONST const Adc_GroupSampleType AdcGroup_2_Configuration = 
{
    .GroupAccessMode = ADC_ACCESS_MODE_SINGLE,
    .GroupConversionMode = ADC_CONV_MODE_ONESHOT,
#if (ADC_PRIORITY_IMPLEMENTATION != ADC_PRIORITY_NONE)
    .GroupPriority = 0,
#endif /* (ADC_PRIORITY_IMPLEMENTATION != ADC_PRIORITY_NONE) */
    .GroupReplacement = ADC_GROUP_REPL_ABORT_RESTART,
    .GroupTriggSrc = ADC_TRIGG_SRC_SW,
#if (ADC_HW_TRIGGER_API == STD_ON)
    .HwTrigSignal = ADC_HW_TRIG_RISING_EDGE,
    .HwTrigTimer = 0,
#endif /* (ADC_HW_TRIGGER_API == STD_ON) */
    .StreamingBufferMode = ADC_STREAM_BUFFER_LINEAR,
    .StreamingNumSamples = 1,
    .GroupDefinition = &AdcGroup_2_ChannelsInf,
    .NotificationFunc = NULL_PTR,
    .IntcAndDmaCfg = ADC_INTC_ENABLED,
};
ADC_CONST const Adc_GroupSampleType AdcGroup_3_Configuration = 
{
    .GroupAccessMode = ADC_ACCESS_MODE_SINGLE,
    .GroupConversionMode = ADC_CONV_MODE_ONESHOT,
#if (ADC_PRIORITY_IMPLEMENTATION != ADC_PRIORITY_NONE)
    .GroupPriority = 0,
#endif /* (ADC_PRIORITY_IMPLEMENTATION != ADC_PRIORITY_NONE) */
    .GroupReplacement = ADC_GROUP_REPL_ABORT_RESTART,
    .GroupTriggSrc = ADC_TRIGG_SRC_SW,
#if (ADC_HW_TRIGGER_API == STD_ON)
    .HwTrigSignal = ADC_HW_TRIG_RISING_EDGE,
    .HwTrigTimer = 0,
#endif /* (ADC_HW_TRIGGER_API == STD_ON) */
    .StreamingBufferMode = ADC_STREAM_BUFFER_LINEAR,
    .StreamingNumSamples = 1,
    .GroupDefinition = &AdcGroup_3_ChannelsInf,
    .NotificationFunc = NULL_PTR,
    .IntcAndDmaCfg = ADC_INTC_ENABLED,
};

ADC_CONST const Adc_GroupConfigType Adc_GourpsConfiguration[4] = 
{
    {
        .GroupId = AdcConf_AdcConfigSet_AdcGroup_0,
        .GroupSample = &AdcGroup_0_Configuration,
        .ChannelSample = &AdcGroup_0_ChannelSample,
    },
    {
        .GroupId = AdcConf_AdcConfigSet_AdcGroup_1,
        .GroupSample = &AdcGroup_1_Configuration,
        .ChannelSample = &AdcGroup_1_ChannelSample,
    },
    {
        .GroupId = AdcConf_AdcConfigSet_AdcGroup_2,
        .GroupSample = &AdcGroup_2_Configuration,
        .ChannelSample = &AdcGroup_2_ChannelSample,
    },
    {
        .GroupId = AdcConf_AdcConfigSet_AdcGroup_3,
        .GroupSample = &AdcGroup_3_Configuration,
        .ChannelSample = &AdcGroup_3_ChannelSample,
    },
};
ADC_CONST const Adc_ConfigType Adc_Config =
{
    .GroupCfgNum    = ADC_GROUP_NUMBER,
    .HwUnitCfgNum   = ADC_UNIT_NUMBER,
    .HwUnitUserCfg = &Adc_HwUnitConfiguration[0],
    .GroupUserCfg  = &Adc_GourpsConfiguration[0],
};

#define ADC_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "Adc_MemMap.h"