/**
 * @file    Wdg_Mld_Irq.c
 * @version V2.0.0
 *
 * @brief   YUNTU Wdg_Mld module interface
 * @details API implementation for Wdg_Mld driver
 *
 * @addtogroup WDG_MLD_MODULE
 * @{
 */
/*==================================================================================================
 *   Project              : YTMicro AUTOSAR 4.4.0 MCAL
 *   Platform             : ARM
 *   Peripheral           : WDG, EWDG
 *   Dependencies         : none
 *
 *   Autosar Version      : V4.4.0
 *   Autosar Revision     : ASR_REL_4_4_REV_0000
 *   Autosar Conf.Variant :
 *   SW Version           : V2.0.0
 *
 *   (c) Copyright 2020-2023 Yuntu Microelectronics co.,ltd.
 *   All Rights Reserved.
==================================================================================================*/

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
 *                                        INCLUDE FILES
==================================================================================================*/
#include "Wdg_Mld.h"
#if (WDG_LLD_ENABLE == STD_ON)
#include "Wdg_Lld.h"
#endif
#if (EWDG_LLD_ENABLE == STD_ON)
#include "Ewdg_Lld.h"
#endif

/*==================================================================================================
 *                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define WDG_MLD_IRQ_VENDOR_ID_C             (180)
#define WDG_MLD_IRQ_AR_REL_MAJOR_VER_C      (4)
#define WDG_MLD_IRQ_AR_REL_MINOR_VER_C      (4)
#define WDG_MLD_IRQ_AR_REL_REVISION_VER_C   (0)
#define WDG_MLD_IRQ_SW_MAJOR_VER_C          (2)
#define WDG_MLD_IRQ_SW_MINOR_VER_C          (0)
#define WDG_MLD_IRQ_SW_PATCH_VER_C          (0)

/*==================================================================================================
 *                                     FILE VERSION CHECKS
==================================================================================================*/
/* Check if Wdg_Mld_Irq.c and Wdg_Mld.h are of the same vendor */
#if (WDG_MLD_IRQ_VENDOR_ID_C != WDG_MLD_VENDOR_ID)
#error "Wdg_Mld_Irq.c and Wdg_Mld.h have different vendor ids"
#endif

/* Check if Wdg_Mld_Irq.c and Wdg_Mld.h are of the same Autosar version */
#if ((WDG_MLD_IRQ_AR_REL_MAJOR_VER_C != WDG_MLD_AR_REL_MAJOR_VER) || \
     (WDG_MLD_IRQ_AR_REL_MINOR_VER_C != WDG_MLD_AR_REL_MINOR_VER) || \
     (WDG_MLD_IRQ_AR_REL_REVISION_VER_C != WDG_MLD_AR_REL_REVISION_VER))
#error "AutoSar Version Numbers of Wdg_Mld_Irq.c and Wdg_Mld.h are different"
#endif

/* Check if Wdg_Mld_Irq.c and Wdg_Mld.h are of the same software version */
#if ((WDG_MLD_IRQ_SW_MAJOR_VER_C != WDG_MLD_SW_MAJOR_VER) || \
     (WDG_MLD_IRQ_SW_MINOR_VER_C != WDG_MLD_SW_MINOR_VER) || \
     (WDG_MLD_IRQ_SW_PATCH_VER_C != WDG_MLD_SW_PATCH_VER))
#error "Software Version Numbers of Wdg_Mld_Irq.c and Wdg_Mld.h are different"
#endif

#if (WDG_LLD_ENABLE == STD_ON)
/* Check if Wdg_Mld_Irq.c and Wdg_Lld.h are of the same vendor */
#if (WDG_MLD_IRQ_VENDOR_ID_C != WDG_LLD_VENDOR_ID)
#error "Wdg_Mld_Irq.c and Wdg_Lld.h have different vendor ids"
#endif

/* Check if Wdg_Mld_Irq.c and Wdg_Lld.h are of the same Autosar version */
#if ((WDG_MLD_IRQ_AR_REL_MAJOR_VER_C != WDG_LLD_AR_REL_MAJOR_VER) || \
     (WDG_MLD_IRQ_AR_REL_MINOR_VER_C != WDG_LLD_AR_REL_MINOR_VER) || \
     (WDG_MLD_IRQ_AR_REL_REVISION_VER_C != WDG_LLD_AR_REL_REVISION_VER))
#error "AutoSar Version Numbers of Wdg_Mld_Irq.c and Wdg_Lld.h are different"
#endif

/* Check if Wdg_Mld_Irq.c and Wdg_Lld.h are of the same software version */
#if ((WDG_MLD_IRQ_SW_MAJOR_VER_C != WDG_LLD_SW_MAJOR_VER) || \
     (WDG_MLD_IRQ_SW_MINOR_VER_C != WDG_LLD_SW_MINOR_VER) || \
     (WDG_MLD_IRQ_SW_PATCH_VER_C != WDG_LLD_SW_PATCH_VER))
#error "Software Version Numbers of Wdg_Mld_Irq.c and Wdg_Lld.h are different"
#endif
#endif

#if (EWDG_LLD_ENABLE == STD_ON)
/* Check if Wdg_Mld_Irq.c and Ewdg_Lld.h are of the same vendor */
#if (WDG_MLD_IRQ_VENDOR_ID_C != EWDG_LLD_VENDOR_ID)
#error "Wdg_Mld_Irq.c and Ewdg_Lld.h have different vendor ids"
#endif

/* Check if Wdg_Mld_Irq.c and Ewdg_Lld.h are of the same Autosar version */
#if ((WDG_MLD_IRQ_AR_REL_MAJOR_VER_C != EWDG_LLD_AR_REL_MAJOR_VER) || \
     (WDG_MLD_IRQ_AR_REL_MINOR_VER_C != EWDG_LLD_AR_REL_MINOR_VER) || \
     (WDG_MLD_IRQ_AR_REL_REVISION_VER_C != EWDG_LLD_AR_REL_REVISION_VER))
#error "AutoSar Version Numbers of Wdg_Mld_Irq.c and Ewdg_Lld.h are different"
#endif

/* Check if Wdg_Mld_Irq.c and Ewdg_Lld.h are of the same software version */
#if ((WDG_MLD_IRQ_SW_MAJOR_VER_C != EWDG_LLD_SW_MAJOR_VER) || \
     (WDG_MLD_IRQ_SW_MINOR_VER_C != EWDG_LLD_SW_MINOR_VER) || \
     (WDG_MLD_IRQ_SW_PATCH_VER_C != EWDG_LLD_SW_PATCH_VER))
#error "Software Version Numbers of Wdg_Mld_Irq.c and Ewdg_Lld.h are different"
#endif
#endif

/*==================================================================================================
 *                                   GLOBAL FUNCTIONS PROTOTYPES
==================================================================================================*/
#if (WDG_MLD_RUN_ON_ROM == STD_ON)
#define WDG_START_SEC_CODE
#else
#define WDG_START_SEC_RAMCODE
#endif
#include "Wdg_MemMap.h"

#if ((WDG_MLD_ISR0_USED == STD_ON) || (WDG_MLD_ISR1_USED == STD_ON))
WDG_FUNC void Wdg_Mld_Isr(void);

/*==================================================================================================
 *                                       GLOBAL FUNCTIONS
==================================================================================================*/
/**
 * @brief   WDG interrupt handler.
 * @details This function handles the WDG interrupt. The IRQ numbers of EWDG and WDG are the same.
 * @return  void
 */
WDG_FUNC void Wdg_Mld_Isr(void)
{
#if (WDG_MLD_ISR0_USED == STD_ON)
    Wdg_Lld_IrqHandler(0U);
#endif

#if (WDG_MLD_ISR1_USED == STD_ON)
    Ewdg_Lld_IrqHandler(0U);
#endif
}
#endif /* #if ((WDG_MLD_ISR0_USED == STD_ON) || (WDG_MLD_ISR1_USED == STD_ON)) */

#if (WDG_MLD_RUN_ON_ROM == STD_ON)
#define WDG_STOP_SEC_CODE
#else
#define WDG_STOP_SEC_RAMCODE
#endif
#include "Wdg_MemMap.h"

#ifdef __cplusplus
}
#endif

/** @} */
