/**
 * @file    Wdg_Lld_Irq.c
 * @version V2.0.0
 *
 * @brief   YUNTU Wdg_Lld module interface
 * @details API implementation for Wdg_Lld driver
 *
 * @addtogroup WDG_LLD_MODULE
 * @{
 */
/*==================================================================================================
 *   Project              : YTMicro AUTOSAR 4.4.0 MCAL
 *   Platform             : ARM
 *   Peripheral           : WDG
 *   Dependencies         : none
 *
 *   Autosar Version      : V4.4.0
 *   Autosar Revision     : ASR_REL_4_4_REV_0000
 *   Autosar Conf.Variant :
 *   SW Version           : V2.0.0
 *
 *   (c) Copyright 2020-2023 Yuntu Microelectronics co.,ltd.
 *   All Rights Reserved.
==================================================================================================*/

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
 *                                        INCLUDE FILES
==================================================================================================*/
#include "Wdg_Lld.h"

/*==================================================================================================
 *                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define WDG_LLD_IRQ_VENDOR_ID_C             (180)
#define WDG_LLD_IRQ_AR_REL_MAJOR_VER_C      (4)
#define WDG_LLD_IRQ_AR_REL_MINOR_VER_C      (4)
#define WDG_LLD_IRQ_AR_REL_REVISION_VER_C   (0)
#define WDG_LLD_IRQ_SW_MAJOR_VER_C          (2)
#define WDG_LLD_IRQ_SW_MINOR_VER_C          (0)
#define WDG_LLD_IRQ_SW_PATCH_VER_C          (0)

/*==================================================================================================
 *                                     FILE VERSION CHECKS
==================================================================================================*/
/* Check if Wdg_Lld_Irq.c and Wdg_Lld.h are of the same vendor */
#if (WDG_LLD_IRQ_VENDOR_ID_C != WDG_LLD_VENDOR_ID)
#error "Wdg_Lld_Irq.c and Wdg_Lld.h have different vendor ids"
#endif

/* Check if Wdg_Lld_Irq.c and Wdg_Lld.h are of the same Autosar version */
#if ((WDG_LLD_IRQ_AR_REL_MAJOR_VER_C != WDG_LLD_AR_REL_MAJOR_VER) || \
     (WDG_LLD_IRQ_AR_REL_MINOR_VER_C != WDG_LLD_AR_REL_MINOR_VER) || \
     (WDG_LLD_IRQ_AR_REL_REVISION_VER_C != WDG_LLD_AR_REL_REVISION_VER))
#error "AutoSar Version Numbers of Wdg_Lld_Irq.c and Wdg_Lld.h are different"
#endif

/* Check if Wdg_Lld_Irq.c and Wdg_Lld.h are of the same software version */
#if ((WDG_LLD_IRQ_SW_MAJOR_VER_C != WDG_LLD_SW_MAJOR_VER) || \
     (WDG_LLD_IRQ_SW_MINOR_VER_C != WDG_LLD_SW_MINOR_VER) || \
     (WDG_LLD_IRQ_SW_PATCH_VER_C != WDG_LLD_SW_PATCH_VER))
#error "Software Version Numbers of Wdg_Lld_Irq.c and Wdg_Lld.h are different"
#endif

#if (WDG_LLD_ENABLE == STD_ON)

#if (WDG_LLD_RUN_ON_ROM == STD_ON)
#define WDG_START_SEC_CODE
#else
#define WDG_START_SEC_RAMCODE
#endif
#include "Wdg_MemMap.h"

#if (WDG_LLD_ISR_USED == STD_ON)
/*==================================================================================================
 *                                   GLOBAL FUNCTIONS PROTOTYPES
==================================================================================================*/
WDG_FUNC void Wdg_Lld_Isr(void);

/*==================================================================================================
 *                                       GLOBAL FUNCTIONS
==================================================================================================*/

/**
 * @brief   WDG interrupt handler.
 * @details This function handles the WDG interrupt. The IRQ numbers of EWDG and WDG are the same.
 * @return  void
 */
WDG_FUNC void Wdg_Lld_Isr(void)
{
    Wdg_Lld_IrqHandler(0U);
}
#endif /* #if (WDG_LLD_ISR_USED == STD_ON) */

#if (WDG_LLD_RUN_ON_ROM == STD_ON)
#define WDG_STOP_SEC_CODE
#else
#define WDG_STOP_SEC_RAMCODE
#endif
#include "Wdg_MemMap.h"

#endif /* #if (WDG_LLD_ENABLE == STD_ON) */

#ifdef __cplusplus
}
#endif

/** @} */
