/**
 * @file    Wdg_180_Inst1.c
 * @version V2.0.0
 *
 * @brief   YUNTU Wdg_180_Inst1 module interface
 * @details API implementation for Wdg_180_Inst1 driver
 *
 * @addtogroup WDG_180_INST1_MODULE
 * @{
 */
/*==================================================================================================
 *   Project              : YTMicro AUTOSAR 4.4.0 MCAL
 *   Platform             : ARM
 *   Peripheral           : EWDG
 *   Dependencies         : none
 *
 *   Autosar Version      : V4.4.0
 *   Autosar Revision     : ASR_REL_4_4_REV_0000
 *   Autosar Conf.Variant :
 *   SW Version           : V2.0.0
 *
 *   (c) Copyright 2020-2023 Yuntu Microelectronics co.,ltd.
 *   All Rights Reserved.
==================================================================================================*/

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
 *                                          INCLUDE FILES
==================================================================================================*/
#include "Wdg_180_Inst1.h"
#include "Wdg_Types.h"
#include "Wdg_Inst.h"

#ifdef WDG_180_INST1_ENABLE
#if (WDG_180_INST1_ENABLE == STD_ON)

/*==================================================================================================
 *                                 SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define WDG_180_INST1_VENDOR_ID_C           (180)
#define WDG_180_INST1_AR_REL_MAJOR_VER_C    (4)
#define WDG_180_INST1_AR_REL_MINOR_VER_C    (4)
#define WDG_180_INST1_AR_REL_REVISION_VER_C (0)
#define WDG_180_INST1_SW_MAJOR_VER_C        (2)
#define WDG_180_INST1_SW_MINOR_VER_C        (0)
#define WDG_180_INST1_SW_PATCH_VER_C        (0)

/*==================================================================================================
 *                                       FILE VERSION CHECKS
==================================================================================================*/
/* Check if Wdg_180_Inst1.c and Wdg_180_Inst1.h are of the same vendor */
#if (WDG_180_INST1_VENDOR_ID_C != WDG_180_INST1_VENDOR_ID)
#error "Wdg_180_Inst1.c and Wdg_180_Inst1.h have different vendor ids"
#endif

/* Check if Wdg_180_Inst1.c and Wdg_180_Inst1.h are of the same Autosar version */
#if ((WDG_180_INST1_AR_REL_MAJOR_VER_C != WDG_180_INST1_AR_REL_MAJOR_VER) || \
     (WDG_180_INST1_AR_REL_MINOR_VER_C != WDG_180_INST1_AR_REL_MINOR_VER) || \
     (WDG_180_INST1_AR_REL_REVISION_VER_C != WDG_180_INST1_AR_REL_REVISION_VER))
#error "AutoSar Version Numbers of Wdg_180_Inst1.c and Wdg_180_Inst1.h are different"
#endif

/* Check if Wdg_180_Inst1.c and Wdg_180_Inst1.h are of the same Software version */
#if ((WDG_180_INST1_SW_MAJOR_VER_C != WDG_180_INST1_SW_MAJOR_VER) || \
     (WDG_180_INST1_SW_MINOR_VER_C != WDG_180_INST1_SW_MINOR_VER) || \
     (WDG_180_INST1_SW_PATCH_VER_C != WDG_180_INST1_SW_PATCH_VER))
#error "Software Version Numbers of Wdg_180_Inst1.c and Wdg_180_Inst1.h are different"
#endif

/* Check if Wdg_180_Inst1.c and Wdg_Types.h are of the same vendor */
#if (WDG_180_INST1_VENDOR_ID_C != WDG_TYPES_VENDOR_ID)
#error "Wdg_180_Inst1.c and Wdg_Types.h have different vendor ids"
#endif

/* Check if Wdg_180_Inst1.c and Wdg_Types.h are of the same Autosar version */
#if ((WDG_180_INST1_AR_REL_MAJOR_VER_C != WDG_TYPES_AR_REL_MAJOR_VER) || \
     (WDG_180_INST1_AR_REL_MINOR_VER_C != WDG_TYPES_AR_REL_MINOR_VER) || \
     (WDG_180_INST1_AR_REL_REVISION_VER_C != WDG_TYPES_AR_REL_REVISION_VER))
#error "AutoSar Version Numbers of Wdg_180_Inst1.c and Wdg_Types.h are different"
#endif

/* Check if Wdg_180_Inst1.c and Wdg_Types.h are of the same Software version */
#if ((WDG_180_INST1_SW_MAJOR_VER_C != WDG_TYPES_SW_MAJOR_VER) || \
     (WDG_180_INST1_SW_MINOR_VER_C != WDG_TYPES_SW_MINOR_VER) || \
     (WDG_180_INST1_SW_PATCH_VER_C != WDG_TYPES_SW_PATCH_VER))
#error "Software Version Numbers of Wdg_180_Inst1.c and Wdg_Types.h are different"
#endif

/* Check if Wdg_180_Inst1.c and Wdg_Inst.h are of the same vendor */
#if (WDG_180_INST1_VENDOR_ID_C != WDG_INST_VENDOR_ID)
#error "Wdg_180_Inst1.c and Wdg_Inst.h have different vendor ids"
#endif

/* Check if Wdg_180_Inst1.c and Wdg_Inst.h are of the same Autosar version */
#if ((WDG_180_INST1_AR_REL_MAJOR_VER_C != WDG_INST_AR_REL_MAJOR_VER) || \
     (WDG_180_INST1_AR_REL_MINOR_VER_C != WDG_INST_AR_REL_MINOR_VER) || \
     (WDG_180_INST1_AR_REL_REVISION_VER_C != WDG_INST_AR_REL_REVISION_VER))
#error "AutoSar Version Numbers of Wdg_180_Inst1.c and Wdg_Inst.h are different"
#endif

/* Check if Wdg_180_Inst1.c and Wdg_Inst.h are of the same Software version */
#if ((WDG_180_INST1_SW_MAJOR_VER_C != WDG_INST_SW_MAJOR_VER) || \
     (WDG_180_INST1_SW_MINOR_VER_C != WDG_INST_SW_MINOR_VER) || \
     (WDG_180_INST1_SW_PATCH_VER_C != WDG_INST_SW_PATCH_VER))
#error "Software Version Numbers of Wdg_180_Inst1.c and Wdg_Inst.h are different"
#endif

#if (WDG_RUN_ON_ROM == STD_ON)
#define WDG_START_SEC_CODE
#else
#define WDG_START_SEC_RAMCODE
#endif
#include "Wdg_MemMap.h"
/*==================================================================================================
 *                                   GLOBAL FUNCTIONS PROTOTYPES
==================================================================================================*/
#if (WDG_MANUAL_SERVICE == STD_OFF)
/**
 * @brief       Wdg callback function for GPT notification.
 * @return      void
 */
WDG_FUNC void Wdg_180_Inst1_Cbk_GptNotification(void);
#endif

/*==================================================================================================
 *                                        GLOBAL FUNCTIONS
==================================================================================================*/
/**
 * @brief       Initializes the WDG module.
 * @param[in]   ConfigPtr Pointer to configuration set
 * @return      void
 */
WDG_FUNC void Wdg_180_Inst1_Init(const Wdg_ConfigType *ConfigPtr)
{
    Wdg_Inst_Init(WDG_MLD_INST1, ConfigPtr);
}

/**
 * @brief       Switches the watchdog into the mode Mode.
 * @param[in]   Mode WDGIF_OFF_MODE, WDGIF_SLOW_MODE, WDGIF_FAST_MODE
 * @return      Std_ReturnType
 * @retval      E_OK Mode switch was successful.
 * @retval      E_NOT_OK Mode switch was not successful.
 */
WDG_FUNC Std_ReturnType Wdg_180_Inst1_SetMode(WdgIf_ModeType Mode)
{
    return Wdg_Inst_SetMode(WDG_MLD_INST1, Mode);
}

#if (WDG_180_INST1_MANUAL_SERVICE == STD_OFF)
/**
 * @brief       Sets the timeout value for the trigger counter.
 * @param[in]   Timeout Timeout value (milliseconds) for setting the trigger counter.
 * @return      void
 */
WDG_FUNC void Wdg_180_Inst1_SetTriggerCondition(uint16 Timeout)
{
    Wdg_Inst_SetTriggerCondition(WDG_MLD_INST1, Timeout);
}
#endif

#if (WDG_180_INST1_MANUAL_SERVICE == STD_ON)
/**
 * @brief       Refreshes the watchdog timer Manually.
 * @return      void
 */
WDG_FUNC void Wdg_180_Inst1_Service(void)
{
    Wdg_Inst_Service(WDG_MLD_INST1);
}
#endif

#if (WDG_180_INST1_VERSION_INFO_API == STD_ON)
/**
 * @brief       Returns the version information of the module.
 * @param[out]  VersionInfo Pointer to where to store the version information of this module.
 * @return      void
 */
WDG_FUNC void Wdg_180_Inst1_GetVersionInfo(Std_VersionInfoType *VersionInfo)
{
    Wdg_Inst_GetVersionInfo(WDG_MLD_INST1, VersionInfo);
}
#endif

#if (WDG_MANUAL_SERVICE == STD_OFF)
/**
 * @brief       Wdg callback function for GPT notification.
 * @return      void
 */
WDG_FUNC void Wdg_180_Inst1_Cbk_GptNotification(void)
{
    Wdg_Inst_GptTrigger(WDG_MLD_INST1);
}
#endif

#if (WDG_RUN_ON_ROM == STD_ON)
#define WDG_STOP_SEC_CODE
#else
#define WDG_STOP_SEC_RAMCODE
#endif
#include "Wdg_MemMap.h"

#endif /* #if (WDG_180_INST1_ENABLE == STD_ON) */
#endif /* #ifdef WDG_180_INST1_ENABLE */

#ifdef __cplusplus
}
#endif

/** @} */
