/**
 * @file    Ewdg_Lld_Irq.c
 * @version V2.0.0
 *
 * @brief   YUNTU Ewdg_Lld module interface
 * @details API implementation for Ewdg_Lld driver
 *
 * @addtogroup EWDG_LLD_MODULE
 * @{
 */
/*==================================================================================================
 *   Project              : YTMicro AUTOSAR 4.4.0 MCAL
 *   Platform             : ARM
 *   Peripheral           : EWDG
 *   Dependencies         : none
 *
 *   Autosar Version      : V4.4.0
 *   Autosar Revision     : ASR_REL_4_4_REV_0000
 *   Autosar Conf.Variant :
 *   SW Version           : V2.0.0
 *
 *   (c) Copyright 2020-2023 Yuntu Microelectronics co.,ltd. 
 *   All Rights Reserved.
==================================================================================================*/

#ifdef __cplusplus
extern "C"{
#endif

/*==================================================================================================
 *                                          INCLUDE FILES                                          
==================================================================================================*/
#include "Ewdg_Lld.h"

/*==================================================================================================
 *                                 SOURCE FILE VERSION INFORMATION                                 
==================================================================================================*/
#define EWDG_LLD_IRQ_VENDOR_ID_C            (180)
#define EWDG_LLD_IRQ_AR_REL_MAJOR_VER_C     (4)
#define EWDG_LLD_IRQ_AR_REL_MINOR_VER_C     (4)
#define EWDG_LLD_IRQ_AR_REL_REVISION_VER_C  (0)
#define EWDG_LLD_IRQ_SW_MAJOR_VER_C         (2)
#define EWDG_LLD_IRQ_SW_MINOR_VER_C         (0)
#define EWDG_LLD_IRQ_SW_PATCH_VER_C         (0)

/*==================================================================================================
 *                                       FILE VERSION CHECKS                                       
==================================================================================================*/
/* Check if Ewdg_Lld_Irq.c and Ewdg_Lld.h are of the same vendor */
#if (EWDG_LLD_IRQ_VENDOR_ID_C != EWDG_LLD_VENDOR_ID)
#error "Ewdg_Lld_Irq.c and Ewdg_Lld.h have different vendor ids"
#endif

/* Check if Ewdg_Lld_Irq.c and Ewdg_Lld.h are of the same Autosar version */
#if ((EWDG_LLD_IRQ_AR_REL_MAJOR_VER_C != EWDG_LLD_AR_REL_MAJOR_VER) || \
     (EWDG_LLD_IRQ_AR_REL_MINOR_VER_C != EWDG_LLD_AR_REL_MINOR_VER) || \
     (EWDG_LLD_IRQ_AR_REL_REVISION_VER_C != EWDG_LLD_AR_REL_REVISION_VER))
#error "AutoSar Version Numbers of Ewdg_Lld_Irq.c and Ewdg_Lld.h are different"
#endif

/* Check if Ewdg_Lld_Irq.c and Ewdg_Lld.h are of the same software version */
#if ((EWDG_LLD_IRQ_SW_MAJOR_VER_C != EWDG_LLD_SW_MAJOR_VER) || \
     (EWDG_LLD_IRQ_SW_MINOR_VER_C != EWDG_LLD_SW_MINOR_VER) || \
     (EWDG_LLD_IRQ_SW_PATCH_VER_C != EWDG_LLD_SW_PATCH_VER))
#error "Software Version Numbers of Ewdg_Lld_Irq.c and Ewdg_Lld.h are different"
#endif

#if (EWDG_LLD_ENABLE == STD_ON)

#if (EWDG_LLD_RUN_ON_ROM == STD_ON)
#define WDG_START_SEC_CODE
#else
#define WDG_START_SEC_RAMCODE
#endif
#include "Wdg_MemMap.h"

#if (EWDG_LLD_ISR_USED == STD_ON)
/*==================================================================================================
 *                                   GLOBAL FUNCTIONS PROTOTYPES
==================================================================================================*/
WDG_FUNC void Ewdg_Lld_Isr(void);

/*==================================================================================================
 *                                        GLOBAL FUNCTIONS                                         
==================================================================================================*/

/**
 * @brief   EWDG interrupt handler.
 * @details This function handles the EWDG interrupt. The IRQ numbers of EWDG and WDG are the same.
 * @return  void
 */
WDG_FUNC void Ewdg_Lld_Isr(void)
{
    Ewdg_Lld_IrqHandler(0U);
}
#endif /* #if (EWDG_LLD_ISR_USED == STD_ON) */

#if (EWDG_LLD_RUN_ON_ROM == STD_ON)
#define WDG_STOP_SEC_CODE
#else
#define WDG_STOP_SEC_RAMCODE
#endif
#include "Wdg_MemMap.h"

#endif /* #if (EWDG_LLD_ENABLE == STD_ON) */

#ifdef __cplusplus
}
#endif

/** @} */
